/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.edit.ui.internal.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.edit.ui.internal.Activator;
import org.eclipse.emf.facet.efacet.edit.ui.internal.provider.FacetItemPropertyDescriptor;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetPropertySource
extends PropertySource {
    private final AdapterFactoryEditingDomain editingDomain;
    private final Map<String, IItemPropertyDescriptor> itemPropDescs = new HashMap<String, IItemPropertyDescriptor>();
    private final ILabelProvider labelProvider;
    private final IFacetManager facetManager;

    public FacetPropertySource(EObject eObject, IItemPropertySource parentItemPropSrc, AdapterFactoryEditingDomain editingDomain, ILabelProvider labelProvider, IFacetManager facetManager) {
        super((Object)eObject, parentItemPropSrc);
        this.editingDomain = editingDomain;
        this.labelProvider = labelProvider;
        this.facetManager = facetManager;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> propDescriptors = new ArrayList<IPropertyDescriptor>();
        propDescriptors.addAll(Arrays.asList(super.getPropertyDescriptors()));
        propDescriptors.addAll(this.createFacetPropertiesDescriptor());
        return propDescriptors.toArray(new IPropertyDescriptor[propDescriptors.size()]);
    }

    private List<IPropertyDescriptor> createFacetPropertiesDescriptor() {
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        EObject eObject = (EObject)this.object;
        try {
            Set features = FacetUtils.getETypedElements((EObject)eObject, EStructuralFeature.class, (IFacetManager)this.facetManager);
            for (EStructuralFeature feature : features) {
                IPropertyDescriptor propDecriptor = this.createPropertyDecriptor(eObject, feature);
                result.add(propDecriptor);
            }
        }
        catch (FacetManagerException e) {
            String eObjectName = this.labelProvider.getText((Object)eObject);
            TextPropertyDescriptor propDescriptor = new TextPropertyDescriptor((Object)eObjectName, "!!! Failed, cf log !!!");
            result.add((IPropertyDescriptor)propDescriptor);
            String msg = String.format("Can't create FacetItemPropertyDescriptors for the object %s.", eObjectName);
            Logger.logError((Throwable)e, (String)msg, (Plugin)Activator.getDefault());
        }
        return result;
    }

    private IPropertyDescriptor createPropertyDecriptor(EObject eObject, EStructuralFeature feature) {
        TextPropertyDescriptor result = null;
        try {
            Object value = this.facetManager.getOrInvoke(eObject, (ETypedElement)feature, Object.class);
            FacetItemPropertyDescriptor itemPropDesc = new FacetItemPropertyDescriptor(eObject, feature, value, this.editingDomain, this.labelProvider, this.facetManager);
            this.itemPropDescs.put(feature.getName(), itemPropDesc);
            result = new PropertyDescriptor(value, (IItemPropertyDescriptor)itemPropDesc);
        }
        catch (FacetManagerException e) {
            result = new TextPropertyDescriptor((Object)feature.getName(), "!!! Failed, cf log !!!");
            String msg = String.format("Can't create FacetItemPropertyDescriptor for the facet feature %s.", feature.getName());
            Logger.logError((Throwable)e, (String)msg, (Plugin)Activator.getDefault());
        }
        return result;
    }

    public Object getPropertyValue(Object propertyId) {
        Object result = null;
        result = this.itemPropDescs.containsKey(propertyId) ? this.itemPropDescs.get(propertyId).getPropertyValue(propertyId) : super.getPropertyValue(propertyId);
        return result;
    }

    public void setPropertyValue(Object propertyId, Object value) {
        if (this.itemPropDescs.containsKey(propertyId)) {
            this.itemPropDescs.get(propertyId).setPropertyValue(propertyId, value);
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }
}

