/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.junit.Assert;
import org.junit.Test;

public class FacetUtilsTests {
    private static final ResourceSetImpl RESOURCE_SET = new ResourceSetImpl();
    private static final String ROOT_FACET_SET_NAME = "Bug371367";
    private static final String WRITER_FACET_SET_NAME = "writer";
    private static final String BOOK_FACET_SET_NAME = "book";
    private static final String[] UNEXISTING_FACET_SET_PATH = new String[]{"abc", "def", "NoFacetSetWithThisName"};
    private FacetSet libraryFacetSet;
    private FacetSet writerFacetSet;
    private FacetSet bookFacetSet;

    @Test
    public void testGetFacetSetsByPath() throws Exception {
        this.init();
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)RESOURCE_SET);
        List facetSets1 = FacetUtils.getFacetSetsByPath((Collection)catalogMgr.getRegisteredFacetSets(), (String[])new String[]{ROOT_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)facetSets1.size());
        Assert.assertEquals((Object)this.libraryFacetSet, facetSets1.get(0));
        List facetSets2 = FacetUtils.getFacetSetsByPath((Collection)catalogMgr.getRegisteredFacetSets(), (String[])new String[]{ROOT_FACET_SET_NAME, WRITER_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)facetSets2.size());
        Assert.assertEquals((Object)this.writerFacetSet, facetSets2.get(0));
        List facetSets3 = FacetUtils.getFacetSetsByPath((Collection)catalogMgr.getRegisteredFacetSets(), (String[])new String[]{ROOT_FACET_SET_NAME, BOOK_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)facetSets3.size());
        Assert.assertEquals((Object)this.bookFacetSet, facetSets3.get(0));
    }

    @Test
    public void testGetFacetSetsByPathUnexisting() throws Exception {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)RESOURCE_SET);
        List facetSets = FacetUtils.getFacetSetsByPath((Collection)catalogMgr.getRegisteredFacetSets(), (String[])UNEXISTING_FACET_SET_PATH);
        Assert.assertTrue((boolean)facetSets.isEmpty());
    }

    @Test
    public void testGetFacetSetsByPathWithCollection() throws Exception {
        this.init();
        List<FacetSet> rootFacetSets = Collections.singletonList(this.libraryFacetSet);
        List facetSets1 = FacetUtils.getFacetSetsByPath(rootFacetSets, (String[])new String[]{ROOT_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)facetSets1.size());
        Assert.assertEquals((Object)this.libraryFacetSet, facetSets1.get(0));
        List facetSets2 = FacetUtils.getFacetSetsByPath(rootFacetSets, (String[])new String[]{ROOT_FACET_SET_NAME, WRITER_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)facetSets2.size());
        Assert.assertEquals((Object)this.writerFacetSet, facetSets2.get(0));
        List facetSets3 = FacetUtils.getFacetSetsByPath(rootFacetSets, (String[])new String[]{ROOT_FACET_SET_NAME, BOOK_FACET_SET_NAME});
        Assert.assertEquals((long)1L, (long)facetSets3.size());
        Assert.assertEquals((Object)this.bookFacetSet, facetSets3.get(0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFacetSetsByPathEmpty() throws Exception {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)RESOURCE_SET);
        FacetUtils.getFacetSetsByPath((Collection)catalogMgr.getRegisteredFacetSets(), (String[])new String[0]);
    }

    private void init() {
        IFacetSetCatalogManager catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)RESOURCE_SET);
        this.libraryFacetSet = FacetUtils.getFacetSet((Collection)catalogMgr.getRegisteredFacetSets(), (String)ROOT_FACET_SET_NAME);
        this.writerFacetSet = null;
        this.bookFacetSet = null;
        EList eSubpackages = this.libraryFacetSet.getESubpackages();
        Assert.assertEquals((long)2L, (long)eSubpackages.size());
        for (EPackage ePackage : eSubpackages) {
            if (WRITER_FACET_SET_NAME.equals(ePackage.getName())) {
                this.writerFacetSet = (FacetSet)ePackage;
                continue;
            }
            if (BOOK_FACET_SET_NAME.equals(ePackage.getName())) {
                this.bookFacetSet = (FacetSet)ePackage;
                continue;
            }
            Assert.fail();
        }
        Assert.assertNotNull((Object)this.writerFacetSet);
        Assert.assertNotNull((Object)this.bookFacetSet);
    }
}

