/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread.Bug387008Test;
import org.eclipse.emf.facet.widgets.table.ui.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.ITableWidgetFactory;
import org.eclipse.emf.facet.widgets.table.ui.TableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bug380293Test {
    private static final String BUG_ID = "Bug380293";
    private Shell sheel = null;

    @Test
    public void columnsInEmptyTable() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TableConfiguration tableConfig = Bug380293Test.getTableConfiguration((ResourceSet)resourceSet);
        Table table = Bug380293Test.getTable((ResourceSet)resourceSet, new ArrayList(), tableConfig);
        this.openTableInAShell(table);
        int index = 0;
        for (ETypedElement typedElt : tableConfig.getDefaultColumns()) {
            Column column = (Column)table.getColumns().get(index);
            if (column instanceof FeatureColumn) {
                FeatureColumn fColumn = (FeatureColumn)column;
                Assert.assertEquals((String)"The column order provided by the table configuration is not respeted", (Object)typedElt, (Object)fColumn.getFeature());
                ++index;
                continue;
            }
            Assert.fail((String)"Only feature columns are expected.");
        }
    }

    protected void openTableInAShell(final Table table) {
        final Shell[] sheelPtr = new Shell[1];
        final ITableWidget[] tableWidgetPtr = new ITableWidget[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                sheelPtr[0] = new Shell(Display.getDefault(), 65728);
                tableWidgetPtr[0] = ITableWidgetFactory.INSTANCE.createTableWidget((Composite)sheelPtr[0], null, table, null);
                ((ITableWidgetInternal)tableWidgetPtr[0]).getComposite().setLayoutData((Object)new GridData(1808));
                sheelPtr[0].setLayout((Layout)new GridLayout(1, true));
                sheelPtr[0].open();
            }
        });
        this.sheel = sheelPtr[0];
    }

    private static Table getTable(ResourceSet resourceSet, List<? extends EObject> eObjects, TableConfiguration tableConfig) {
        URI tableUri = URI.createPlatformResourceURI((String)("/" + Bug387008Test.class.getName() + "/table.xmi"), (boolean)true);
        Resource tableResouce = resourceSet.createResource(tableUri);
        Table table = TableUtils.createTableInstance(eObjects, (String)Bug387008Test.class.getSimpleName(), (TableConfiguration)tableConfig, null, null);
        tableResouce.getContents().add((Object)table);
        return table;
    }

    private static TableConfiguration getTableConfiguration(ResourceSet resourceSet) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        URI tableConfigUri = URI.createPlatformPluginURI((String)("/" + bundleName + "/resources/v0_2/" + BUG_ID + "/" + BUG_ID + ".tableconfiguration"), (boolean)true);
        return (TableConfiguration)resourceSet.getResource(tableConfigUri, true).getContents().get(0);
    }

    @After
    public void after() {
        if (this.sheel != null) {
            final Shell fShell = this.sheel;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    fShell.close();
                }
            });
        }
    }
}

