/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import junit.framework.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.tests.internal.Activator;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.junit.Test;

public class LabelProviderTest {
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private static final String CUSTOM_FILE = "org.eclipse.emf.facet.custom.tests.labelprovider.custom";

    @Test
    public void test() {
        ICustomizationManager customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.resourceSet);
        ICustomizedLabelProvider labelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customManager);
        EClass element = EcorePackage.eINSTANCE.getEObject();
        String label = labelProvider.getText((Object)element);
        Assert.assertNotNull((String)"The default label must not be null.", (Object)label);
        Font font = labelProvider.getFont((Object)element);
        Assert.assertNotNull((String)"The default font must not be null.", (Object)font);
        Assert.assertNotNull((String)"The default font name must not be null", (Object)font.getFontData()[0].getName());
        Assert.assertTrue((String)"The default font size must not be negative.", (font.getFontData()[0].getHeight() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The default font must not be bold.", (int)0, (int)(font.getFontData()[0].getStyle() & 1));
        Assert.assertEquals((String)"The default font must not be italic.", (int)0, (int)(font.getFontData()[0].getStyle() & 2));
        Color background = labelProvider.getBackground((Object)element);
        Assert.assertNotNull((String)"The default background color must not be null.", (Object)background);
        Color foreground = labelProvider.getForeground((Object)element);
        Assert.assertNotNull((String)"The default foreground color must not be null.", (Object)foreground);
    }

    @Test
    public void test2() throws CustomizationException {
        ICustomizationManager customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.resourceSet);
        Customization customization = this.loadCustomization(CUSTOM_FILE);
        customManager.getManagedCustomizations().add(0, customization);
        ICustomizedLabelProvider labelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customManager);
        EClass element = EcorePackage.eINSTANCE.getEObject();
        String label = labelProvider.getText((Object)element);
        Assert.assertEquals((String)"Wrong customized label.", (String)"hello", (String)label);
        Font font = labelProvider.getFont((Object)element);
        Assert.assertNotNull((String)"The default font must not be null.", (Object)font);
        Assert.assertNotNull((String)"The default font name must not be null", (Object)font.getFontData()[0].getName());
        Assert.assertTrue((String)"The default font size must not be negative.", (font.getFontData()[0].getHeight() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"The default font must not be bold.", (int)0, (int)(font.getFontData()[0].getStyle() & 1));
        Assert.assertEquals((String)"The default font must not be italic.", (int)0, (int)(font.getFontData()[0].getStyle() & 2));
        Color background = labelProvider.getBackground((Object)element);
        Assert.assertNotNull((String)"The default background color must not be null.", (Object)background);
        Color foreground = labelProvider.getForeground((Object)element);
        Assert.assertNotNull((String)"The default foreground color must not be null.", (Object)foreground);
    }

    private Customization loadCustomization(String string) {
        URI uri = URI.createPlatformPluginURI((String)Activator.getDefault().getBundle().getSymbolicName(), (boolean)true);
        uri = uri.appendSegments("resources".split("/"));
        uri = uri.appendSegments(string.split("/"));
        Resource resource = this.resourceSet.getResource(uri, true);
        EObject root = (EObject)resource.getContents().get(0);
        Customization custom = null;
        if (root instanceof Customization) {
            custom = (Customization)root;
        }
        Assert.assertNotNull((String)"We should find a customization", (Object)custom);
        return custom;
    }
}

