/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandler;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IPositionCoordinate;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.SyncException;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedTableWidgetController
implements ITableWidgetInternal {
    private final ITableWidgetInternal nattableWidget;
    private final Thread widgetThread;
    private final Display display;

    public SynchronizedTableWidgetController(ITableWidgetInternal nattableWidget, Display display) {
        this.display = display;
        this.nattableWidget = nattableWidget;
        this.widgetThread = display.getThread();
    }

    private <T, E extends Exception> T syncExecWithResult(final Runnable<T, E> runnable) throws E {
        Object result;
        if (this.widgetThread == Thread.currentThread()) {
            result = runnable.run();
        } else {
            final Exception[] exceptionHandler = new Exception[1];
            final Object[] resultHandler = new Object[1];
            this.display.syncExec(new java.lang.Runnable(){

                public void run() {
                    try {
                        resultHandler[0] = runnable.run();
                    }
                    catch (Exception e) {
                        exceptionHandler[0] = e;
                    }
                }
            });
            if (exceptionHandler[0] != null) {
                Exception castException = exceptionHandler[0];
                throw castException;
            }
            Object tmpResult = resultHandler[0];
            result = tmpResult;
        }
        return result;
    }

    private <E extends Exception> void voidSyncExec(AbstractVoidRunnable<E> runnable) throws E {
        this.syncExecWithResult(runnable);
    }

    private <T> T safeSyncExec(AbstractExceptionFreeRunnable<T> runnable) {
        try {
            return this.syncExecWithResult(runnable);
        }
        catch (Exception e) {
            throw new SyncException(e);
        }
    }

    private void voidExceptionFreeRunnable(AbstractVoidExceptionFreeRunnable runnable) {
        try {
            this.syncExecWithResult(runnable);
        }
        catch (Exception e) {
            throw new SyncException(e);
        }
    }

    public void addSelectionChangedListener(final ISelectionChangedListener listener) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().addSelectionChangedListener(listener);
            }
        });
    }

    public ISelection getSelection() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<ISelection>(this){

            @Override
            protected ISelection safeRun() {
                return this.getNattableWidget().getSelection();
            }
        });
    }

    public void removeSelectionChangedListener(final ISelectionChangedListener listener) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().removeSelectionChangedListener(listener);
            }
        });
    }

    public void setSelection(final ISelection selection) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setSelection(selection);
            }
        });
    }

    @Override
    public void createNewElement() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().createNewElement();
            }
        });
    }

    @Override
    public void createNewElement(final InstantiationMethod instantiationMethod) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().createNewElement(instantiationMethod);
            }
        });
    }

    @Override
    public void selectInstantiationMethodToLaunch() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().selectInstantiationMethodToLaunch();
            }
        });
    }

    @Override
    public void save() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().save();
            }
        });
    }

    @Override
    public void saveAs() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().saveAs();
            }
        });
    }

    @Override
    public void copySelectionToClipboard() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().copySelectionToClipboard();
            }
        });
    }

    @Override
    public void deleteSelection() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().deleteSelection();
            }
        });
    }

    @Override
    public void selectColumnsToHide() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().selectColumnsToHide();
            }
        });
    }

    @Override
    public void setHideEmptyColumns(final boolean hideEmptyColumns) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setHideEmptyColumns(hideEmptyColumns);
            }
        });
    }

    @Override
    public void setOnlyShowCommonColumns(final boolean showCommonColumns) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setOnlyShowCommonColumns(showCommonColumns);
            }
        });
    }

    @Override
    public void sortColumnsByType() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().sortColumnsByType();
            }
        });
    }

    @Override
    public void removeLine() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().removeLine();
            }
        });
    }

    @Override
    public void selectAll() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().selectAll();
            }
        });
    }

    @Override
    public TableConfiguration getTableConfiguration() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<TableConfiguration>(this){

            @Override
            protected TableConfiguration safeRun() {
                return this.getNattableWidget().getTableConfiguration();
            }
        });
    }

    @Override
    public List<InstantiationMethod> getInstantiationMethodHistory() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<InstantiationMethod>>(this){

            @Override
            protected List<InstantiationMethod> safeRun() {
                return this.getNattableWidget().getInstantiationMethodHistory();
            }
        });
    }

    @Override
    public Table getTable() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Table>(this){

            @Override
            protected Table safeRun() {
                return this.getNattableWidget().getTable();
            }
        });
    }

    @Override
    public boolean isCellSelected() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().isCellSelected();
            }
        });
    }

    @Override
    public boolean isColumnSelected() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().isColumnSelected();
            }
        });
    }

    @Override
    public Control getComposite() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Control>(this){

            @Override
            protected Control safeRun() {
                return this.getNattableWidget().getComposite();
            }
        });
    }

    @Override
    public void addRows(final List<? extends EObject> newElements) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().addRows(newElements);
            }
        });
    }

    @Override
    public void unregisterActionDelegate(final IActionDelegate action) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().unregisterActionDelegate(action);
            }
        });
    }

    @Override
    public void openLoadCustomizationDialog() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().openLoadCustomizationDialog();
            }
        });
    }

    @Override
    public void openLoadFacetSetsDialog() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().openLoadFacetSetsDialog();
            }
        });
    }

    @Override
    public void sortColumnByNameAtoZ() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().sortColumnByNameAtoZ();
            }
        });
    }

    @Override
    public void sortColumnByNameZtoA() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().sortColumnByNameZtoA();
            }
        });
    }

    @Override
    public void setFacetSets(final List<? extends FacetSet> facetSets) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setFacetSets(facetSets);
            }
        });
    }

    @Override
    public void selectCell(final EObject eObject, final EStructuralFeature structuralFeature) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().selectCell(eObject, structuralFeature);
            }
        });
    }

    @Override
    public void editSelectedCell() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().editSelectedCell();
            }
        });
    }

    @Override
    public void showHideColumns(final List<Column> selectedColumns, final boolean putOnTheTop) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().showHideColumns(selectedColumns, putOnTheTop);
            }
        });
    }

    @Override
    public boolean isOneOfTheLocalCustomizationsNotOnTheTop() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().isOneOfTheLocalCustomizationsNotOnTheTop();
            }
        });
    }

    @Override
    public List<Column> getVisibleColumns(final boolean setAtTheTop) {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<Column>>(this){

            @Override
            protected List<Column> safeRun() {
                return this.getNattableWidget().getVisibleColumns(setAtTheTop);
            }
        });
    }

    @Override
    public void putLocalCustomizationOnTheTop() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().putLocalCustomizationOnTheTop();
            }
        });
    }

    @Override
    public void putLocalCustomizationOnTheBottom() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().putLocalCustomizationOnTheBottom();
            }
        });
    }

    @Override
    public boolean isSelectedCellEditable() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().isSelectedCellEditable();
            }
        });
    }

    @Override
    public void selectRows(final List<EObject> elementsToSelect, final boolean clearTheSelection) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().selectRows(elementsToSelect, clearTheSelection);
            }
        });
    }

    @Override
    public IColumnsToHideDialog openColumnsToHideDialog() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<IColumnsToHideDialog>(this){

            @Override
            protected IColumnsToHideDialog safeRun() {
                return this.getNattableWidget().openColumnsToHideDialog();
            }
        });
    }

    @Override
    public ICustomizedLabelProvider getTableLabelProvider() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<ICustomizedLabelProvider>(this){

            @Override
            protected ICustomizedLabelProvider safeRun() {
                return this.getNattableWidget().getTableLabelProvider();
            }
        });
    }

    @Override
    public void waitForRefreshJob() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().waitForRefreshJob();
            }
        });
    }

    @Override
    public IFacetManager getFacetContext() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<IFacetManager>(this){

            @Override
            protected IFacetManager safeRun() {
                return this.getNattableWidget().getFacetContext();
            }
        });
    }

    @Override
    public boolean usesTmpResource() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().usesTmpResource();
            }
        });
    }

    @Override
    public List<IPositionCoordinate> getSelectedCellsPositions() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<IPositionCoordinate>>(this){

            @Override
            protected List<IPositionCoordinate> safeRun() {
                return this.getNattableWidget().getSelectedCellsPositions();
            }
        });
    }

    public ITableWidgetInternal getNattableWidget() {
        return this.nattableWidget;
    }

    public Display getDisplay() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Display>(this){

            @Override
            protected Display safeRun() {
                return display;
            }
        });
    }

    @Override
    public void setCanBePresentedInTheTable(final ETypedElement query, final boolean removeNonConformElements) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setCanBePresentedInTheTable(query, removeNonConformElements);
            }
        });
    }

    @Override
    public ETypedElement getCanBePresentedInTheTable() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<ETypedElement>(this){

            @Override
            protected ETypedElement safeRun() {
                return this.getNattableWidget().getCanBePresentedInTheTable();
            }
        });
    }

    @Override
    public EditingDomain getEditingDomain() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<EditingDomain>(this){

            @Override
            protected EditingDomain safeRun() {
                return this.getNattableWidget().getEditingDomain();
            }
        });
    }

    @Override
    public IAllowedContentsETypedElementSelectionDialog openCanBePresentedInTheTableDialog() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<IAllowedContentsETypedElementSelectionDialog>(this){

            @Override
            protected IAllowedContentsETypedElementSelectionDialog safeRun() {
                return this.getNattableWidget().openCanBePresentedInTheTableDialog();
            }
        });
    }

    @Override
    public List<ETypedElement> getApplicableCanBePresentedQueries() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<ETypedElement>>(this){

            @Override
            protected List<ETypedElement> safeRun() {
                return this.getNattableWidget().getApplicableCanBePresentedQueries();
            }
        });
    }

    @Override
    public void setColumnWidth(final Column column, final int width) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setColumnWidth(column, width);
            }
        });
    }

    @Override
    public void setRowHeight(final Row row, final int height) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setRowHeight(row, height);
            }
        });
    }

    @Override
    public void moveColumn(final Column element, final int newPosition) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().moveColumn(element, newPosition);
            }
        });
    }

    @Override
    public boolean isDataEditable() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().isDataEditable();
            }
        });
    }

    @Override
    public ICustomizationManager getCustomizationEngine() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<ICustomizationManager>(this){

            @Override
            protected ICustomizationManager safeRun() {
                return this.getNattableWidget().getCustomizationEngine();
            }
        });
    }

    @Override
    public void tableSelectionChanged() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().tableSelectionChanged();
            }
        });
    }

    @Override
    public MenuManager getMenuManager() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<MenuManager>(this){

            @Override
            protected MenuManager safeRun() {
                return this.getNattableWidget().getMenuManager();
            }
        });
    }

    @Override
    public void notifyActions() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().notifyActions();
            }
        });
    }

    @Override
    public List<Column> getColumns() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<List<Column>>(this){

            @Override
            protected List<Column> safeRun() {
                return this.getNattableWidget().getColumns();
            }
        });
    }

    @Override
    public boolean isNonCommonColumns(final Column column) {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().isNonCommonColumns(column);
            }
        });
    }

    @Override
    public boolean isEmptyColumn(final Column column) {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().isEmptyColumn(column);
            }
        });
    }

    @Override
    public Row findRow(final EObject eObject) {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Row>(this){

            @Override
            protected Row safeRun() {
                return this.getNattableWidget().findRow(eObject);
            }
        });
    }

    @Override
    public boolean getListenReorderEvent() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().getListenReorderEvent();
            }
        });
    }

    @Override
    public boolean canBeDropped(final IStructuredSelection structuredSelection, final EStructuralFeature feature, final Object element) {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<Boolean>(this){

            @Override
            protected Boolean safeRun() {
                return this.getNattableWidget().canBeDropped(structuredSelection, feature, element);
            }
        });
    }

    @Override
    public void drop(final StructuredSelection structuredSelection, final Object element, final EStructuralFeature feature) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().drop(structuredSelection, element, feature);
            }
        });
    }

    @Override
    public void drop(final StructuredSelection structuredSelection) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().drop(structuredSelection);
            }
        });
    }

    @Override
    public void loadCustomizations(final List<Customization> customizationsToLoad, final boolean mustLoadAdditionalFacets) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().loadCustomizations(customizationsToLoad, mustLoadAdditionalFacets);
            }
        });
    }

    @Override
    public IContentPropertiesHandler getCustomPropertiesHandler() {
        return this.safeSyncExec(new AbstractExceptionFreeRunnable<IContentPropertiesHandler>(this){

            @Override
            protected IContentPropertiesHandler safeRun() {
                return this.getNattableWidget().getCustomPropertiesHandler();
            }
        });
    }

    @Override
    public void undo() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().undo();
            }
        });
    }

    @Override
    public void redo() {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().redo();
            }
        });
    }

    @Override
    public void setLoadedFacetSets(final List<FacetSet> facetSets) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().setLoadedFacetSets(facetSets);
            }
        });
    }

    public IETypedElementSelectionDialog openAddColumnsDialog() {
        return (IETypedElementSelectionDialog)this.safeSyncExec(new AbstractExceptionFreeRunnable(this){

            protected IETypedElementSelectionDialog safeRun() {
                return this.getNattableWidget().openAddColumnsDialog();
            }
        });
    }

    @Override
    public void sortRows(final Column column, final ColumnSortDirection direction) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().sortRows(column, direction);
            }
        });
    }

    @Override
    public List<Object> getRawSelection() {
        return (List)this.safeSyncExec(new AbstractExceptionFreeRunnable(this){

            protected List<Object> safeRun() {
                return this.getNattableWidget().getRawSelection();
            }
        });
    }

    @Override
    public void addColumns(final List<ETypedElement> eTypedElements, final List<FacetSet> facetSets) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().addColumns(eTypedElements, facetSets);
            }
        });
    }

    @Override
    public void removeColumns(final List<ETypedElement> elements) {
        this.voidExceptionFreeRunnable(new AbstractVoidExceptionFreeRunnable(this){

            protected void voidSafeRun() {
                this.getNattableWidget().removeColumns(elements);
            }
        });
    }

    @Override
    public List<EObject> getSelectedRowEObjects() {
        return (List)this.safeSyncExec(new AbstractExceptionFreeRunnable(this){

            protected List<EObject> safeRun() {
                return this.getNattableWidget().getSelectedRowEObjects();
            }
        });
    }

    @Override
    public ITableCommandFactory getTableCommandFactory() {
        return (ITableCommandFactory)this.safeSyncExec(new AbstractExceptionFreeRunnable(this){

            protected ITableCommandFactory safeRun() {
                return this.getNattableWidget().getTableCommandFactory();
            }
        });
    }

    @Override
    public ISelectionPropertiesHandler getSelectionPropertiesHandler() {
        return (ISelectionPropertiesHandler)this.safeSyncExec(new AbstractExceptionFreeRunnable(this){

            protected ISelectionPropertiesHandler safeRun() {
                return this.getNattableWidget().getSelectionPropertiesHandler();
            }
        });
    }

    @Override
    public List<Column> getSelectedColumns() {
        return (List)this.safeSyncExec(new AbstractExceptionFreeRunnable(this){

            protected List<Column> safeRun() {
                return this.getNattableWidget().getSelectedColumns();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractExceptionFreeRunnable<T>
    implements Runnable<T, Exception> {
        private AbstractExceptionFreeRunnable() {
        }

        protected abstract T safeRun();

        @Override
        public T run() {
            return this.safeRun();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractVoidExceptionFreeRunnable
    implements Runnable<Object, Exception> {
        private AbstractVoidExceptionFreeRunnable() {
        }

        protected abstract void voidSafeRun();

        @Override
        public Object run() {
            this.voidSafeRun();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractVoidRunnable<E extends Exception>
    implements Runnable<Object, E> {
        private AbstractVoidRunnable() {
        }

        protected abstract void voidRun() throws E;

        @Override
        public Object run() throws E {
            this.voidRun();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Runnable<T, E extends Exception> {
        public T run() throws E;
    }
}

