/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style.editor.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import net.sourceforge.nattable.persistence.IPersistable;
import net.sourceforge.nattable.persistence.StylePersistor;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.Style;
import net.sourceforge.nattable.style.editor.ColumnStyleEditorDialog;
import net.sourceforge.nattable.style.editor.command.DisplayColumnStyleEditorCommand;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayColumnStyleEditorCommandHandler
extends AbstractLayerCommandHandler<DisplayColumnStyleEditorCommand>
implements IPersistable {
    protected static final String PERSISTENCE_PREFIX = "userDefinedColumnStyle";
    protected static final String USER_EDITED_STYLE_LABEL = "USER_EDITED_STYLE_FOR_INDEX_";
    protected ColumnOverrideLabelAccumulator columnLabelAccumulator;
    protected ColumnStyleEditorDialog dialog;
    private final IConfigRegistry configRegistry;
    protected final Map<String, Style> stylesToPersist = new HashMap<String, Style>();

    public DisplayColumnStyleEditorCommandHandler(ColumnOverrideLabelAccumulator labelAccumulator, IConfigRegistry configRegistry) {
        this.columnLabelAccumulator = labelAccumulator;
        this.configRegistry = configRegistry;
    }

    @Override
    public boolean doCommand(DisplayColumnStyleEditorCommand command) {
        ILayer nattableLayer = command.getNattableLayer();
        int columnIndex = nattableLayer.getColumnIndexByPosition(command.columnPosition);
        Style slectedCellStyle = (Style)this.configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", USER_EDITED_STYLE_LABEL + columnIndex);
        this.dialog = new ColumnStyleEditorDialog(Display.getCurrent().getActiveShell(), slectedCellStyle);
        this.dialog.open();
        if (this.dialog.isCancelPressed()) {
            return true;
        }
        this.applySelectedStyleToColumn(command, columnIndex);
        return true;
    }

    @Override
    public Class<DisplayColumnStyleEditorCommand> getCommandClass() {
        return DisplayColumnStyleEditorCommand.class;
    }

    protected void applySelectedStyleToColumn(DisplayColumnStyleEditorCommand command, int columnIndex) {
        Style newColumnCellStyle = this.dialog.getNewColumCellStyle();
        if (newColumnCellStyle == null) {
            this.stylesToPersist.remove(this.getConfigLabel(columnIndex));
        } else {
            newColumnCellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.dialog.getNewColumnBorderStyle());
            this.stylesToPersist.put(this.getConfigLabel(columnIndex), newColumnCellStyle);
        }
        this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, newColumnCellStyle, "NORMAL", this.getConfigLabel(columnIndex));
        this.columnLabelAccumulator.registerColumnOverrides(columnIndex, this.getConfigLabel(columnIndex));
    }

    protected String getConfigLabel(int columnIndex) {
        return USER_EDITED_STYLE_LABEL + columnIndex;
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyString = (String)key;
            if (!keyString.contains(PERSISTENCE_PREFIX)) continue;
            int colIndex = this.parseColumnIndexFromKey(keyString);
            if (this.stylesToPersist.keySet().contains(this.getConfigLabel(colIndex))) continue;
            Style savedStyle = StylePersistor.loadStyle(String.valueOf(prefix) + "." + this.getConfigLabel(colIndex), properties);
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, savedStyle, "NORMAL", this.getConfigLabel(colIndex));
            this.stylesToPersist.put(this.getConfigLabel(colIndex), savedStyle);
        }
    }

    protected int parseColumnIndexFromKey(String keyString) {
        int colLabelStartIndex = keyString.indexOf(USER_EDITED_STYLE_LABEL);
        String columnConfigLabel = keyString.substring(colLabelStartIndex, keyString.indexOf(46, colLabelStartIndex));
        int lastUnderscoreInLabel = columnConfigLabel.lastIndexOf(95, colLabelStartIndex);
        return Integer.parseInt(columnConfigLabel.substring(lastUnderscoreInLabel + 1));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        for (Map.Entry<String, Style> labelToStyle : this.stylesToPersist.entrySet()) {
            Style style = labelToStyle.getValue();
            String label = labelToStyle.getKey();
            StylePersistor.saveStyle(String.valueOf(prefix) + "." + label, properties, style);
        }
    }
}

