/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import java.util.List;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.emf.facet.custom.ui.internal.exported.ILabelPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.internal.exported.ILabelPropertiesHandlerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.junit.Before;
import org.junit.Test;

public class Bug418885 {
    private static final String MAIN_NODE_LABEL = "main node";
    private static final String EANNO_NODE_LABEL = "eAnnotation node";
    private List<Customization> registeredCustoms;
    private ICustomizationManager customManager;
    private Customization customization = null;

    @Before
    public void before() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        ICustomizationCatalogManager customCatalogMgr = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)resourceSet);
        this.registeredCustoms = customCatalogMgr.getRegisteredCustomizations();
        this.customManager = ICustomizationManagerFactory.DEFAULT.createICustomizationManager(facetManager);
        for (Customization candidate : this.registeredCustoms) {
            if (!candidate.getName().equals(this.getClass().getName())) continue;
            this.customization = candidate;
        }
        String message = String.format("The customization %s must be registered", this.getClass().getName());
        Assert.assertNotNull((String)message, (Object)this.customization);
    }

    @Test
    public void test1() {
        this.customManager.getManagedCustomizations().add(this.customization);
        EClass eClass = EcorePackage.eINSTANCE.getEClass();
        ICustomizedLabelProvider labelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(this.customManager);
        String label = labelProvider.getText((Object)eClass);
        Assert.assertEquals((String)"The expeted node label is : main node", (String)MAIN_NODE_LABEL, (String)label);
    }

    @Test
    public void test2() {
        this.customManager.getManagedCustomizations().add(this.customization);
        EClass eClass = EcorePackage.eINSTANCE.getEClass();
        ILabelPropertiesHandler propertiesHandler = ILabelPropertiesHandlerFactory.DEFAULT.createLabelPropertiesHandler(this.customManager);
        FacetOperation property = propertiesHandler.getLabelProperty();
        EReference eAnnotationsRef = EcorePackage.eINSTANCE.getEModelElement_EAnnotations();
        String label = (String)CustomizationUtils.getPropertyValue((ICustomizationManager)this.customManager, (Object)eClass, (FacetOperation)property, (ETypedElement)eAnnotationsRef, String.class);
        Assert.assertEquals((String)"The expeted node label is : eAnnotation node", (String)EANNO_NODE_LABEL, (String)label);
    }
}

