/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.exported;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.ValueColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.workbench.expression.TableTester;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;

public final class TableWidgetInternalUtils {
    private TableWidgetInternalUtils() {
    }

    public static String getColumnName(Column column) {
        return TableWidgetInternalUtils.getLabel(column, new StucturalFeatureLabelProvider());
    }

    public static String getLabel(Column column, ILabelProvider labelProvider) {
        String columnName;
        if (column instanceof SourceColumn) {
            columnName = Messages.NatTableWidget_queryContext;
        } else if (column instanceof FeatureColumn) {
            FeatureColumn featureColumn = (FeatureColumn)column;
            ETypedElement eTypedElement = featureColumn.getFeature();
            if (eTypedElement instanceof EStructuralFeature) {
                EStructuralFeature structuralFeature = (EStructuralFeature)eTypedElement;
                columnName = labelProvider.getText((Object)structuralFeature);
            } else {
                columnName = eTypedElement.getName();
            }
        } else if (column instanceof ValueColumn) {
            columnName = "Value";
        } else {
            Logger.logWarning((String)"Unhandled column description type", (Plugin)Activator.getDefault());
            columnName = "";
        }
        return columnName;
    }

    public static String getLabel(Column column, ITableWidgetInternal tableWidgetCtrler) {
        ICustomizedLabelProvider labelProvider = tableWidgetCtrler.getTableLabelProvider();
        return TableWidgetInternalUtils.getLabel(column, (ILabelProvider)labelProvider);
    }

    public static ETypedElement getPresentabilityQuery(Table tableInstance) {
        TableConfiguration tableConfiguration;
        ETypedElement presentabilityQuery = null;
        presentabilityQuery = tableInstance.getCanBePresentedInTheTable();
        if (presentabilityQuery == null && (tableConfiguration = tableInstance.getTableConfiguration()) != null) {
            presentabilityQuery = tableConfiguration.getCanBePresentedInTheTable();
        }
        return presentabilityQuery;
    }

    public static boolean testIsTableEditor(IWorkbenchPart part) {
        return TableTester.testIsTableEditor(part);
    }

    protected static final class StucturalFeatureLabelProvider
    implements ILabelProvider {
        protected StucturalFeatureLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            String result = element.toString();
            if (element instanceof EStructuralFeature) {
                EStructuralFeature structuralFeature = (EStructuralFeature)element;
                result = structuralFeature.getName();
            }
            return result;
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

