/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.aggregate.tests.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialog;
import org.eclipse.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialogFactory;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IQuestionDialog;
import org.junit.Assert;
import org.junit.Test;

public class LoadCustomizationsDialogTests {
    @Test
    public void testLoadAggregate() {
        ICustomizationCatalogManager catalogManager = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)new ResourceSetImpl());
        List availableCustoms = catalogManager.getRegisteredCustomizations();
        final Customization aggregate = CustomizationUtils.getCustomization((Collection)availableCustoms, (String)"Bug372626_Aggregates_aggregate");
        final boolean[] ok = new boolean[1];
        IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog> callback = new IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog>(){

            public IQuestionDialog openPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
                return null;
            }

            public void committed(List<Customization> selection, Boolean precommitResult) {
                Assert.assertEquals((String)"only the aggregate must be loaded", (long)1L, (long)selection.size());
                Assert.assertEquals((String)"the aggregate must be loaded", (Object)aggregate, (Object)selection.get(0));
                ok[0] = true;
            }
        };
        ILoadCustomizationsDialog dialog = ILoadCustomizationsDialogFactory.DEFAULT.createLoadCustomizationDialog(null, availableCustoms, Collections.emptyList(), (IDialogCallbackWithPreCommit)callback);
        dialog.asyncOpen();
        dialog.selectAvailableCustom(aggregate);
        dialog.loadSelectedCustoms();
        List selectedCustomizations = dialog.getSelectedCustomizations();
        Assert.assertEquals((String)"only the aggregate must be selected", (long)1L, (long)selectedCustomizations.size());
        Assert.assertEquals((String)"the aggregate must be selected", (Object)aggregate, selectedCustomizations.get(0));
        dialog.pressOk();
        Assert.assertTrue((String)"must receive the okPressed event", (boolean)ok[0]);
    }

    @Test
    public void testUnloadAggregate() {
        ICustomizationCatalogManager catalogManager = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager((ResourceSet)new ResourceSetImpl());
        final List availableCustoms = catalogManager.getRegisteredCustomizations();
        final Customization aggregate = CustomizationUtils.getCustomization((Collection)availableCustoms, (String)"Bug372626_Aggregates_aggregate");
        final boolean[] ok = new boolean[1];
        IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog> callback = new IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog>(){

            public IQuestionDialog openPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
                return null;
            }

            public void committed(List<Customization> selection, Boolean precommitResult) {
                Assert.assertEquals((String)"only the aggregate must be unloaded", (long)(availableCustoms.size() - 1), (long)selection.size());
                Assert.assertFalse((String)"the aggregate must be unloaded", (boolean)selection.contains(aggregate));
                ok[0] = true;
            }
        };
        ILoadCustomizationsDialog dialog = ILoadCustomizationsDialogFactory.DEFAULT.createLoadCustomizationDialog(null, availableCustoms, availableCustoms, (IDialogCallbackWithPreCommit)callback);
        dialog.asyncOpen();
        dialog.selectSelectedCustom(aggregate);
        dialog.unloadSelectedCustoms();
        List selectedCustomizations = dialog.getSelectedCustomizations();
        Assert.assertEquals((String)"only the aggregate must be unselected", (long)(availableCustoms.size() - 1), (long)selectedCustomizations.size());
        Assert.assertFalse((String)"the aggregate must be unselected", (boolean)selectedCustomizations.contains(aggregate));
        dialog.pressOk();
        Assert.assertTrue((String)"must receive the okPressed event", (boolean)ok[0]);
    }
}

