/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectProperties
extends Properties<EObject> {
    public static final IProperties<EObject> INSTANCE = new ObjectProperties();
    private static final String CATEGORY_CDO = "CDO";

    private ObjectProperties() {
        super(EObject.class);
        this.add((Property)new Property<EObject>("id", "ID", "The technical CDOID of this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoID();
            }
        });
        this.add((Property)new Property<EObject>("state", "State", "The current state of this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoState();
            }
        });
        this.add((Property)new Property<EObject>("transactional"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                return !view.isReadOnly();
            }
        });
        this.add((Property)new Property<EObject>("readable"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return true;
                }
                if (cdoObject.cdoPermission() != CDOPermission.NONE) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("writable"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return true;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return true;
                }
                if (!view.isReadOnly() && cdoObject.cdoPermission() == CDOPermission.WRITE) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("writableContainer"){

            protected Object eval(EObject object) {
                Resource resource;
                CDOObject cdoObject = null;
                EObject eContainer = object.eContainer();
                if (eContainer != null) {
                    cdoObject = CDOUtil.getCDOObject(eContainer);
                }
                if (cdoObject == null && (resource = object.eResource()) instanceof CDOObject) {
                    cdoObject = (CDOObject)resource;
                }
                if (cdoObject == null) {
                    return true;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return true;
                }
                if (!view.isReadOnly() && cdoObject.cdoPermission() == CDOPermission.WRITE) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("permission", "Permission", "The permission the current user has for this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoPermission();
            }
        });
        this.add((Property)new Property<EObject>("permissionContainer"){

            protected Object eval(EObject object) {
                Resource resource;
                CDOObject cdoObject = null;
                EObject eContainer = object.eContainer();
                if (eContainer != null) {
                    cdoObject = CDOUtil.getCDOObject(eContainer);
                }
                if (cdoObject == null && (resource = object.eResource()) instanceof CDOObject) {
                    cdoObject = (CDOObject)resource;
                }
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoPermission();
            }
        });
        this.add((Property)new Property<EObject>("readLocks", "Read Locks", "The owner of read locks on this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                CDOLockState lockState = cdoObject.cdoLockState();
                if (lockState == null) {
                    return null;
                }
                return lockState.getReadLockOwners();
            }
        });
        this.add((Property)new Property<EObject>("writeLock", "Write Lock", "The owner of a write lock on this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                CDOLockState lockState = cdoObject.cdoLockState();
                if (lockState == null) {
                    return null;
                }
                return lockState.getWriteLockOwner();
            }
        });
        this.add((Property)new Property<EObject>("writeOption", "Write Option", "The owner of a write option on this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                CDOLockState lockState = cdoObject.cdoLockState();
                if (lockState == null) {
                    return null;
                }
                return lockState.getWriteOptionOwner();
            }
        });
        this.add((Property)new Property<EObject>("viewHistorical"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = CDOUtil.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                if (view.getTimeStamp() != 0L) {
                    return true;
                }
                return false;
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tester
    extends DefaultPropertyTester<EObject> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.object";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

