/*******************************************************************************
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 *******************************************************************************/

package org.eclipse.emf.parsley.dialogs;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.factories.FormFactory;
import org.eclipse.emf.parsley.widgets.AbstractDetailComposite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import com.google.inject.Inject;

/**
 * @author Lorenzo Bettini - Initial contribution and API
 */
public class DetailFormBasedDialog extends AbstractDetailDialog {

	@Inject
	private FormFactory formFactory;

	public DetailFormBasedDialog(Shell parentShell, String title,
			EObject original, EditingDomain domain) {
		super(parentShell, title, original, domain);
	}

	@Override
	protected AbstractDetailComposite createDetailComposite(Composite composite) {
		return formFactory.createFormDetailComposite(composite, SWT.NONE);
	}

}
