/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.binding;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractWidgetFactory {
    protected Composite parent = null;

    protected void init(Composite parent) {
        this.parent = parent;
    }

    public Label createLabel(String text) {
        return this.createLabel(this.parent, text);
    }

    public abstract Label createLabel(Composite var1, String var2);

    public Button createButton(String text, int ... styles) {
        return this.createButton(this.parent, text, this.aggregateStyles(styles));
    }

    public abstract Button createButton(Composite var1, String var2, int var3);

    public Text createText(String text) {
        return this.createText(this.parent, text);
    }

    public Text createText(String text, int ... styles) {
        return this.createText(this.parent, text, this.aggregateStyles(styles));
    }

    public Text createText(Composite parent, String text) {
        return this.createText(parent, text, 2048);
    }

    public abstract Text createText(Composite var1, String var2, int var3);

    public ComboViewer createComboViewer(int ... styles) {
        return this.createComboViewer(this.parent, this.aggregateStyles(styles));
    }

    public abstract ComboViewer createComboViewer(Composite var1, int var2);

    protected int aggregateStyles(int ... styles) {
        int result = 0;
        int[] nArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            result |= s;
            ++n2;
        }
        return result;
    }

    public Composite getParent() {
        return this.parent;
    }
}

