/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.binding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.parsley.binding.AbstractWidgetFactory;
import org.eclipse.emf.parsley.binding.CachedLabelProvider;
import org.eclipse.emf.parsley.binding.ProposalCreator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class MultipleFeatureControl
extends Composite {
    private FeatureEditorDialog dialog;
    private final ILabelProvider labelProvider;
    private ISelectionProvider inernalProvider = new InternalSelectionProvider();
    private Label label;
    private Button button;

    public MultipleFeatureControl(final Composite parent, AbstractWidgetFactory widgetFactory, final ILabelProvider labelProvider, final EObject object, final EStructuralFeature feature, final ProposalCreator proposalcreator, boolean readonly) {
        super(parent, 0);
        this.labelProvider = labelProvider;
        this.setLayout((Layout)new GridLayout(2, false));
        this.label = widgetFactory.createLabel(this, "");
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MultipleFeatureControl.this.setFocus();
            }
        });
        this.label.setLayoutData((Object)new GridData(768));
        this.button = widgetFactory.createButton(this, "...", 8);
        this.button.setLayoutData((Object)new GridData());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List oldValue = MultipleFeatureControl.this.unwrapSelection();
                List<Object> proposals = proposalcreator.proposals(object, feature);
                MultipleFeatureControl.this.dialog = new FeatureEditorDialog(parent.getShell(), (ILabelProvider)new CachedLabelProvider(labelProvider), (Object)object, feature.getEType(), oldValue, "Select", proposals, false, feature.isOrdered(), proposals != null);
                MultipleFeatureControl.this.dialog.setBlockOnOpen(true);
                if (MultipleFeatureControl.this.dialog.open() == 0) {
                    MultipleFeatureControl.this.setSelection((ISelection)new StructuredSelection(MultipleFeatureControl.this.dialog.getResult().toArray()));
                }
            }
        });
        this.button.setVisible(!readonly);
    }

    protected void setSelection(ISelection structuredSelection) {
        this.inernalProvider.setSelection(structuredSelection);
    }

    private List<Object> unwrapSelection() {
        ArrayList<Object> l = new ArrayList<Object>();
        if (this.getSelection() != null && !this.getSelection().isEmpty() && this.getSelection() instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)this.getSelection()) {
                l.add(object);
            }
        }
        return l;
    }

    private ISelection getSelection() {
        return this.inernalProvider.getSelection();
    }

    public Label getLabel() {
        return this.label;
    }

    public Button getButton() {
        return this.button;
    }

    public void setMenu(Menu menu) {
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setMenu(menu);
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setMenu(menu);
        }
    }

    public boolean setFocus() {
        if (this.button != null) {
            return this.button.setFocus();
        }
        return super.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.button.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.button.removeFocusListener(listener);
    }

    private void recalculateLabelText() {
        this.label.setText(this.labelProvider.getText(this.unwrapSelection()));
    }

    public ISelectionProvider getInternalSelectionProvider() {
        return this.inernalProvider;
    }

    public void setValue(Object newValue) {
        this.setSelection((ISelection)new StructuredSelection((List)newValue));
    }

    public Object getValue() {
        return ((StructuredSelection)this.getSelection()).toList();
    }

    class InternalSelectionProvider
    implements ISelectionProvider {
        private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
        private ISelection selection;

        InternalSelectionProvider() {
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
            MultipleFeatureControl.this.recalculateLabelText();
            for (ISelectionChangedListener currListener : this.listeners) {
                currListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.selection));
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }
    }
}

