/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.builders;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.parsley.builders.TableViewerColumnBuilder;
import org.eclipse.emf.parsley.util.EmfParsleyUtil;
import org.eclipse.emf.parsley.viewers.ViewerInitializer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;

public class TableViewerBuilder {
    @Inject
    protected TableViewerColumnBuilder columnBuilder;
    @Inject
    protected ViewerInitializer viewerInitializer;

    public void buildAndFill(TableViewer tableViewer, Object contents, EClass eClass) {
        this.buildAndFill(tableViewer, contents, eClass, (IStructuredContentProvider)new ArrayContentProvider());
    }

    public void buildAndFill(TableViewer tableViewer, Object contents, EClass eClass, IStructuredContentProvider contentProvider) {
        this.build(tableViewer, eClass, contentProvider);
        this.fill(tableViewer, contents, contentProvider);
    }

    public void fill(TableViewer tableViewer, Object contents, IStructuredContentProvider contentProvider) {
        this.viewerInitializer.initialize((StructuredViewer)tableViewer, EmfParsleyUtil.ensureCollection(contents), (IContentProvider)contentProvider, null);
    }

    public void build(TableViewer tableViewer, EClass eClass, IStructuredContentProvider contentProvider) {
        this.columnBuilder.buildTableViewer(tableViewer, eClass, contentProvider);
    }
}

