/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.builders;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.factories.ColumnLabelProviderFactory;
import org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider;
import org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerColumnBuilder {
    @Inject
    @Named(value="DefaultTableColumnWeight")
    private int defaultWeight;
    @Inject
    @Named(value="TableColumnWeights")
    private List<Integer> weights;
    @Inject
    protected ColumnLabelProviderFactory columnLabelProviderFactory;
    @Inject
    protected FeatureCaptionProvider featureCaptionProvider;
    @Inject
    protected TableFeaturesProvider featuresProvider;

    public void buildTableViewer(TableViewer tableViewer, EClass eClass, IStructuredContentProvider contentProvider) {
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        List<EStructuralFeature> typeFeatures = this.featuresProvider.getFeatures(eClass);
        int i = 0;
        for (EStructuralFeature eStructuralFeature : typeFeatures) {
            int weight = this.defaultWeight;
            if (this.weights.size() > i) {
                weight = this.weights.get(i++);
            }
            this.buildTableViewerColumn(tableViewer, layout, eClass, eStructuralFeature, contentProvider, weight);
        }
    }

    protected TableViewerColumn buildTableViewerColumn(TableViewer tableViewer, TableLayout layout, EClass eClass, EStructuralFeature eStructuralFeature, IStructuredContentProvider contentProvider, int weight) {
        TableViewerColumn viewerColumn = this.createTableViewerColumn(tableViewer, eStructuralFeature, contentProvider);
        TableColumn objectColumn = viewerColumn.getColumn();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight, 30, true));
        objectColumn.setText(this.featureCaptionProvider.getText(eClass, eStructuralFeature));
        objectColumn.setResizable(true);
        return viewerColumn;
    }

    protected TableViewerColumn createTableViewerColumn(TableViewer tableViewer, EStructuralFeature eStructuralFeature, IStructuredContentProvider contentProvider) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        if (contentProvider != null) {
            tableViewerColumn.setLabelProvider(this.columnLabelProviderFactory.createColumnLabelProvider(eStructuralFeature, contentProvider));
        } else {
            tableViewerColumn.setLabelProvider((CellLabelProvider)this.columnLabelProviderFactory.createColumnLabelProvider(eStructuralFeature));
        }
        return tableViewerColumn;
    }
}

