/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit;

import java.util.Stack;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class TextUndoRedo
implements KeyListener,
ModifyListener {
    private Text text;
    private TextInfo currentTextInfo;
    private UndoRedoStack stack;
    private boolean isUndo;
    private boolean isRedo;

    public TextUndoRedo(Text text) {
        text.addModifyListener((ModifyListener)this);
        text.addKeyListener((KeyListener)this);
        this.text = text;
        this.stack = new UndoRedoStack();
        this.currentTextInfo = this.currentInfo();
    }

    public void keyPressed(KeyEvent e) {
        boolean isAlt;
        boolean isCtrl = (e.stateMask & 0x40000) != 0;
        boolean bl = isAlt = (e.stateMask & 0x10000) != 0;
        if (isCtrl && !isAlt) {
            boolean isShift;
            boolean bl2 = isShift = (e.stateMask & 0x20000) != 0;
            if (!isShift && e.keyCode == 122) {
                this.undo();
            } else if (!isShift && e.keyCode == 121 || isShift && e.keyCode == 122) {
                this.redo();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void modifyText(ModifyEvent event) {
        if (this.isUndo) {
            this.stack.pushRedo(this.currentTextInfo);
        } else {
            this.stack.pushUndo(this.currentTextInfo);
            if (!this.isRedo) {
                this.stack.clearRedo();
            }
        }
        this.currentTextInfo = this.currentInfo();
    }

    private void undo() {
        if (this.stack.hasUndo()) {
            this.isUndo = true;
            TextInfo popUndo = this.stack.popUndo();
            this.updateText(popUndo);
            this.isUndo = false;
        }
    }

    private void redo() {
        if (this.stack.hasRedo()) {
            this.isRedo = true;
            this.updateText(this.stack.popRedo());
            this.isRedo = false;
        }
    }

    private void updateText(TextInfo info) {
        this.text.setText(info.currentText);
        this.text.setSelection(info.currentCaretPosition);
    }

    private TextInfo currentInfo() {
        return new TextInfo(this.text.getText(), this.text.getCaretPosition());
    }

    private static class TextInfo {
        String currentText;
        int currentCaretPosition;

        public TextInfo(String currentText, int currentCaretPosition) {
            this.currentText = currentText;
            this.currentCaretPosition = currentCaretPosition;
        }
    }

    private static class UndoRedoStack {
        private Stack<TextInfo> undo = new Stack();
        private Stack<TextInfo> redo = new Stack();

        public void pushUndo(TextInfo delta) {
            this.undo.add(delta);
        }

        public void pushRedo(TextInfo delta) {
            this.redo.add(delta);
        }

        public TextInfo popUndo() {
            TextInfo res = this.undo.pop();
            return res;
        }

        public TextInfo popRedo() {
            TextInfo res = this.redo.pop();
            return res;
        }

        public void clearRedo() {
            this.redo.clear();
        }

        public boolean hasUndo() {
            return !this.undo.isEmpty();
        }

        public boolean hasRedo() {
            return !this.redo.isEmpty();
        }
    }
}

