/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.edit.action;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.parsley.edit.action.EditingDomainValidateAction;
import org.eclipse.emf.parsley.edit.action.EmfCommandAction;
import org.eclipse.emf.parsley.edit.action.IMenuContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuActionContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuCommandActionHandlerContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuSeparatorContributionSpecification;
import org.eclipse.emf.parsley.edit.action.MenuSubmenuSpecification;
import org.eclipse.emf.parsley.runtime.util.IAcceptor;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;
import org.eclipse.emf.parsley.util.EmfSelectionHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class EditingMenuBuilder {
    @Inject
    protected EmfSelectionHelper selectionHelper;
    @Inject
    private ILabelProvider labelProvider;
    private EditingDomain editingDomain;
    private CommandActionHandler deleteAction;
    private CommandActionHandler cutAction;
    private CommandActionHandler copyAction;
    private CommandActionHandler pasteAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private PolymorphicDispatcher<List<IMenuContributionSpecification>> menuContributionsDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"menuContributions", (int)1, (int)1, (Object)this);
    private PolymorphicDispatcher<List<IMenuContributionSpecification>> emfMenuContributionsDispatcher = PolymorphicDispatcher.createForSingleTarget((String)"emfMenuContributions", (int)1, (int)1, (Object)this);
    private List<IMenuContributionSpecification> currentMenuContributions = Collections.emptyList();
    private List<IMenuContributionSpecification> currentEmfMenuContributions = Collections.emptyList();
    private static final List<IMenuContributionSpecification> POLYMORPHIC_NULL_RESULT = new ArrayList<IMenuContributionSpecification>();

    protected List<IMenuContributionSpecification> getCurrentEmfMenuContributions() {
        return this.currentEmfMenuContributions;
    }

    protected List<IMenuContributionSpecification> getCurrentMenuContributions() {
        return this.currentMenuContributions;
    }

    public void createActions() {
        this.deleteAction = this.createDeleteAction();
        this.cutAction = this.createCutAction();
        this.copyAction = this.createCopyAction();
        this.pasteAction = this.createPasteAction();
        this.undoAction = this.createUndoAction();
        this.redoAction = this.createRedoAction();
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.deleteAction.setEditingDomain(editingDomain);
        this.cutAction.setEditingDomain(editingDomain);
        this.copyAction.setEditingDomain(editingDomain);
        this.pasteAction.setEditingDomain(editingDomain);
        this.undoAction.setEditingDomain(editingDomain);
        this.redoAction.setEditingDomain(editingDomain);
    }

    public void updateSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.updateMenuContributions((ISelection)structuredSelection);
            for (IMenuContributionSpecification menuContributionSpecification : this.getCurrentMenuContributions()) {
                menuContributionSpecification.updateSelection(structuredSelection);
            }
        }
    }

    public void updateUndoRedo() {
        this.undoAction.update();
        this.redoAction.update();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        for (IMenuContributionSpecification menuContributionSpecification : this.getCurrentMenuContributions()) {
            menuManager.add(menuContributionSpecification.getContributionItem());
        }
    }

    public void emfMenuAboutToShow(IMenuManager menuManager) {
        for (IMenuContributionSpecification menuContributionSpecification : this.getCurrentEmfMenuContributions()) {
            menuManager.add(menuContributionSpecification.getContributionItem());
        }
    }

    protected void updateMenuContributions(ISelection selection) {
        Object firstSelectedElement = this.selectionHelper.getFirstSelectedElement(selection);
        this.currentMenuContributions = (List)this.menuContributionsDispatcher.invoke(new Object[]{firstSelectedElement});
        this.currentEmfMenuContributions = (List)this.emfMenuContributionsDispatcher.invoke(new Object[]{firstSelectedElement});
        if (POLYMORPHIC_NULL_RESULT == this.currentEmfMenuContributions) {
            this.currentEmfMenuContributions = (List)this.emfMenuContributionsDispatcher.invoke(new Object[]{selection});
        }
    }

    protected List<IMenuContributionSpecification> menuContributions(Object object) {
        return this.defaultMenuContributions(object);
    }

    protected List<IMenuContributionSpecification> emfMenuContributions(Object object) {
        return POLYMORPHIC_NULL_RESULT;
    }

    protected List<IMenuContributionSpecification> emfMenuContributions(ISelection selection) {
        return this.defaultEmfMenuContributions(selection);
    }

    protected List<IMenuContributionSpecification> defaultMenuContributions(Object object) {
        return Lists.newArrayList((Object[])new IMenuContributionSpecification[]{this.actionUndo(), this.actionRedo(), this.separator(), this.actionCut(), this.actionCopy(), this.actionPaste(), this.separator(), this.actionDelete(), this.separator()});
    }

    protected List<IMenuContributionSpecification> defaultEmfMenuContributions(ISelection selection) {
        return Lists.newArrayList((Object[])new IMenuContributionSpecification[]{this.submenu("&New Child", this.createChildActions(selection)), this.submenu("N&ew Sibling", this.createSiblingActions(selection))});
    }

    protected IMenuContributionSpecification separator() {
        return new MenuSeparatorContributionSpecification();
    }

    protected IMenuContributionSpecification submenu(String text, List<IMenuContributionSpecification> menuContributions) {
        return new MenuSubmenuSpecification(text, menuContributions);
    }

    protected IMenuContributionSpecification actionDelete() {
        return new MenuCommandActionHandlerContributionSpecification(this.deleteAction);
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction(true);
    }

    protected IMenuContributionSpecification actionCut() {
        return new MenuCommandActionHandlerContributionSpecification(this.cutAction);
    }

    protected CutAction createCutAction() {
        return new CutAction();
    }

    protected IMenuContributionSpecification actionCopy() {
        return new MenuCommandActionHandlerContributionSpecification(this.copyAction);
    }

    protected CopyAction createCopyAction() {
        return new CopyAction();
    }

    protected IMenuContributionSpecification actionPaste() {
        return new MenuCommandActionHandlerContributionSpecification(this.pasteAction);
    }

    protected PasteAction createPasteAction() {
        return new PasteAction();
    }

    protected IMenuContributionSpecification actionUndo() {
        return new MenuActionContributionSpecification((Action)this.undoAction);
    }

    protected UndoAction createUndoAction() {
        return new UndoAction();
    }

    protected IMenuContributionSpecification actionRedo() {
        return new MenuActionContributionSpecification((Action)this.redoAction);
    }

    protected CommandActionHandler getDeleteAction() {
        return this.deleteAction;
    }

    protected CommandActionHandler getCutAction() {
        return this.cutAction;
    }

    protected CommandActionHandler getCopyAction() {
        return this.copyAction;
    }

    protected CommandActionHandler getPasteAction() {
        return this.pasteAction;
    }

    protected UndoAction getUndoAction() {
        return this.undoAction;
    }

    protected RedoAction getRedoAction() {
        return this.redoAction;
    }

    protected RedoAction createRedoAction() {
        return new RedoAction();
    }

    protected LoadResourceAction createLoadResourceAction() {
        return new LoadResourceAction();
    }

    public ControlAction createControlAction() {
        return new ControlAction();
    }

    public EditingDomainValidateAction createValidateAction() {
        return new EditingDomainValidateAction();
    }

    protected <T> IMenuContributionSpecification actionAdd(String text, EList<? super T> list, T value) {
        return this.actionAdd(text, list, value, null);
    }

    protected <T> IMenuContributionSpecification actionAdd(String text, EList<? super T> list, T value, IAcceptor<T> addedObjectInitialier) {
        AddCommand addCommand = this.addCommand(list, value);
        addCommand.setDescription(text);
        return new MenuActionContributionSpecification(new EmfCommandAction<T>(text, this.getEditingDomain(), (Command)addCommand, addedObjectInitialier));
    }

    protected <T> AddCommand addCommand(EList<? super T> list, T value) {
        return new AddCommand(this.getEditingDomain(), list, value);
    }

    public List<IMenuContributionSpecification> createChildActions(ISelection selection) {
        Collection descriptors = this.editingDomain.getNewChildDescriptors(this.selectionHelper.getFirstSelectedElement(selection), null);
        ArrayList<IMenuContributionSpecification> actions = new ArrayList<IMenuContributionSpecification>();
        for (Object descriptor : descriptors) {
            CreateChildAction act = new CreateChildAction(this.editingDomain, selection, descriptor);
            Image imageObj = this.labelProvider.getImage(((CommandParameter)descriptor).getValue());
            act.setImageDescriptor(ImageDescriptor.createFromImage((Image)imageObj));
            actions.add(new MenuActionContributionSpecification((Action)act));
        }
        return actions;
    }

    public List<IMenuContributionSpecification> createSiblingActions(ISelection selection) {
        Collection descriptors = this.editingDomain.getNewChildDescriptors(null, this.selectionHelper.getFirstSelectedElement(selection));
        ArrayList<IMenuContributionSpecification> actions = new ArrayList<IMenuContributionSpecification>();
        for (Object descriptor : descriptors) {
            CreateSiblingAction act = new CreateSiblingAction(this.editingDomain, selection, descriptor);
            Image imageObj = this.labelProvider.getImage(((CommandParameter)descriptor).getValue());
            act.setImageDescriptor(ImageDescriptor.createFromImage((Image)imageObj));
            actions.add(new MenuActionContributionSpecification((Action)act));
        }
        return actions;
    }
}

