/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.factories;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.ui.provider.AdapterMapCellLabelProvider;
import org.eclipse.emf.parsley.ui.provider.TableColumnLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;

public class ColumnLabelProviderFactory {
    @Inject
    protected Provider<ILabelProvider> labelProviderProvider;
    @Inject
    protected Provider<TableColumnLabelProvider> tableColumnProviderProvider;

    public ColumnLabelProvider createColumnLabelProvider(EStructuralFeature eStructuralFeature) {
        TableColumnLabelProvider columnProvider = (TableColumnLabelProvider)((Object)this.tableColumnProviderProvider.get());
        columnProvider.seteStructuralFeature(eStructuralFeature);
        return columnProvider;
    }

    public CellLabelProvider createColumnLabelProvider(EStructuralFeature eStructuralFeature, IStructuredContentProvider contentProvider) {
        if (contentProvider instanceof ObservableListContentProvider) {
            return this.createColumnLabelProvider(eStructuralFeature, (ObservableListContentProvider)contentProvider);
        }
        return this.createColumnLabelProvider(eStructuralFeature);
    }

    public CellLabelProvider createColumnLabelProvider(EStructuralFeature eStructuralFeature, ObservableListContentProvider cp) {
        IObservableMap observableMap = EMFProperties.value((EStructuralFeature)eStructuralFeature).observeDetail(cp.getKnownElements());
        return new AdapterMapCellLabelProvider(observableMap, (ILabelProvider)this.labelProviderProvider.get());
    }
}

