/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.factories;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.parsley.builders.TableViewerBuilder;
import org.eclipse.emf.parsley.viewers.ViewerInitializer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class ViewerFactory {
    @Inject
    protected ViewerInitializer viewerInitializer;
    @Inject
    protected TableViewerBuilder tableViewerBuilder;

    public TreeViewer createTreeViewer(Composite parent, int style, URI resourceURI) {
        TreeViewer treeViewer = new TreeViewer(parent, style);
        this.update(treeViewer, resourceURI);
        return treeViewer;
    }

    public TreeViewer createTreeViewer(Tree tree, URI resourceURI) {
        TreeViewer treeViewer = new TreeViewer(tree);
        this.update(treeViewer, resourceURI);
        return treeViewer;
    }

    public TreeViewer createTreeViewer(Composite parent, int style, AdapterFactoryEditingDomain editingDomain) {
        TreeViewer treeViewer = new TreeViewer(parent, style);
        this.update(treeViewer, editingDomain);
        return treeViewer;
    }

    public TreeViewer createTreeViewer(Tree tree, AdapterFactoryEditingDomain editingDomain) {
        TreeViewer treeViewer = new TreeViewer(tree);
        this.update(treeViewer, editingDomain);
        return treeViewer;
    }

    public TableViewer createTableViewer(Composite parent, int style, Object content, EClass type) {
        TableViewer tableViewer = new TableViewer(parent, style);
        this.tableViewerBuilder.buildAndFill(tableViewer, content, type);
        return tableViewer;
    }

    protected void update(TreeViewer treeViewer, AdapterFactoryEditingDomain editingDomain) {
        this.viewerInitializer.initialize((StructuredViewer)treeViewer, editingDomain);
    }

    protected void update(TreeViewer treeViewer, URI resourceURI) {
        this.viewerInitializer.initialize((StructuredViewer)treeViewer, resourceURI);
    }
}

