/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.menus;

import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Menu;

public class ViewerContextMenuFactory {
    public MenuManager createContextMenuFor(StructuredViewer viewer, AdapterFactoryEditingDomain editingDomain) {
        MenuManager menuManager = this.createMenuManager();
        this.createMenu(viewer, menuManager);
        this.addDragAndDrop(viewer, editingDomain);
        return menuManager;
    }

    protected void addDragAndDrop(StructuredViewer viewer, AdapterFactoryEditingDomain editingDomain) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)editingDomain, (Viewer)viewer));
    }

    protected void createMenu(StructuredViewer viewer, MenuManager menuManager) {
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        return menuManager;
    }
}

