/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.parsley.edit.actionbar.TreeActionBarContributor;
import org.eclipse.emf.parsley.edit.actionbar.WorkbenchActionBarContributor;
import org.eclipse.emf.parsley.listeners.IViewerMouseListener;
import org.eclipse.emf.parsley.menus.ViewerContextMenuFactory;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.emf.parsley.viewers.ViewerSelectionProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.IWorkbenchPart;

public class ViewerInitializer {
    @Inject
    protected ResourceLoader resourceLoader;
    @Inject
    protected Provider<AdapterFactoryEditingDomain> editingDomainProvider;
    @Inject
    protected Provider<AdapterFactory> adapterFactoryProvider;
    @Inject
    protected ViewerContextMenuFactory viewerContextMenuFactory;
    @Inject
    protected Provider<IContentProvider> contentProviderProvider;
    @Inject
    protected Provider<ILabelProvider> labelProviderProvider;
    @Inject
    protected Provider<IViewerMouseListener> viewerMouseListenerProvider;

    public void initialize(StructuredViewer viewer, Object object) {
        Object input;
        if (object instanceof URI) {
            AdapterFactoryEditingDomain editingDomain = this.loadResource((URI)object);
            input = editingDomain.getResourceSet();
        } else if (object instanceof AdapterFactoryEditingDomain) {
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)object;
            input = editingDomain.getResourceSet();
        } else {
            input = object;
        }
        this.initialize(viewer, input, (IContentProvider)this.contentProviderProvider.get(), (IBaseLabelProvider)this.labelProviderProvider.get());
    }

    public void initialize(StructuredViewer viewer, Object input, IContentProvider contentProvider, IBaseLabelProvider labelProvider) {
        viewer.setContentProvider(contentProvider);
        if (labelProvider != null) {
            viewer.setLabelProvider(labelProvider);
        }
        viewer.setInput(input);
    }

    public void addContextMenu(StructuredViewer viewer, WorkbenchActionBarContributor actionBarContributor, AdapterFactoryEditingDomain editingDomain, IMenuListener menuListener, IWorkbenchPart activePart) {
        MenuManager menuManager = this.viewerContextMenuFactory.createContextMenuFor(viewer, editingDomain);
        activePart.getSite().registerContextMenu(menuManager, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        menuManager.addMenuListener(menuListener);
        ViewerSelectionProvider viewerSelectionProvider = new ViewerSelectionProvider((Viewer)viewer);
        actionBarContributor.setExplicitSelectionProvider(viewerSelectionProvider);
        viewerSelectionProvider.addSelectionChangedListener(actionBarContributor);
        actionBarContributor.setActivePart(activePart);
    }

    public void addContextMenu(StructuredViewer viewer, TreeActionBarContributor treeActionBarContributor, AdapterFactoryEditingDomain editingDomain, IMenuListener menuListener) {
        MenuManager menuManager = this.viewerContextMenuFactory.createContextMenuFor(viewer, editingDomain);
        menuManager.addMenuListener(menuListener);
        viewer.addSelectionChangedListener((ISelectionChangedListener)treeActionBarContributor);
        treeActionBarContributor.initialize((EditingDomain)editingDomain);
    }

    public void addMouseListener(StructuredViewer viewer) {
        viewer.getControl().addMouseListener((MouseListener)this.viewerMouseListenerProvider.get());
    }

    protected AdapterFactoryEditingDomain loadResource(URI resourceURI) {
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)this.editingDomainProvider.get();
        this.resourceLoader.getResource(editingDomain, resourceURI);
        return editingDomain;
    }
}

