/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.widgets;

import com.google.inject.Inject;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.factories.FormFactory;
import org.eclipse.emf.parsley.util.EmfSelectionHelper;
import org.eclipse.emf.parsley.viewers.ViewerInitializer;
import org.eclipse.emf.parsley.widgets.FormDetailComposite;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public abstract class AbstractMasterDetailComposite
extends Composite
implements IViewerProvider {
    private ViewerInitializer viewerInitializer;
    private FormFactory formFactory;
    private EmfSelectionHelper emfSelectionHelper;
    private final StructuredViewer viewer;
    private final PageBook pagebook;
    private final Composite detail;
    private FormDetailComposite detailForm;
    private SashForm sashForm;

    public AbstractMasterDetailComposite(Composite parent, int style) {
        this(parent, style, 512, new int[0]);
    }

    public AbstractMasterDetailComposite(Composite parent, int style, int sashStyle, int[] weights) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.sashForm = new SashForm((Composite)this, sashStyle);
        this.pagebook = new PageBook((Composite)this.sashForm, 2048);
        this.detail = new Composite((Composite)this.sashForm, 2048);
        this.detail.setLayout((Layout)new FillLayout());
        this.viewer = this.createViewer((Composite)this.pagebook);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener());
        if (weights.length > 0) {
            this.sashForm.setWeights(weights);
        }
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void update(Object element) {
        if (element != null) {
            this.viewerInitializer.initialize(this.viewer, element);
            this.pagebook.showPage(this.viewer.getControl());
        }
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected void eObjectSelectionChanged(EObject selectedObject) {
        if (this.detailForm != null) {
            this.detailForm.dispose();
        }
        if (selectedObject != null) {
            this.detailForm = this.createFormDetailComposite();
            this.detailForm.init(selectedObject);
            this.detail.layout(true);
        }
    }

    protected FormDetailComposite createFormDetailComposite() {
        return this.formFactory.createFormDetailComposite(this.detail, 2048);
    }

    public ViewerInitializer getViewerInitializer() {
        return this.viewerInitializer;
    }

    @Inject
    public void setViewerInitializer(ViewerInitializer viewerInitializer) {
        this.viewerInitializer = viewerInitializer;
    }

    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    @Inject
    public void setFormFactory(FormFactory formFactory) {
        this.formFactory = formFactory;
    }

    public EmfSelectionHelper getEmfSelectionHelper() {
        return this.emfSelectionHelper;
    }

    @Inject
    public void setEmfSelectionHelper(EmfSelectionHelper emfSelectionHelper) {
        this.emfSelectionHelper = emfSelectionHelper;
    }

    protected PageBook getPagebook() {
        return this.pagebook;
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    protected class SelectionChangedListener
    implements ISelectionChangedListener {
        protected SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            EObject selectedObject = AbstractMasterDetailComposite.this.emfSelectionHelper.getFirstSelectedEObject(event.getSelection());
            AbstractMasterDetailComposite.this.eObjectSelectionChanged(selectedObject);
        }
    }
}

