/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.widgets;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.parsley.builders.TableViewerBuilder;
import org.eclipse.emf.parsley.widgets.AbstractMasterDetailComposite;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class TableFormComposite
extends AbstractMasterDetailComposite {
    private TableViewerBuilder tableViewerBuilder;
    private TableViewer tableViewer;

    public TableFormComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.tableViewer = new TableViewer(parent, 66306);
        return this.tableViewer;
    }

    public void buildTable(EClass type, IStructuredContentProvider contentProvider) {
        this.removeExistingColumns();
        this.tableViewerBuilder.build(this.tableViewer, type, contentProvider);
    }

    public TableViewerBuilder getTableViewerBuilder() {
        return this.tableViewerBuilder;
    }

    @Inject
    public void setTableViewerBuilder(TableViewerBuilder tableViewerBuilder) {
        this.tableViewerBuilder = tableViewerBuilder;
    }

    @Override
    public void update(Object contents) {
        this.tableViewerBuilder.fill(this.tableViewer, contents, (IStructuredContentProvider)new ArrayContentProvider());
        this.getPagebook().showPage(this.tableViewer.getControl());
    }

    private void removeExistingColumns() {
        int i = this.tableViewer.getTable().getColumns().length;
        while (i > 0) {
            this.tableViewer.getTable().getColumns()[i - 1].dispose();
            --i;
        }
        this.tableViewer.getTable().pack();
    }

    public void buildTable(EClass eType) {
        this.buildTable(eType, (IStructuredContentProvider)new ArrayContentProvider());
    }
}

