/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.factories.ViewerFactory;
import org.eclipse.emf.parsley.ui.provider.FeaturesProvider;
import org.eclipse.emf.parsley.views.AbstractOnSelectionView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractOnSelectionTableView
extends AbstractOnSelectionView {
    @Inject
    protected ViewerFactory viewerFactory;
    @Inject
    protected FeaturesProvider featuresProvider;
    protected Composite parent;
    protected TableViewer tableViewer;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.parent = parent;
        this.createTableViewer();
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        parent.layout(true, true);
    }

    @Override
    protected void updateOnSelection(IWorkbenchPart sourcepart, ISelection selection) {
        if (this.tableViewer == null) {
            return;
        }
        EObject eObject = this.getFirstSelectedEObject(selection);
        this.tableViewer.setInput(null);
        if (eObject != null) {
            this.update(eObject);
        }
    }

    protected void update(EObject eObject) {
        EStructuralFeature feature = this.getEStructuralFeature();
        if (!eObject.eClass().getEAllStructuralFeatures().contains((Object)feature)) {
            return;
        }
        Object value = eObject.eGet(feature);
        this.tableViewer.setInput(value);
    }

    protected void createTableViewer() {
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.parent, 2560);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.tableViewer = this.viewerFactory.createTableViewer((Composite)scrolledComposite, 67584, null, this.getEClass());
        Table table = this.tableViewer.getTable();
        scrolledComposite.setContent((Control)table);
        scrolledComposite.setMinSize(table.computeSize(-1, -1));
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    protected abstract EStructuralFeature getEStructuralFeature();

    protected EClass getEClass() {
        return (EClass)this.getEStructuralFeature().getEType();
    }
}

