/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.parsley.edit.actionbar.WorkbenchActionBarContributor;
import org.eclipse.emf.parsley.viewers.ViewerInitializer;
import org.eclipse.emf.parsley.views.AbstractSaveableView;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractSaveableViewerView
extends AbstractSaveableView
implements IMenuListener,
IViewerProvider {
    @Inject
    private WorkbenchActionBarContributor actionBarContributor;
    @Inject
    private ViewerInitializer viewerInitializer;

    @Override
    protected void postCommandStackChanged(Command mostRecentCommand) {
        if (mostRecentCommand != null && (mostRecentCommand instanceof CreateChildCommand || mostRecentCommand instanceof AddCommand)) {
            this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
        }
    }

    protected void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (AbstractSaveableViewerView.this.getViewer() != null) {
                        AbstractSaveableViewerView.this.getViewer().setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.actionBarContributor.menuAboutToShow(menuManager);
    }

    protected void addContextMenu(StructuredViewer viewer) {
        this.viewerInitializer.addContextMenu(viewer, this.actionBarContributor, this.editingDomain, (IMenuListener)this, (IWorkbenchPart)this);
    }

    protected void addMouseListener(StructuredViewer viewer) {
        this.viewerInitializer.addMouseListener(viewer);
    }
}

