/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.table;

import java.util.Iterator;

public interface Generator {
    public Object nextValue();

    public static final class Incrementer
    implements Generator {
        private final double start;
        private final double increment;
        private double value;

        public Incrementer(double start, double increment) {
            this.start = start;
            this.increment = increment;
            this.value = start;
        }

        public Incrementer(double start) {
            this(start, 1.0);
        }

        public Incrementer() {
            this(0.0);
        }

        public double getStart() {
            return this.start;
        }

        public double getIncrement() {
            return this.increment;
        }

        public double getValue() {
            return this.value;
        }

        public Object nextValue() {
            try {
                Double d = this.value;
                return d;
            }
            finally {
                this.value += this.increment;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Sequencer<T>
    implements Generator {
        private final Iterable<T> iterable;
        private final boolean repeat;
        private Iterator<T> iterator;

        public Sequencer(Iterable<T> iterable, boolean repeat) {
            this.iterable = iterable;
            this.repeat = repeat;
            this.reset();
        }

        public Sequencer(Iterable<T> iterable) {
            this(iterable, false);
        }

        public Iterable<T> getIterable() {
            return this.iterable;
        }

        public boolean isRepeat() {
            return this.repeat;
        }

        public T nextValue() {
            if (this.iterator.hasNext()) {
                return this.iterator.next();
            }
            if (this.repeat) {
                this.reset();
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
            }
            return null;
        }

        private void reset() {
            this.iterator = this.iterable.iterator();
        }
    }
}

