/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.listeners;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.dialogs.DialogFactory;
import org.eclipse.emf.parsley.edit.IEditingStrategy;
import org.eclipse.emf.parsley.listeners.IEditorMouseListener;
import org.eclipse.emf.parsley.util.EmfSelectionHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class OpenDialogMouseAdapter
extends MouseAdapter
implements IEditorMouseListener {
    @Inject
    private EmfSelectionHelper helper;
    @Inject
    private DialogFactory dialogFactory;
    @Inject
    private ILabelProvider labelProvider;
    @Inject
    protected IEditingStrategy editingStrategy;

    public void mouseDoubleClick(MouseEvent event) {
        EObject o;
        if (event.button == 1 && (o = this.helper.getEObjectFromMouseEvent(event)) != null) {
            this.editingStrategy.prepare(o);
            Dialog dialog = this.createDialog(o, this.editingStrategy.getEditingDomain(o), Display.getCurrent().getActiveShell(), this.labelProvider.getText((Object)o));
            int rc = dialog.open();
            if (rc == 0) {
                this.editingStrategy.update(o);
            } else {
                this.editingStrategy.rollback(o);
            }
        }
    }

    protected Dialog createDialog(EObject o, EditingDomain editingDomain, Shell activeShell, String title) {
        return this.dialogFactory.createDetailDialog(activeShell, title, o, editingDomain);
    }
}

