/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.resource;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.parsley.resource.LoadResourceResponse;
import org.eclipse.emf.parsley.resource.ResourceManager;

public class ResourceLoader {
    @Inject
    private ResourceManager resourceManager;

    public Resource getResource(ResourceSet resourceSet, URI resourceURI) {
        Resource resource = resourceSet.getResource(resourceURI, true);
        this.initializeEmptyResource(resource);
        return resource;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public LoadResourceResponse getResource(AdapterFactoryEditingDomain editingDomain, URI resourceURI) {
        Resource resource = null;
        Exception exception = null;
        try {
            resource = this.getResource(editingDomain.getResourceSet(), resourceURI);
        }
        catch (Exception e) {
            exception = e;
            resource = editingDomain.getResourceSet().getResource(resourceURI, false);
            this.initializeEmptyResource(resource);
        }
        return new LoadResourceResponse(resource, exception);
    }

    protected void initializeEmptyResource(Resource resource) {
        if (resource != null && resource.getContents().isEmpty()) {
            this.getResourceManager().initialize(resource);
        }
    }
}

