/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.ui.provider;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.EmfParsleyActivator;
import org.eclipse.emf.parsley.runtime.ui.IImageHelper;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcher;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcherExtensions;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class TableColumnLabelProvider
extends ColumnLabelProvider {
    protected EStructuralFeature eStructuralFeature;
    protected ILabelProvider labelProvider;
    @Inject
    private IImageHelper imageHelper;

    @Inject
    public TableColumnLabelProvider() {
    }

    public EStructuralFeature geteStructuralFeature() {
        return this.eStructuralFeature;
    }

    public void seteStructuralFeature(EStructuralFeature eStructuralFeature) {
        this.eStructuralFeature = eStructuralFeature;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Inject
    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        String ret = this.polymorphicGetText(element, this.geteStructuralFeature());
        if (ret != null) {
            return ret;
        }
        try {
            return this.defaultGetTextForFeatureValue(element);
        }
        catch (AssertionError e) {
            return this.logErrorAndReturnEmptyString((Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            return this.logErrorAndReturnEmptyString(e);
        }
    }

    protected String defaultGetTextForFeatureValue(Object element) {
        Object featureValue = this.getFeatureValue(element);
        return featureValue != null ? this.getLabelProvider().getText(featureValue) : "";
    }

    protected String logErrorAndReturnEmptyString(Throwable e) {
        EmfParsleyActivator.logError("TableColumnLabelProvider.getText", e);
        return "";
    }

    protected Object getFeatureValue(Object element) {
        EObject eObject = (EObject)element;
        Object featureValue = eObject.eGet(this.geteStructuralFeature());
        return featureValue;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        Image ret = this.polymorphicGetImage(element, this.geteStructuralFeature());
        return ret;
    }

    protected String polymorphicGetText(Object element, EStructuralFeature feature) {
        return (String)PolymorphicDispatcherExtensions.createPolymorphicDispatcher((Object)((Object)this), this.getTextPredicate(feature)).invoke(new Object[]{element});
    }

    protected Predicate<Method> getTextPredicate(EStructuralFeature feature) {
        String methodName = "text_" + feature.getEContainingClass().getName() + "_" + feature.getName();
        return PolymorphicDispatcher.Predicates.forName((String)methodName, (int)1);
    }

    protected Image polymorphicGetImage(Object element, EStructuralFeature feature) {
        Object invoke = PolymorphicDispatcherExtensions.createPolymorphicDispatcher((Object)((Object)this), this.getImagePredicate(feature)).invoke(new Object[]{element});
        if (invoke != null) {
            return this.imageHelper.convertToImage(invoke);
        }
        return null;
    }

    protected Predicate<Method> getImagePredicate(EStructuralFeature feature) {
        String methodName = "image_" + feature.getEContainingClass().getName() + "_" + feature.getName();
        return PolymorphicDispatcher.Predicates.forName((String)methodName, (int)1);
    }
}

