/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider;
import org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider;
import org.eclipse.emf.parsley.viewers.ColumnLabelProviderFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableViewerColumnBuilder {
    @Inject
    @Named(value="DefaultTableColumnWeight")
    private int defaultWeight;
    @Inject
    @Named(value="TableColumnWeights")
    private List<Integer> weights;
    @Inject
    private ColumnLabelProviderFactory columnLabelProviderFactory;
    @Inject
    private FeatureCaptionProvider featureCaptionProvider;
    @Inject
    private TableFeaturesProvider featuresProvider;

    public void buildTableViewer(TableViewer tableViewer, EClass eClass) {
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Layout layout = null;
        Layout tableParentLayout = tableViewer.getTable().getParent().getLayout();
        if (tableParentLayout instanceof TableColumnLayout) {
            layout = tableParentLayout;
        } else {
            layout = new TableLayout();
            table.setLayout(layout);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
        }
        List<EStructuralFeature> typeFeatures = this.featuresProvider.getFeatures(eClass);
        int i = 0;
        for (EStructuralFeature eStructuralFeature : typeFeatures) {
            int weight = this.defaultWeight;
            if (this.weights.size() > i) {
                weight = this.weights.get(i++);
            }
            this.buildTableViewerColumn(tableViewer, layout, eClass, eStructuralFeature, weight);
        }
    }

    protected TableViewerColumn buildTableViewerColumn(TableViewer tableViewer, Layout layout, EClass eClass, EStructuralFeature eStructuralFeature, int weight) {
        TableViewerColumn viewerColumn = this.createTableViewerColumn(tableViewer, eStructuralFeature);
        TableColumn objectColumn = viewerColumn.getColumn();
        if (layout instanceof TableColumnLayout) {
            ((TableColumnLayout)layout).setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, 30, true));
        } else if (layout instanceof TableLayout) {
            ((TableLayout)layout).addColumnData((ColumnLayoutData)new ColumnWeightData(weight, 30, true));
        }
        objectColumn.setText(this.featureCaptionProvider.getText(eClass, eStructuralFeature));
        objectColumn.setResizable(true);
        return viewerColumn;
    }

    protected TableViewerColumn createTableViewerColumn(TableViewer tableViewer, EStructuralFeature eStructuralFeature) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)this.columnLabelProviderFactory.createColumnLabelProvider(eStructuralFeature));
        return tableViewerColumn;
    }
}

