/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.viewers.TableViewerColumnBuilder;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TableViewerEditableColumnBuilder
extends TableViewerColumnBuilder {
    @Override
    protected TableViewerColumn buildTableViewerColumn(TableViewer tableViewer, Layout layout, EClass eClass, EStructuralFeature eStructuralFeature, int weight) {
        TableViewerColumn viewerColumn = super.buildTableViewerColumn(tableViewer, layout, eClass, eStructuralFeature, weight);
        if (eStructuralFeature instanceof EAttribute) {
            if (this.isPredefinedValueEditing((EAttribute)eStructuralFeature)) {
                viewerColumn.setEditingSupport((EditingSupport)new ComboEditingSupport((ColumnViewer)tableViewer, eStructuralFeature));
            } else {
                viewerColumn.setEditingSupport((EditingSupport)new TableEditingSupport((ColumnViewer)tableViewer, eStructuralFeature));
            }
        }
        return viewerColumn;
    }

    private boolean isPredefinedValueEditing(EAttribute attribute) {
        return attribute.getEAttributeType() instanceof EEnum;
    }

    static class ComboEditingSupport
    extends EditingSupport {
        private ColumnViewer viewer;
        private EStructuralFeature feature;
        private List<EEnumLiteral> literals;

        public ComboEditingSupport(ColumnViewer viewer, EStructuralFeature eStructuralFeature) {
            super(viewer);
            this.viewer = viewer;
            this.feature = eStructuralFeature;
        }

        protected CellEditor getCellEditor(Object element) {
            EEnum eEnum = (EEnum)((EAttribute)this.feature).getEAttributeType();
            this.literals = eEnum.getELiterals();
            String[] descriptions = new String[this.literals.size()];
            int i = 0;
            for (EEnumLiteral literal : this.literals) {
                descriptions[i++] = literal.getName();
            }
            return new ComboBoxCellEditor((Composite)this.getViewer().getControl(), descriptions);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            EObject eObject;
            if (element != null && element instanceof EObject && (eObject = (EObject)element).eGet(this.feature) instanceof Enumerator) {
                Enumerator typeEnum = (Enumerator)eObject.eGet(this.feature);
                int i = 0;
                while (i < this.literals.size()) {
                    EEnumLiteral literal = this.literals.get(i);
                    if (literal != null && literal.getLiteral().equals(typeEnum.getLiteral())) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        protected void setValue(Object element, Object value) {
            Enumerator typeEnum;
            Integer i = (Integer)value;
            EObject eObject = (EObject)element;
            if (eObject.eGet(this.feature) instanceof Enumerator && i >= 0 && i < this.literals.size() && (typeEnum = (Enumerator)eObject.eGet(this.feature)) != null && !typeEnum.getLiteral().equals(this.literals.get(i))) {
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
                SetCommand setCommand = new SetCommand(domain, eObject, this.feature, (Object)this.literals.get(i).getInstance());
                domain.getCommandStack().execute((Command)setCommand);
                this.viewer.refresh();
            }
        }
    }

    static class TableEditingSupport
    extends EditingSupport {
        private ColumnViewer viewer;
        private EStructuralFeature eStructuralFeature;

        public TableEditingSupport(ColumnViewer viewer, EStructuralFeature eStructuralFeature) {
            super(viewer);
            this.viewer = viewer;
            this.eStructuralFeature = eStructuralFeature;
        }

        protected CellEditor getCellEditor(Object element) {
            if (BigDecimal.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected void doSetValue(Object value) {
                        super.doSetValue((Object)("" + value));
                    }

                    protected Object doGetValue() {
                        String stringValue = (String)super.doGetValue();
                        return new BigDecimal(stringValue);
                    }
                };
            }
            if (BigInteger.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected void doSetValue(Object value) {
                        super.doSetValue((Object)("" + value));
                    }

                    protected Object doGetValue() {
                        String stringValue = (String)super.doGetValue();
                        return new BigInteger(stringValue);
                    }
                };
            }
            if (Double.TYPE.equals(this.eStructuralFeature.getEType().getInstanceClass()) || Double.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected void doSetValue(Object value) {
                        super.doSetValue((Object)("" + value));
                    }

                    protected Object doGetValue() {
                        String stringValue = (String)super.doGetValue();
                        return new Double(stringValue);
                    }
                };
            }
            if (Integer.TYPE.equals(this.eStructuralFeature.getEType().getInstanceClass()) || Integer.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected void doSetValue(Object value) {
                        super.doSetValue((Object)("" + value));
                    }

                    protected Object doGetValue() {
                        String stringValue = (String)super.doGetValue();
                        return Integer.valueOf(stringValue);
                    }
                };
            }
            if (Float.TYPE.equals(this.eStructuralFeature.getEType().getInstanceClass()) || Float.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected void doSetValue(Object value) {
                        super.doSetValue((Object)("" + value));
                    }

                    protected Object doGetValue() {
                        String stringValue = (String)super.doGetValue();
                        return new Float(stringValue);
                    }
                };
            }
            if (Short.TYPE.equals(this.eStructuralFeature.getEType().getInstanceClass()) || Short.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected void doSetValue(Object value) {
                        super.doSetValue((Object)("" + value));
                    }

                    protected Object doGetValue() {
                        String stringValue = (String)super.doGetValue();
                        return Short.valueOf(stringValue);
                    }
                };
            }
            if (Byte.TYPE.equals(this.eStructuralFeature.getEType().getInstanceClass()) || Byte.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected void doSetValue(Object value) {
                        super.doSetValue((Object)("" + value));
                    }

                    protected Object doGetValue() {
                        String stringValue = (String)super.doGetValue();
                        return Byte.valueOf(stringValue);
                    }
                };
            }
            if (Boolean.TYPE.equals(this.eStructuralFeature.getEType().getInstanceClass()) || Boolean.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new CheckboxCellEditor((Composite)this.getViewer().getControl()){

                    protected Object doGetValue() {
                        Boolean boolValue = (Boolean)super.doGetValue();
                        return boolValue;
                    }
                };
            }
            if (Date.class.equals((Object)this.eStructuralFeature.getEType().getInstanceClass())) {
                return new TextCellEditor((Composite)this.getViewer().getControl()){

                    protected Object doGetValue() {
                        String date = (String)super.doGetValue();
                        return date;
                    }
                };
            }
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            EObject eObjiect = (EObject)element;
            return eObjiect.eGet(this.eStructuralFeature) != null ? eObjiect.eGet(this.eStructuralFeature) : "";
        }

        protected void setValue(Object element, Object value) {
            EObject eObject;
            if (element instanceof EObject && (eObject = (EObject)element).eGet(this.eStructuralFeature) != null && !eObject.eGet(this.eStructuralFeature).equals(value)) {
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
                SetCommand setCommand = new SetCommand(domain, eObject, this.eStructuralFeature, value);
                domain.getCommandStack().execute((Command)setCommand);
                this.viewer.refresh();
            }
        }
    }
}

