/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.EventObject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.emf.parsley.resource.ResourceSaveStrategy;
import org.eclipse.emf.parsley.util.EmfCommandsUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractSaveableView
extends ViewPart
implements ISaveablePart,
IEditingDomainProvider {
    private Resource resource;
    private boolean dirty;
    private static final Logger LOGGER = Logger.getLogger(AbstractSaveableView.class);
    @Inject
    protected Provider<AdapterFactoryEditingDomain> editingDomainProvider;
    @Inject
    protected ResourceLoader resourceLoader;
    @Inject
    protected ResourceSaveStrategy resourceSaveStrategy;
    protected AdapterFactoryEditingDomain editingDomain;

    public void createPartControl(Composite parent) {
        this.initializeEditingDomain();
        URI uri = this.createResourceURI();
        this.loadResource(uri);
    }

    protected abstract URI createResourceURI();

    protected void loadResource(URI uri) {
        this.resource = this.resourceLoader.getResource(this.editingDomain, uri).getResource();
    }

    protected void initializeEditingDomain() {
        this.editingDomain = (AdapterFactoryEditingDomain)this.editingDomainProvider.get();
        this.editingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                AbstractSaveableView.this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Command mostRecentCommand = EmfCommandsUtil.mostRecentCommand((EventObject)event);
                        if (EmfCommandsUtil.affectsResource((Command)mostRecentCommand, (Resource)AbstractSaveableView.this.getResource())) {
                            AbstractSaveableView.this.mostRecentCommandAffectsResource(mostRecentCommand);
                        }
                        AbstractSaveableView.this.postCommandStackChanged(mostRecentCommand);
                    }
                });
            }
        });
    }

    protected void postCommandStackChanged(Command mostRecentCommand) {
    }

    protected void mostRecentCommandAffectsResource(Command mostRecentCommand) {
        this.setDirtyAndFirePropertyChange(true);
    }

    protected void setDirtyAndFirePropertyChange(boolean dirtyState) {
        this.setDirty(dirtyState);
        this.firePropertyChange(257);
    }

    protected Resource getResource() {
        return this.resource;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveResourceAndUpdateDirtyState();
        }
        catch (IOException e) {
            LOGGER.error((Object)"doSave", (Throwable)e);
        }
    }

    protected void saveResourceAndUpdateDirtyState() throws IOException {
        if (this.resourceSaveStrategy.save(this.resource)) {
            this.setDirtyAndFirePropertyChange(false);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }
}

