/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.parsley.viewers.ViewerFactory;
import org.eclipse.emf.parsley.views.AbstractOnSelectionView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBook;

public abstract class OnSelectionStructuredViewerAbstractView
extends AbstractOnSelectionView {
    private PageBook pagebook;
    private Label label;
    private StructuredViewer viewer;
    @Inject
    protected ViewerFactory viewerFactory;

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(StructuredViewer viewer) {
        this.viewer = viewer;
        this.pagebook.showPage(viewer.getControl());
    }

    @Override
    protected void updateOnSelection(IWorkbenchPart sourcepart, ISelection selection) {
        Object element = this.getFirstSelectedElement(selection);
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            this.performUpdateOnSelection(resource);
            this.showEmfViewer();
            return;
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            this.performUpdateOnSelection(eObject);
            this.showEmfViewer();
            return;
        }
        this.showText();
    }

    protected void performUpdateOnSelection(EObject eObject) {
        this.viewerFactory.initialize(this.viewer, (Object)eObject);
    }

    protected void performUpdateOnSelection(Resource resource) {
        this.viewerFactory.initialize(this.viewer, (Object)resource);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.pagebook = new PageBook(parent, 0);
        this.label = new Label((Composite)this.pagebook, 768);
        this.label.setText("Select one XMI resource in the explorer or any EObject in a view");
        this.viewer = this.createViewer((Composite)this.pagebook);
        this.showText();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected void showText() {
        this.pagebook.showPage((Control)this.label);
    }

    protected void showEmfViewer() {
        this.pagebook.showPage(this.viewer.getControl());
    }

    public void setFocus() {
        this.pagebook.setFocus();
    }

    public void init(URI resourceURI) {
        this.viewerFactory.initialize(this.viewer, resourceURI);
    }
}

