/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.composite;

import com.google.inject.Inject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.composite.AbstractDetailComposite;
import org.eclipse.emf.parsley.composite.FormControlFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FormDetailComposite
extends AbstractDetailComposite {
    private FormControlFactory formControlFactory;
    @Inject
    private ILabelProvider labelProvider;
    private final Composite main;
    private FormToolkit toolkit;
    private final ScrolledForm scrolledForm;
    private FormTitleAdapter headerAdapter;

    public FormDetailComposite(Composite parent, int style) {
        super(parent, style);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.adapt((Composite)this);
        this.setLayout((Layout)new GridLayout(1, false));
        this.scrolledForm = this.toolkit.createScrolledForm((Composite)this);
        this.scrolledForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.scrolledForm.getBody().setLayout((Layout)new GridLayout(2, false));
        this.main = this.scrolledForm.getBody();
        this.setBackgroundMode(2);
    }

    public void dispose() {
        this.headerAdapter.dispose();
        super.dispose();
        this.toolkit.dispose();
    }

    @Inject
    public void setFormControlFactory(FormControlFactory formControlFactory) {
        this.formControlFactory = formControlFactory;
    }

    @Override
    protected void initControlFactory(EditingDomain domain, EObject model) {
        this.updateTitle(model);
        this.headerAdapter = new FormTitleAdapter(model);
        model.eAdapters().add((Object)this.headerAdapter);
        this.formControlFactory.init(domain, model, this.main, this.toolkit);
    }

    protected void updateTitle(EObject model) {
        this.scrolledForm.setText(this.labelProvider.getText((Object)model));
        this.scrolledForm.setImage(this.labelProvider.getImage((Object)model));
    }

    protected ScrolledForm getScrolledForm() {
        return this.scrolledForm;
    }

    @Override
    protected void createControlForFeature(EClass eClass, EStructuralFeature feature) {
        this.formControlFactory.createEditingField(feature);
    }

    private class FormTitleAdapter
    extends AdapterImpl {
        private EObject model;
        private boolean disposing = false;

        public FormTitleAdapter(EObject model) {
            this.model = model;
        }

        public void dispose() {
            this.disposing = true;
            this.model.eAdapters().remove((Object)FormDetailComposite.this.headerAdapter);
        }

        public void notifyChanged(Notification msg) {
            if (!this.disposing) {
                FormDetailComposite.this.updateTitle(this.model);
            }
        }
    }
}

