/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class EmfParsleyUtil {
    protected EmfParsleyUtil() {
    }

    public static Collection<Object> ensureCollection(Object contents) {
        if (contents == null) {
            return Collections.emptyList();
        }
        return EmfParsleyUtil.ensureCollectionInternal(contents);
    }

    private static Collection<Object> ensureCollectionInternal(Object contents) {
        if (contents instanceof Collection) {
            return (Collection)contents;
        }
        if (contents instanceof Iterable) {
            return Lists.newArrayList((Iterable)((Iterable)contents));
        }
        if (contents instanceof Iterator) {
            return Lists.newArrayList((Iterator)((Iterator)contents));
        }
        if (contents.getClass().isArray()) {
            return Arrays.asList((Object[])contents);
        }
        return Collections.singleton(contents);
    }

    public static int[] toIntArray(List<Integer> intList) {
        int[] result = new int[intList.size()];
        int i = 0;
        for (Integer e : intList) {
            result[i++] = e;
        }
        return result;
    }

    public static EObject getEObjectOrNull(Object o) {
        if (o instanceof EObject) {
            return (EObject)o;
        }
        return null;
    }
}

