/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.menus;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.parsley.edit.actionbar.TreeActionBarContributor;
import org.eclipse.emf.parsley.edit.actionbar.WorkbenchActionBarContributor;
import org.eclipse.emf.parsley.viewers.ViewerSelectionProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;

public class ViewerContextMenuHelper {
    @Inject
    private Provider<AdapterFactoryEditingDomain> editingDomainProvider;
    @Inject
    private TreeActionBarContributor treeActionBarContributor;
    @Inject
    private WorkbenchActionBarContributor workbenchActionBarContributor;

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        return menuManager;
    }

    public void addViewerContextMenu(Viewer viewer, AdapterFactoryEditingDomain editingDomain, IWorkbenchPart activePart, IMenuListener menuListener, WorkbenchActionBarContributor actionBarContributor) {
        MenuManager menuManager = this.createContextMenu(viewer, editingDomain);
        activePart.getSite().registerContextMenu(menuManager, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        menuManager.addMenuListener(menuListener);
        this.bridgeSelectionProviderAndActionBarContributor(viewer, actionBarContributor);
        actionBarContributor.setActivePart(activePart);
    }

    public void addViewerContextMenu(StructuredViewer viewer, AdapterFactoryEditingDomain editingDomain, IWorkbenchPart activePart) {
        MenuManager menuManager = this.createContextMenu((Viewer)viewer, editingDomain, this.workbenchActionBarContributor);
        activePart.getSite().registerContextMenu(menuManager, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        this.bridgeSelectionProviderAndActionBarContributor((Viewer)viewer, this.workbenchActionBarContributor);
        this.workbenchActionBarContributor.setActivePart(activePart);
    }

    public void addViewerContextMenu(StructuredViewer viewer) {
        this.addViewerContextMenu((Viewer)viewer, (AdapterFactoryEditingDomain)this.editingDomainProvider.get());
    }

    public void addViewerContextMenu(Viewer viewer, AdapterFactoryEditingDomain editingDomain) {
        this.createContextMenu(viewer, editingDomain, this.treeActionBarContributor);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.treeActionBarContributor);
        this.treeActionBarContributor.initialize((EditingDomain)editingDomain);
    }

    private MenuManager createContextMenu(Viewer viewer, AdapterFactoryEditingDomain editingDomain) {
        MenuManager menuManager = this.createMenuManager();
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        return menuManager;
    }

    private MenuManager createContextMenu(Viewer viewer, AdapterFactoryEditingDomain editingDomain, final IMenuListener menuListener) {
        MenuManager menuManager = this.createContextMenu(viewer, editingDomain);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                menuListener.menuAboutToShow(manager);
            }
        });
        return menuManager;
    }

    private void bridgeSelectionProviderAndActionBarContributor(Viewer viewer, WorkbenchActionBarContributor actionBarContributor) {
        ViewerSelectionProvider viewerSelectionProvider = new ViewerSelectionProvider(viewer);
        actionBarContributor.setExplicitSelectionProvider(viewerSelectionProvider);
        viewerSelectionProvider.addSelectionChangedListener(actionBarContributor);
    }
}

