/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.parsley.edit.ui.provider.TableViewerContentProviderFactory;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.emf.parsley.viewers.TableViewerColumnBuilder;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ViewerFactory {
    @Inject
    private Provider<IContentProvider> contentProviderProvider;
    @Inject
    private Provider<ILabelProvider> labelProviderProvider;
    @Inject
    private ResourceLoader resourceLoader;
    @Inject
    private Provider<AdapterFactoryEditingDomain> editingDomainProvider;
    @Inject
    private TableViewerColumnBuilder columnBuilder;
    @Inject
    private TableViewerContentProviderFactory tableViewerContentProviderFactory;

    public void initialize(StructuredViewer viewer, URI uri) {
        this.initialize(viewer, this.loadResource(uri));
    }

    public void initialize(StructuredViewer viewer, AdapterFactoryEditingDomain editingDomain) {
        this.initialize(viewer, editingDomain.getResourceSet());
    }

    public void initialize(StructuredViewer viewer, Object object) {
        this.initialize(viewer, object, (IContentProvider)this.contentProviderProvider.get(), (IBaseLabelProvider)this.labelProviderProvider.get());
    }

    public TableViewer createTableViewer(Composite parent, int style, EClass type) {
        TableViewer tableViewer = this.createTableViewer(parent, style);
        this.buildColumns(tableViewer, type);
        return tableViewer;
    }

    public void buildColumns(TableViewer tableViewer, EClass eClass) {
        this.buildColumns(tableViewer, eClass, (IStructuredContentProvider)this.tableViewerContentProviderFactory.createTableViewerContentProvider(eClass));
    }

    private void initialize(StructuredViewer viewer, Object input, IContentProvider contentProvider, IBaseLabelProvider labelProvider) {
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(labelProvider);
        viewer.setInput(input);
    }

    private void buildColumns(TableViewer tableViewer, EClass eClass, IStructuredContentProvider contentProvider) {
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.columnBuilder.buildTableViewer(tableViewer, eClass);
    }

    private AdapterFactoryEditingDomain loadResource(URI resourceURI) {
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)this.editingDomainProvider.get();
        this.resourceLoader.getResource(editingDomain, resourceURI);
        return editingDomain;
    }

    private TableViewer createTableViewer(Composite parent, int style) {
        Composite viewerContainer = new Composite(parent, 2048);
        TableColumnLayout layout = new TableColumnLayout();
        viewerContainer.setLayout((Layout)layout);
        return new TableViewer(viewerContainer, style);
    }
}

