/**
 */
package org.eclipse.emf.parsley.dsl.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.emf.parsley.dsl.model.AbstractFeatureCaptionProviderWithLabel;
import org.eclipse.emf.parsley.dsl.model.FeatureAssociatedExpression;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract Feature Caption Provider With Label</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.emf.parsley.dsl.model.impl.AbstractFeatureCaptionProviderWithLabelImpl#getSpecifications <em>Specifications</em>}</li>
 *   <li>{@link org.eclipse.emf.parsley.dsl.model.impl.AbstractFeatureCaptionProviderWithLabelImpl#getLabelSpecifications <em>Label Specifications</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AbstractFeatureCaptionProviderWithLabelImpl extends WithFieldsImpl implements AbstractFeatureCaptionProviderWithLabel
{
  /**
   * The cached value of the '{@link #getSpecifications() <em>Specifications</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getSpecifications()
   * @generated
   * @ordered
   */
  protected EList<FeatureAssociatedExpression> specifications;

  /**
   * The cached value of the '{@link #getLabelSpecifications() <em>Label Specifications</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getLabelSpecifications()
   * @generated
   * @ordered
   */
  protected EList<FeatureAssociatedExpression> labelSpecifications;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected AbstractFeatureCaptionProviderWithLabelImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  protected EClass eStaticClass()
  {
    return ModelPackage.Literals.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<FeatureAssociatedExpression> getSpecifications()
  {
    if (specifications == null)
    {
      specifications = new EObjectContainmentEList<FeatureAssociatedExpression>(FeatureAssociatedExpression.class, this, ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__SPECIFICATIONS);
    }
    return specifications;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<FeatureAssociatedExpression> getLabelSpecifications()
  {
    if (labelSpecifications == null)
    {
      labelSpecifications = new EObjectContainmentEList<FeatureAssociatedExpression>(FeatureAssociatedExpression.class, this, ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__LABEL_SPECIFICATIONS);
    }
    return labelSpecifications;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
  {
    switch (featureID)
    {
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__SPECIFICATIONS:
        return ((InternalEList<?>)getSpecifications()).basicRemove(otherEnd, msgs);
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__LABEL_SPECIFICATIONS:
        return ((InternalEList<?>)getLabelSpecifications()).basicRemove(otherEnd, msgs);
    }
    return super.eInverseRemove(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object eGet(int featureID, boolean resolve, boolean coreType)
  {
    switch (featureID)
    {
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__SPECIFICATIONS:
        return getSpecifications();
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__LABEL_SPECIFICATIONS:
        return getLabelSpecifications();
    }
    return super.eGet(featureID, resolve, coreType);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @SuppressWarnings("unchecked")
  @Override
  public void eSet(int featureID, Object newValue)
  {
    switch (featureID)
    {
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__SPECIFICATIONS:
        getSpecifications().clear();
        getSpecifications().addAll((Collection<? extends FeatureAssociatedExpression>)newValue);
        return;
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__LABEL_SPECIFICATIONS:
        getLabelSpecifications().clear();
        getLabelSpecifications().addAll((Collection<? extends FeatureAssociatedExpression>)newValue);
        return;
    }
    super.eSet(featureID, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void eUnset(int featureID)
  {
    switch (featureID)
    {
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__SPECIFICATIONS:
        getSpecifications().clear();
        return;
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__LABEL_SPECIFICATIONS:
        getLabelSpecifications().clear();
        return;
    }
    super.eUnset(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean eIsSet(int featureID)
  {
    switch (featureID)
    {
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__SPECIFICATIONS:
        return specifications != null && !specifications.isEmpty();
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL__LABEL_SPECIFICATIONS:
        return labelSpecifications != null && !labelSpecifications.isEmpty();
    }
    return super.eIsSet(featureID);
  }

} //AbstractFeatureCaptionProviderWithLabelImpl
