/**
 */
package org.eclipse.emf.parsley.dsl.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.emf.parsley.dsl.model.Configurator;
import org.eclipse.emf.parsley.dsl.model.LabelSpecification;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Configurator</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.emf.parsley.dsl.model.impl.ConfiguratorImpl#getResourceURISpecifications <em>Resource URI Specifications</em>}</li>
 *   <li>{@link org.eclipse.emf.parsley.dsl.model.impl.ConfiguratorImpl#getEClassSpecifications <em>EClass Specifications</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ConfiguratorImpl extends WithFieldsImpl implements Configurator
{
  /**
   * The cached value of the '{@link #getResourceURISpecifications() <em>Resource URI Specifications</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getResourceURISpecifications()
   * @generated
   * @ordered
   */
  protected EList<LabelSpecification> resourceURISpecifications;

  /**
   * The cached value of the '{@link #getEClassSpecifications() <em>EClass Specifications</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getEClassSpecifications()
   * @generated
   * @ordered
   */
  protected EList<LabelSpecification> eClassSpecifications;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ConfiguratorImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  protected EClass eStaticClass()
  {
    return ModelPackage.Literals.CONFIGURATOR;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<LabelSpecification> getResourceURISpecifications()
  {
    if (resourceURISpecifications == null)
    {
      resourceURISpecifications = new EObjectContainmentEList<LabelSpecification>(LabelSpecification.class, this, ModelPackage.CONFIGURATOR__RESOURCE_URI_SPECIFICATIONS);
    }
    return resourceURISpecifications;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<LabelSpecification> getEClassSpecifications()
  {
    if (eClassSpecifications == null)
    {
      eClassSpecifications = new EObjectContainmentEList<LabelSpecification>(LabelSpecification.class, this, ModelPackage.CONFIGURATOR__ECLASS_SPECIFICATIONS);
    }
    return eClassSpecifications;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
  {
    switch (featureID)
    {
      case ModelPackage.CONFIGURATOR__RESOURCE_URI_SPECIFICATIONS:
        return ((InternalEList<?>)getResourceURISpecifications()).basicRemove(otherEnd, msgs);
      case ModelPackage.CONFIGURATOR__ECLASS_SPECIFICATIONS:
        return ((InternalEList<?>)getEClassSpecifications()).basicRemove(otherEnd, msgs);
    }
    return super.eInverseRemove(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object eGet(int featureID, boolean resolve, boolean coreType)
  {
    switch (featureID)
    {
      case ModelPackage.CONFIGURATOR__RESOURCE_URI_SPECIFICATIONS:
        return getResourceURISpecifications();
      case ModelPackage.CONFIGURATOR__ECLASS_SPECIFICATIONS:
        return getEClassSpecifications();
    }
    return super.eGet(featureID, resolve, coreType);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @SuppressWarnings("unchecked")
  @Override
  public void eSet(int featureID, Object newValue)
  {
    switch (featureID)
    {
      case ModelPackage.CONFIGURATOR__RESOURCE_URI_SPECIFICATIONS:
        getResourceURISpecifications().clear();
        getResourceURISpecifications().addAll((Collection<? extends LabelSpecification>)newValue);
        return;
      case ModelPackage.CONFIGURATOR__ECLASS_SPECIFICATIONS:
        getEClassSpecifications().clear();
        getEClassSpecifications().addAll((Collection<? extends LabelSpecification>)newValue);
        return;
    }
    super.eSet(featureID, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void eUnset(int featureID)
  {
    switch (featureID)
    {
      case ModelPackage.CONFIGURATOR__RESOURCE_URI_SPECIFICATIONS:
        getResourceURISpecifications().clear();
        return;
      case ModelPackage.CONFIGURATOR__ECLASS_SPECIFICATIONS:
        getEClassSpecifications().clear();
        return;
    }
    super.eUnset(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean eIsSet(int featureID)
  {
    switch (featureID)
    {
      case ModelPackage.CONFIGURATOR__RESOURCE_URI_SPECIFICATIONS:
        return resourceURISpecifications != null && !resourceURISpecifications.isEmpty();
      case ModelPackage.CONFIGURATOR__ECLASS_SPECIFICATIONS:
        return eClassSpecifications != null && !eClassSpecifications.isEmpty();
    }
    return super.eIsSet(featureID);
  }

} //ConfiguratorImpl
