/**
 */
package org.eclipse.emf.parsley.dsl.model.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.emf.parsley.dsl.model.LabelSpecification;
import org.eclipse.emf.parsley.dsl.model.MenuBuilder;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Menu Builder</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.emf.parsley.dsl.model.impl.MenuBuilderImpl#getMenuSpecifications <em>Menu Specifications</em>}</li>
 *   <li>{@link org.eclipse.emf.parsley.dsl.model.impl.MenuBuilderImpl#getEmfMenuSpecifications <em>Emf Menu Specifications</em>}</li>
 * </ul>
 *
 * @generated
 */
public class MenuBuilderImpl extends WithFieldsImpl implements MenuBuilder
{
  /**
   * The cached value of the '{@link #getMenuSpecifications() <em>Menu Specifications</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getMenuSpecifications()
   * @generated
   * @ordered
   */
  protected EList<LabelSpecification> menuSpecifications;

  /**
   * The cached value of the '{@link #getEmfMenuSpecifications() <em>Emf Menu Specifications</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getEmfMenuSpecifications()
   * @generated
   * @ordered
   */
  protected EList<LabelSpecification> emfMenuSpecifications;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected MenuBuilderImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  protected EClass eStaticClass()
  {
    return ModelPackage.Literals.MENU_BUILDER;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<LabelSpecification> getMenuSpecifications()
  {
    if (menuSpecifications == null)
    {
      menuSpecifications = new EObjectContainmentEList<LabelSpecification>(LabelSpecification.class, this, ModelPackage.MENU_BUILDER__MENU_SPECIFICATIONS);
    }
    return menuSpecifications;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<LabelSpecification> getEmfMenuSpecifications()
  {
    if (emfMenuSpecifications == null)
    {
      emfMenuSpecifications = new EObjectContainmentEList<LabelSpecification>(LabelSpecification.class, this, ModelPackage.MENU_BUILDER__EMF_MENU_SPECIFICATIONS);
    }
    return emfMenuSpecifications;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
  {
    switch (featureID)
    {
      case ModelPackage.MENU_BUILDER__MENU_SPECIFICATIONS:
        return ((InternalEList<?>)getMenuSpecifications()).basicRemove(otherEnd, msgs);
      case ModelPackage.MENU_BUILDER__EMF_MENU_SPECIFICATIONS:
        return ((InternalEList<?>)getEmfMenuSpecifications()).basicRemove(otherEnd, msgs);
    }
    return super.eInverseRemove(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object eGet(int featureID, boolean resolve, boolean coreType)
  {
    switch (featureID)
    {
      case ModelPackage.MENU_BUILDER__MENU_SPECIFICATIONS:
        return getMenuSpecifications();
      case ModelPackage.MENU_BUILDER__EMF_MENU_SPECIFICATIONS:
        return getEmfMenuSpecifications();
    }
    return super.eGet(featureID, resolve, coreType);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @SuppressWarnings("unchecked")
  @Override
  public void eSet(int featureID, Object newValue)
  {
    switch (featureID)
    {
      case ModelPackage.MENU_BUILDER__MENU_SPECIFICATIONS:
        getMenuSpecifications().clear();
        getMenuSpecifications().addAll((Collection<? extends LabelSpecification>)newValue);
        return;
      case ModelPackage.MENU_BUILDER__EMF_MENU_SPECIFICATIONS:
        getEmfMenuSpecifications().clear();
        getEmfMenuSpecifications().addAll((Collection<? extends LabelSpecification>)newValue);
        return;
    }
    super.eSet(featureID, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void eUnset(int featureID)
  {
    switch (featureID)
    {
      case ModelPackage.MENU_BUILDER__MENU_SPECIFICATIONS:
        getMenuSpecifications().clear();
        return;
      case ModelPackage.MENU_BUILDER__EMF_MENU_SPECIFICATIONS:
        getEmfMenuSpecifications().clear();
        return;
    }
    super.eUnset(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean eIsSet(int featureID)
  {
    switch (featureID)
    {
      case ModelPackage.MENU_BUILDER__MENU_SPECIFICATIONS:
        return menuSpecifications != null && !menuSpecifications.isEmpty();
      case ModelPackage.MENU_BUILDER__EMF_MENU_SPECIFICATIONS:
        return emfMenuSpecifications != null && !emfMenuSpecifications.isEmpty();
    }
    return super.eIsSet(featureID);
  }

} //MenuBuilderImpl
