/**
 */
package org.eclipse.emf.parsley.dsl.model.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.emf.parsley.dsl.model.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ModelFactoryImpl extends EFactoryImpl implements ModelFactory
{
  /**
   * Creates the default factory implementation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static ModelFactory init()
  {
    try
    {
      ModelFactory theModelFactory = (ModelFactory)EPackage.Registry.INSTANCE.getEFactory(ModelPackage.eNS_URI);
      if (theModelFactory != null)
      {
        return theModelFactory;
      }
    }
    catch (Exception exception)
    {
      EcorePlugin.INSTANCE.log(exception);
    }
    return new ModelFactoryImpl();
  }

  /**
   * Creates an instance of the factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ModelFactoryImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EObject create(EClass eClass)
  {
    switch (eClass.getClassifierID())
    {
      case ModelPackage.MODEL: return createModel();
      case ModelPackage.MODULE: return createModule();
      case ModelPackage.EXTENDS_CLAUSE: return createExtendsClause();
      case ModelPackage.BINDINGS_SPECIFICATION: return createBindingsSpecification();
      case ModelPackage.BINDING: return createBinding();
      case ModelPackage.LABEL_PROVIDER: return createLabelProvider();
      case ModelPackage.FIELD_SPECIFICATION: return createFieldSpecification();
      case ModelPackage.TABLE_LABEL_PROVIDER: return createTableLabelProvider();
      case ModelPackage.LABEL_SPECIFICATION: return createLabelSpecification();
      case ModelPackage.FEATURE_CAPTION_PROVIDER: return createFeatureCaptionProvider();
      case ModelPackage.FORM_FEATURE_CAPTION_PROVIDER: return createFormFeatureCaptionProvider();
      case ModelPackage.DIALOG_FEATURE_CAPTION_PROVIDER: return createDialogFeatureCaptionProvider();
      case ModelPackage.FEATURE_ASSOCIATED_EXPRESSION: return createFeatureAssociatedExpression();
      case ModelPackage.FEATURES_PROVIDER: return createFeaturesProvider();
      case ModelPackage.TABLE_FEATURES_PROVIDER: return createTableFeaturesProvider();
      case ModelPackage.FEATURE_SPECIFICATION: return createFeatureSpecification();
      case ModelPackage.FORM_CONTROL_FACTORY: return createFormControlFactory();
      case ModelPackage.DIALOG_CONTROL_FACTORY: return createDialogControlFactory();
      case ModelPackage.CONTROL_FACTORY_SPECIFICATION: return createControlFactorySpecification();
      case ModelPackage.PROPOSAL_CREATOR: return createProposalCreator();
      case ModelPackage.MENU_BUILDER: return createMenuBuilder();
      case ModelPackage.CONFIGURATOR: return createConfigurator();
      case ModelPackage.VIEWER_CONTENT_PROVIDER: return createViewerContentProvider();
      case ModelPackage.TABLE_VIEWER_CONTENT_PROVIDER: return createTableViewerContentProvider();
      case ModelPackage.RESOURCE_MANAGER: return createResourceManager();
      case ModelPackage.SIMPLE_METHOD_SPECIFICATION: return createSimpleMethodSpecification();
      case ModelPackage.EMF_FEATURE_ACCESS: return createEmfFeatureAccess();
      case ModelPackage.ABSTRACT_FEATURE_CAPTION_PROVIDER_WITH_LABEL: return createAbstractFeatureCaptionProviderWithLabel();
      case ModelPackage.ABSTRACT_FEATURE_PROVIDER: return createAbstractFeatureProvider();
      case ModelPackage.ABSTRACT_CONTROL_FACTORY: return createAbstractControlFactory();
      case ModelPackage.WITH_EXTENDS_CLAUSE: return createWithExtendsClause();
      case ModelPackage.WITH_FIELDS: return createWithFields();
      case ModelPackage.PARTS_SPECIFICATIONS: return createPartsSpecifications();
      case ModelPackage.PART_SPECIFICATION: return createPartSpecification();
      case ModelPackage.VIEW_SPECIFICATION: return createViewSpecification();
      case ModelPackage.TYPE_BINDING: return createTypeBinding();
      case ModelPackage.PROVIDER_BINDING: return createProviderBinding();
      case ModelPackage.VALUE_BINDING: return createValueBinding();
      default:
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Model createModel()
  {
    ModelImpl model = new ModelImpl();
    return model;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Module createModule()
  {
    ModuleImpl module = new ModuleImpl();
    return module;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ExtendsClause createExtendsClause()
  {
    ExtendsClauseImpl extendsClause = new ExtendsClauseImpl();
    return extendsClause;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BindingsSpecification createBindingsSpecification()
  {
    BindingsSpecificationImpl bindingsSpecification = new BindingsSpecificationImpl();
    return bindingsSpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Binding createBinding()
  {
    BindingImpl binding = new BindingImpl();
    return binding;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public LabelProvider createLabelProvider()
  {
    LabelProviderImpl labelProvider = new LabelProviderImpl();
    return labelProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public FieldSpecification createFieldSpecification()
  {
    FieldSpecificationImpl fieldSpecification = new FieldSpecificationImpl();
    return fieldSpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TableLabelProvider createTableLabelProvider()
  {
    TableLabelProviderImpl tableLabelProvider = new TableLabelProviderImpl();
    return tableLabelProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public LabelSpecification createLabelSpecification()
  {
    LabelSpecificationImpl labelSpecification = new LabelSpecificationImpl();
    return labelSpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public FeatureCaptionProvider createFeatureCaptionProvider()
  {
    FeatureCaptionProviderImpl featureCaptionProvider = new FeatureCaptionProviderImpl();
    return featureCaptionProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public FormFeatureCaptionProvider createFormFeatureCaptionProvider()
  {
    FormFeatureCaptionProviderImpl formFeatureCaptionProvider = new FormFeatureCaptionProviderImpl();
    return formFeatureCaptionProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DialogFeatureCaptionProvider createDialogFeatureCaptionProvider()
  {
    DialogFeatureCaptionProviderImpl dialogFeatureCaptionProvider = new DialogFeatureCaptionProviderImpl();
    return dialogFeatureCaptionProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public FeatureAssociatedExpression createFeatureAssociatedExpression()
  {
    FeatureAssociatedExpressionImpl featureAssociatedExpression = new FeatureAssociatedExpressionImpl();
    return featureAssociatedExpression;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public FeaturesProvider createFeaturesProvider()
  {
    FeaturesProviderImpl featuresProvider = new FeaturesProviderImpl();
    return featuresProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TableFeaturesProvider createTableFeaturesProvider()
  {
    TableFeaturesProviderImpl tableFeaturesProvider = new TableFeaturesProviderImpl();
    return tableFeaturesProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public FeatureSpecification createFeatureSpecification()
  {
    FeatureSpecificationImpl featureSpecification = new FeatureSpecificationImpl();
    return featureSpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public FormControlFactory createFormControlFactory()
  {
    FormControlFactoryImpl formControlFactory = new FormControlFactoryImpl();
    return formControlFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public DialogControlFactory createDialogControlFactory()
  {
    DialogControlFactoryImpl dialogControlFactory = new DialogControlFactoryImpl();
    return dialogControlFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ControlFactorySpecification createControlFactorySpecification()
  {
    ControlFactorySpecificationImpl controlFactorySpecification = new ControlFactorySpecificationImpl();
    return controlFactorySpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ProposalCreator createProposalCreator()
  {
    ProposalCreatorImpl proposalCreator = new ProposalCreatorImpl();
    return proposalCreator;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public MenuBuilder createMenuBuilder()
  {
    MenuBuilderImpl menuBuilder = new MenuBuilderImpl();
    return menuBuilder;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Configurator createConfigurator()
  {
    ConfiguratorImpl configurator = new ConfiguratorImpl();
    return configurator;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ViewerContentProvider createViewerContentProvider()
  {
    ViewerContentProviderImpl viewerContentProvider = new ViewerContentProviderImpl();
    return viewerContentProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TableViewerContentProvider createTableViewerContentProvider()
  {
    TableViewerContentProviderImpl tableViewerContentProvider = new TableViewerContentProviderImpl();
    return tableViewerContentProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ResourceManager createResourceManager()
  {
    ResourceManagerImpl resourceManager = new ResourceManagerImpl();
    return resourceManager;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SimpleMethodSpecification createSimpleMethodSpecification()
  {
    SimpleMethodSpecificationImpl simpleMethodSpecification = new SimpleMethodSpecificationImpl();
    return simpleMethodSpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EmfFeatureAccess createEmfFeatureAccess()
  {
    EmfFeatureAccessImpl emfFeatureAccess = new EmfFeatureAccessImpl();
    return emfFeatureAccess;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public AbstractFeatureCaptionProviderWithLabel createAbstractFeatureCaptionProviderWithLabel()
  {
    AbstractFeatureCaptionProviderWithLabelImpl abstractFeatureCaptionProviderWithLabel = new AbstractFeatureCaptionProviderWithLabelImpl();
    return abstractFeatureCaptionProviderWithLabel;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public AbstractFeatureProvider createAbstractFeatureProvider()
  {
    AbstractFeatureProviderImpl abstractFeatureProvider = new AbstractFeatureProviderImpl();
    return abstractFeatureProvider;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public AbstractControlFactory createAbstractControlFactory()
  {
    AbstractControlFactoryImpl abstractControlFactory = new AbstractControlFactoryImpl();
    return abstractControlFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public WithExtendsClause createWithExtendsClause()
  {
    WithExtendsClauseImpl withExtendsClause = new WithExtendsClauseImpl();
    return withExtendsClause;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public WithFields createWithFields()
  {
    WithFieldsImpl withFields = new WithFieldsImpl();
    return withFields;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public PartsSpecifications createPartsSpecifications()
  {
    PartsSpecificationsImpl partsSpecifications = new PartsSpecificationsImpl();
    return partsSpecifications;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public PartSpecification createPartSpecification()
  {
    PartSpecificationImpl partSpecification = new PartSpecificationImpl();
    return partSpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ViewSpecification createViewSpecification()
  {
    ViewSpecificationImpl viewSpecification = new ViewSpecificationImpl();
    return viewSpecification;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TypeBinding createTypeBinding()
  {
    TypeBindingImpl typeBinding = new TypeBindingImpl();
    return typeBinding;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ProviderBinding createProviderBinding()
  {
    ProviderBindingImpl providerBinding = new ProviderBindingImpl();
    return providerBinding;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ValueBinding createValueBinding()
  {
    ValueBindingImpl valueBinding = new ValueBindingImpl();
    return valueBinding;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ModelPackage getModelPackage()
  {
    return (ModelPackage)getEPackage();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @deprecated
   * @generated
   */
  @Deprecated
  public static ModelPackage getPackage()
  {
    return ModelPackage.eINSTANCE;
  }

} //ModelFactoryImpl
