/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.parsley.dsl.jvmmodel.EmfParsleyDslGeneratorUtils;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EmfParsleyDslPluginXmlGenerator
implements IGenerator {
    @Inject
    @Extension
    private EmfParsleyDslGeneratorUtils _emfParsleyDslGeneratorUtils;

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator _allContents = resource.getAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_allContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, Module.class);
        for (Module module : _filter) {
            boolean _greaterThan;
            CharSequence contents = this.generatePluginXml(module);
            int _length = contents.length();
            boolean bl = _greaterThan = _length > 0;
            if (!_greaterThan) continue;
            fsa.generateFile("../plugin.xml_emfparsley_gen", "PROJECT_ROOT", contents);
        }
    }

    public CharSequence generatePluginXml(Module module) {
        boolean _isEmpty;
        CharSequence _xblockexpression = null;
        PartsSpecifications _partsSpecifications = null;
        if (module != null) {
            _partsSpecifications = module.getPartsSpecifications();
        }
        EList<PartSpecification> _parts = null;
        if (_partsSpecifications != null) {
            _parts = _partsSpecifications.getParts();
        }
        EList<PartSpecification> partSpecs = _parts;
        CharSequence _xifexpression = null;
        boolean _or = false;
        boolean _equals = Objects.equal(partSpecs, null);
        _or = _equals ? true : (_isEmpty = partSpecs.isEmpty());
        if (_or) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append((Object)"<extension");
        _builder_1.newLine();
        _builder_1.append((Object)"      ");
        _builder_1.append((Object)"point=\"org.eclipse.ui.views\">");
        _builder_1.newLine();
        _builder_1.append((Object)"    ");
        Functions.Function1<PartSpecification, CharSequence> _function = new Functions.Function1<PartSpecification, CharSequence>(){

            public CharSequence apply(PartSpecification it) {
                return EmfParsleyDslPluginXmlGenerator.this.generateExtensionPoint(it);
            }
        };
        List _map = ListExtensions.map(partSpecs, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"");
        _builder_1.append((Object)_join, "    ");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append((Object)"</extension>");
        _builder_1.newLine();
        _xblockexpression = _xifexpression = this.generatePluginXml((CharSequence)_builder_1);
        return _xblockexpression;
    }

    protected CharSequence _generateExtensionPoint(PartSpecification partSpecification) {
        return null;
    }

    protected CharSequence _generateExtensionPoint(ViewSpecification viewSpecification) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<view");
        _builder.newLine();
        _builder.append((Object)"      ");
        _builder.append((Object)"category=\"");
        String _xifexpression = null;
        boolean _or = false;
        String _category = viewSpecification.getCategory();
        boolean _equals = Objects.equal((Object)_category, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isEmpty;
            String _category_1 = viewSpecification.getCategory();
            _or = _isEmpty = _category_1.isEmpty();
        }
        _xifexpression = _or ? "org.eclipse.emf.parsley" : viewSpecification.getCategory();
        _builder.append((Object)_xifexpression, "      ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"      ");
        _builder.append((Object)"class=\"");
        String _executableExtensionFactoryQN = this._emfParsleyDslGeneratorUtils.executableExtensionFactoryQN(viewSpecification);
        _builder.append((Object)_executableExtensionFactoryQN, "      ");
        _builder.append((Object)":");
        JvmTypeReference _type = viewSpecification.getType();
        String _identifier = _type.getIdentifier();
        _builder.append((Object)_identifier, "      ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"      ");
        _builder.append((Object)"id=\"");
        String _id = viewSpecification.getId();
        _builder.append((Object)_id, "      ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"      ");
        _builder.append((Object)"name=\"");
        String _viewName = viewSpecification.getViewName();
        _builder.append((Object)_viewName, "      ");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"      ");
        _builder.append((Object)"restorable=\"true\">");
        _builder.newLine();
        _builder.append((Object)"</view>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePluginXml(CharSequence contents) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<?eclipse version=\"3.4\"?>");
        _builder.newLine();
        _builder.append((Object)"<plugin>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)contents, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</plugin>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateExtensionPoint(PartSpecification viewSpecification) {
        if (viewSpecification instanceof ViewSpecification) {
            return this._generateExtensionPoint((ViewSpecification)viewSpecification);
        }
        if (viewSpecification != null) {
            return this._generateExtensionPoint(viewSpecification);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(viewSpecification).toString());
    }
}

