/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.generator.common;

import com.google.common.base.Objects;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGeneratorUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Lorenzo Bettini - initial API and implementation
 */
@SuppressWarnings("all")
public class EmfParsleyProjectFilesGenerator {
  public CharSequence activatorName(final String projectName) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildClassNameFromProject = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(projectName);
    _builder.append(_buildClassNameFromProject, "");
    _builder.append("Activator");
    return _builder;
  }
  
  public CharSequence moduleName(final String projectName) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildClassNameFromProject = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(projectName);
    _builder.append(_buildClassNameFromProject, "");
    _builder.append("GuiceModule");
    return _builder;
  }
  
  public CharSequence extFactoryName(final String projectName) {
    StringConcatenation _builder = new StringConcatenation();
    String _buildClassNameFromProject = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(projectName);
    _builder.append(_buildClassNameFromProject, "");
    _builder.append("ExecutableExtensionFactory");
    return _builder;
  }
  
  public CharSequence generateManifest(final String projectName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Manifest-Version: 1.0");
    _builder.newLine();
    _builder.append("Bundle-ManifestVersion: 2");
    _builder.newLine();
    _builder.append("Bundle-Name: ");
    _builder.append(projectName, "");
    _builder.newLineIfNotEmpty();
    _builder.append("Bundle-SymbolicName: ");
    _builder.append(projectName, "");
    _builder.append(";singleton:=true");
    _builder.newLineIfNotEmpty();
    _builder.append("Bundle-Version: 1.0.0.qualifier");
    _builder.newLine();
    _builder.append("Bundle-Activator: ");
    _builder.append(projectName, "");
    _builder.append(".");
    CharSequence _activatorName = this.activatorName(projectName);
    _builder.append(_activatorName, "");
    _builder.newLineIfNotEmpty();
    _builder.append("Require-Bundle: org.eclipse.ui,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.core.runtime,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.emf.parsley,");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("org.eclipse.emf.parsley.views");
    _builder.newLine();
    _builder.append("Bundle-ActivationPolicy: lazy");
    _builder.newLine();
    _builder.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.6");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateBuildProperties(final boolean hasPluginXml) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("source.. = src/");
    _builder.newLine();
    _builder.append("output.. = bin/");
    _builder.newLine();
    _builder.append("bin.includes = META-INF/,\\");
    _builder.newLine();
    _builder.append("               ");
    _builder.append(".");
    {
      if (hasPluginXml) {
        _builder.append(",\\");
        _builder.newLineIfNotEmpty();
        _builder.append("               ");
        _builder.append("plugin.xml");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateActivator(final String projectName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(projectName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import org.osgi.framework.BundleContext;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.emf.parsley.EmfParsleyGuiceModule;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.parsley.ui.EmfParsleyAbstractActivator;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* The activator class controls the plug-in life cycle");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public class ");
    CharSequence _activatorName = this.activatorName(projectName);
    _builder.append(_activatorName, "");
    _builder.append(" extends EmfParsleyAbstractActivator {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// The plug-in ID");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static final String PLUGIN_ID = \"");
    _builder.append(projectName, "\t");
    _builder.append("\"; //$NON-NLS-1$");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// The shared instance");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static ");
    CharSequence _activatorName_1 = this.activatorName(projectName);
    _builder.append(_activatorName_1, "\t");
    _builder.append(" plugin;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _activatorName_2 = this.activatorName(projectName);
    _builder.append(_activatorName_2, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* (non-Javadoc)");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void start(BundleContext context) throws Exception {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.start(context);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("plugin = this;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* (non-Javadoc)");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void stop(BundleContext context) throws Exception {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("plugin = null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.stop(context);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Returns the shared instance");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return the shared instance");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static ");
    CharSequence _activatorName_3 = this.activatorName(projectName);
    _builder.append(_activatorName_3, "\t");
    _builder.append(" getDefault() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return plugin;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Creates the EmfParsleyGuiceModule for this this plugin");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return the EmfParsleyGuiceModule for this this plugin");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public EmfParsleyGuiceModule createModule() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new ");
    CharSequence _moduleName = this.moduleName(projectName);
    _builder.append(_moduleName, "\t\t");
    _builder.append("(getDefault());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateExecutableExtensionFactory(final String projectName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(projectName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import org.osgi.framework.Bundle;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.emf.parsley.EmfParsleyExtensionFactory;");
    _builder.newLine();
    _builder.append("import org.eclipse.emf.parsley.EmfParsleyGuiceModule;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import com.google.inject.Injector;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class ");
    CharSequence _extFactoryName = this.extFactoryName(projectName);
    _builder.append(_extFactoryName, "");
    _builder.append(" extends");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("EmfParsleyExtensionFactory {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected Bundle getBundle() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _activatorName = this.activatorName(projectName);
    _builder.append(_activatorName, "\t\t");
    _builder.append(".getDefault().getBundle();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected EmfParsleyGuiceModule getModule() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _activatorName_1 = this.activatorName(projectName);
    _builder.append(_activatorName_1, "\t\t");
    _builder.append(".getDefault().createModule();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected Injector getInjector() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _activatorName_2 = this.activatorName(projectName);
    _builder.append(_activatorName_2, "\t\t");
    _builder.append(".getDefault().getInjector();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence generateModule(final String projectName, final String superClass) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    _builder.append(projectName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import org.eclipse.ui.plugin.AbstractUIPlugin;");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _equals = Objects.equal(superClass, "EmfParsleyGuiceModule");
      if (_equals) {
        _builder.append("import org.eclipse.emf.parsley.EmfParsleyGuiceModule;");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("public class ");
    CharSequence _moduleName = this.moduleName(projectName);
    _builder.append(_moduleName, "");
    _builder.append(" extends ");
    _builder.append(superClass, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _moduleName_1 = this.moduleName(projectName);
    _builder.append(_moduleName_1, "\t");
    _builder.append("(AbstractUIPlugin plugin) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(plugin);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
