/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.ui.wizard;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.parsley.dsl.ui.wizard.EmfParsleyDslNewProjectFiles;
import org.eclipse.emf.parsley.dsl.ui.wizard.EmfParsleyDslProjectCreator;
import org.eclipse.emf.parsley.dsl.ui.wizard.template.TemplateWizardConfiguration;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGenerator;
import org.eclipse.emf.parsley.wizards.NewEmfParsleyProjectSupport;

public class EmfParsleyDslProjectCreatorCustom
extends EmfParsleyDslProjectCreator {
    static EmfParsleyDslNewProjectFiles filesGenerator = new EmfParsleyDslNewProjectFiles();
    static EmfParsleyProjectFilesGenerator projectFilesGenerator = new EmfParsleyProjectFilesGenerator();

    @Override
    protected List<String> getAllFolders() {
        return ImmutableList.of((Object)"src", (Object)"./emfparsley-gen");
    }

    @Override
    protected List<String> getRequiredBundles() {
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{"org.eclipse.core.runtime"});
        if (this.getProjectInfo().isRapOption()) {
            requiredBundles.addAll(Lists.newArrayList((Object[])new String[]{"org.eclipse.ui;resolution:=optional", "org.eclipse.rap.ui;resolution:=optional", "org.eclipse.emf.parsley.views;resolution:=optional", "org.eclipse.emf.parsley.rap.views;resolution:=optional"}));
        } else {
            requiredBundles.addAll(Lists.newArrayList((Object[])new String[]{"org.eclipse.ui", "org.eclipse.emf.parsley.views"}));
        }
        requiredBundles.add("org.eclipse.xtext.xbase.lib");
        return requiredBundles;
    }

    protected String getActivatorClassName() {
        return String.valueOf(this.getProjectInfo().getProjectName()) + "." + projectFilesGenerator.activatorName(this.getProjectInfo().getProjectName()).toString();
    }

    @Override
    protected void enhanceProject(IProject project, IProgressMonitor monitor) throws CoreException {
        String projectName = this.getProjectInfo().getProjectName();
        String srcFolder = "src";
        String projectPackagePath = String.valueOf(srcFolder) + "/" + projectName.replaceAll("\\.", "/");
        String[] paths = new String[]{projectPackagePath};
        NewEmfParsleyProjectSupport.addToProjectStructure((IProject)project, (String[])paths, (IProgressMonitor)monitor);
        NewEmfParsleyProjectSupport.createActivator((IProject)project, (String)projectName, (String)projectPackagePath, (IProgressMonitor)monitor);
        NewEmfParsleyProjectSupport.createExecutableExtensionFactory((IProject)project, (String)projectName, (String)projectPackagePath, (IProgressMonitor)monitor);
        NewEmfParsleyProjectSupport.createModule((IProject)project, (String)projectName, (String)projectPackagePath, (String)"EmfParsleyGuiceModuleGen", (IProgressMonitor)monitor);
        String dslFileContents = "";
        TemplateWizardConfiguration selectedTemplate = this.getProjectInfo().getSelectedTemplate();
        if (selectedTemplate != null) {
            String partClassName = selectedTemplate.getPartClassName(projectName);
            String partContents = selectedTemplate.getContentsForPart(projectName);
            NewEmfParsleyProjectSupport.createProjectFile((IProject)project, (String)(String.valueOf(projectPackagePath) + "/" + partClassName.concat(".java")), (String)partContents, (IProgressMonitor)NewEmfParsleyProjectSupport.createSubProgressMonitor((IProgressMonitor)monitor));
            dslFileContents = selectedTemplate.getParsleyModuleContents(projectName);
        } else {
            dslFileContents = filesGenerator.genEmptyDslModule(projectName).toString();
        }
        NewEmfParsleyProjectSupport.createProjectFile((IProject)project, (String)(String.valueOf(projectPackagePath) + "/module.parsley"), (String)dslFileContents, (IProgressMonitor)NewEmfParsleyProjectSupport.createSubProgressMonitor((IProgressMonitor)monitor));
        project.refreshLocal(2, monitor);
    }
}

