/**
 * Copyright (c) 2015 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.dsl.model.AbstractControlFactory;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureCaptionProviderWithLabel;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureProvider;
import org.eclipse.emf.parsley.dsl.model.Backgrounds;
import org.eclipse.emf.parsley.dsl.model.Binding;
import org.eclipse.emf.parsley.dsl.model.BindingsSpecification;
import org.eclipse.emf.parsley.dsl.model.Configurator;
import org.eclipse.emf.parsley.dsl.model.ConfiguratorEClass;
import org.eclipse.emf.parsley.dsl.model.ConfiguratorResourceURI;
import org.eclipse.emf.parsley.dsl.model.ContentProviderChildren;
import org.eclipse.emf.parsley.dsl.model.ContentProviderElements;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecification;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecifications;
import org.eclipse.emf.parsley.dsl.model.DialogControlFactory;
import org.eclipse.emf.parsley.dsl.model.DialogFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.EmfMenus;
import org.eclipse.emf.parsley.dsl.model.ExtendsClause;
import org.eclipse.emf.parsley.dsl.model.FeatureAssociatedExpression;
import org.eclipse.emf.parsley.dsl.model.FeatureBackgrounds;
import org.eclipse.emf.parsley.dsl.model.FeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.FeatureFonts;
import org.eclipse.emf.parsley.dsl.model.FeatureForegrounds;
import org.eclipse.emf.parsley.dsl.model.FeatureImages;
import org.eclipse.emf.parsley.dsl.model.FeatureLabels;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecification;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecifications;
import org.eclipse.emf.parsley.dsl.model.FeatureTexts;
import org.eclipse.emf.parsley.dsl.model.FeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.Fonts;
import org.eclipse.emf.parsley.dsl.model.Foregrounds;
import org.eclipse.emf.parsley.dsl.model.FormControlFactory;
import org.eclipse.emf.parsley.dsl.model.FormFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.Images;
import org.eclipse.emf.parsley.dsl.model.LabelProvider;
import org.eclipse.emf.parsley.dsl.model.MenuBuilder;
import org.eclipse.emf.parsley.dsl.model.Menus;
import org.eclipse.emf.parsley.dsl.model.Model;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.PolymorphicSpecification;
import org.eclipse.emf.parsley.dsl.model.ProposalCreator;
import org.eclipse.emf.parsley.dsl.model.ProviderBinding;
import org.eclipse.emf.parsley.dsl.model.ResourceManager;
import org.eclipse.emf.parsley.dsl.model.RowBackgrounds;
import org.eclipse.emf.parsley.dsl.model.RowFonts;
import org.eclipse.emf.parsley.dsl.model.RowForegrounds;
import org.eclipse.emf.parsley.dsl.model.SimpleMethodSpecification;
import org.eclipse.emf.parsley.dsl.model.TableFeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.TableLabelProvider;
import org.eclipse.emf.parsley.dsl.model.TableViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.Texts;
import org.eclipse.emf.parsley.dsl.model.TypeBinding;
import org.eclipse.emf.parsley.dsl.model.ValueBinding;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.emf.parsley.dsl.model.ViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.WithExpressions;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.model.WithFeatureAssociatedExpressions;
import org.eclipse.emf.parsley.dsl.model.WithFields;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.formatting2.XbaseWithAnnotationsFormatter;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xtype.XImportSection;

/**
 * @author Lorenzo Bettini
 */
@SuppressWarnings("all")
public class EmfParsleyDslFormatter extends XbaseWithAnnotationsFormatter {
  @Override
  public void format(final Object o, final IFormattableDocument document) {
    if ((o instanceof AbstractControlFactory)) {
      this._format(((AbstractControlFactory)o), document);
      return;
    } else {
      if ((o instanceof AbstractFeatureCaptionProviderWithLabel)) {
        this._format(((AbstractFeatureCaptionProviderWithLabel)o), document);
        return;
      } else {
        if ((o instanceof AbstractFeatureProvider)) {
          this._format(((AbstractFeatureProvider)o), document);
          return;
        } else {
          if ((o instanceof Configurator)) {
            this._format(((Configurator)o), document);
            return;
          } else {
            if ((o instanceof FeatureCaptionProvider)) {
              this._format(((FeatureCaptionProvider)o), document);
              return;
            } else {
              if ((o instanceof LabelProvider)) {
                this._format(((LabelProvider)o), document);
                return;
              } else {
                if ((o instanceof MenuBuilder)) {
                  this._format(((MenuBuilder)o), document);
                  return;
                } else {
                  if ((o instanceof ProposalCreator)) {
                    this._format(((ProposalCreator)o), document);
                    return;
                  } else {
                    if ((o instanceof ResourceManager)) {
                      this._format(((ResourceManager)o), document);
                      return;
                    } else {
                      if ((o instanceof TableLabelProvider)) {
                        this._format(((TableLabelProvider)o), document);
                        return;
                      } else {
                        if ((o instanceof TableViewerContentProvider)) {
                          this._format(((TableViewerContentProvider)o), document);
                          return;
                        } else {
                          if ((o instanceof ViewerContentProvider)) {
                            this._format(((ViewerContentProvider)o), document);
                            return;
                          } else {
                            if ((o instanceof ControlFactorySpecification)) {
                              this._format(((ControlFactorySpecification)o), document);
                              return;
                            } else {
                              if ((o instanceof FeatureAssociatedExpression)) {
                                this._format(((FeatureAssociatedExpression)o), document);
                                return;
                              } else {
                                if ((o instanceof FeatureSpecification)) {
                                  this._format(((FeatureSpecification)o), document);
                                  return;
                                } else {
                                  if ((o instanceof Module)) {
                                    this._format(((Module)o), document);
                                    return;
                                  } else {
                                    if ((o instanceof ProviderBinding)) {
                                      this._format(((ProviderBinding)o), document);
                                      return;
                                    } else {
                                      if ((o instanceof TypeBinding)) {
                                        this._format(((TypeBinding)o), document);
                                        return;
                                      } else {
                                        if ((o instanceof ValueBinding)) {
                                          this._format(((ValueBinding)o), document);
                                          return;
                                        } else {
                                          if ((o instanceof ViewSpecification)) {
                                            this._format(((ViewSpecification)o), document);
                                            return;
                                          } else {
                                            if ((o instanceof BindingsSpecification)) {
                                              this._format(((BindingsSpecification)o), document);
                                              return;
                                            } else {
                                              if ((o instanceof ExtendsClause)) {
                                                this._format(((ExtendsClause)o), document);
                                                return;
                                              } else {
                                                if ((o instanceof FieldSpecification)) {
                                                  this._format(((FieldSpecification)o), document);
                                                  return;
                                                } else {
                                                  if ((o instanceof PolymorphicSpecification)) {
                                                    this._format(((PolymorphicSpecification)o), document);
                                                    return;
                                                  } else {
                                                    if ((o instanceof Model)) {
                                                      this._format(((Model)o), document);
                                                      return;
                                                    } else {
                                                      if ((o instanceof PartsSpecifications)) {
                                                        this._format(((PartsSpecifications)o), document);
                                                        return;
                                                      } else {
                                                        if ((o instanceof SimpleMethodSpecification)) {
                                                          this._format(((SimpleMethodSpecification)o), document);
                                                          return;
                                                        } else {
                                                          super.format(o, document);
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  public void _format(final Model model, @Extension final IFormattableDocument document) {
    XImportSection _importSection = model.getImportSection();
    this.format(_importSection, document);
    Module _module = model.getModule();
    this.format(_module, document);
  }
  
  public void _format(final Module module, @Extension final IFormattableDocument document) {
    final Procedure1<Module> _function = new Procedure1<Module>() {
      @Override
      public void apply(final Module it) {
        ExtendsClause _extendsClause = module.getExtendsClause();
        EmfParsleyDslFormatter.this.format(_extendsClause, document);
        BindingsSpecification _bindingsSpecification = module.getBindingsSpecification();
        EmfParsleyDslFormatter.this.format(_bindingsSpecification, document);
        LabelProvider _labelProvider = module.getLabelProvider();
        EmfParsleyDslFormatter.this.format(_labelProvider, document);
        TableLabelProvider _tableLabelProvider = module.getTableLabelProvider();
        EmfParsleyDslFormatter.this.format(_tableLabelProvider, document);
        FeatureCaptionProvider _featureCaptionProvider = module.getFeatureCaptionProvider();
        EmfParsleyDslFormatter.this.format(_featureCaptionProvider, document);
        FormFeatureCaptionProvider _formFeatureCaptionProvider = module.getFormFeatureCaptionProvider();
        EmfParsleyDslFormatter.this.format(_formFeatureCaptionProvider, document);
        DialogFeatureCaptionProvider _dialogFeatureCaptionProvider = module.getDialogFeatureCaptionProvider();
        EmfParsleyDslFormatter.this.format(_dialogFeatureCaptionProvider, document);
        FeaturesProvider _featuresProvider = module.getFeaturesProvider();
        EmfParsleyDslFormatter.this.format(_featuresProvider, document);
        TableFeaturesProvider _tableFeaturesProvider = module.getTableFeaturesProvider();
        EmfParsleyDslFormatter.this.format(_tableFeaturesProvider, document);
        FormControlFactory _formControlFactory = module.getFormControlFactory();
        EmfParsleyDslFormatter.this.format(_formControlFactory, document);
        DialogControlFactory _dialogControlFactory = module.getDialogControlFactory();
        EmfParsleyDslFormatter.this.format(_dialogControlFactory, document);
        ProposalCreator _proposalCreator = module.getProposalCreator();
        EmfParsleyDslFormatter.this.format(_proposalCreator, document);
        MenuBuilder _menuBuilder = module.getMenuBuilder();
        EmfParsleyDslFormatter.this.format(_menuBuilder, document);
        Configurator _configurator = module.getConfigurator();
        EmfParsleyDslFormatter.this.format(_configurator, document);
        ViewerContentProvider _viewerContentProvider = module.getViewerContentProvider();
        EmfParsleyDslFormatter.this.format(_viewerContentProvider, document);
        TableViewerContentProvider _tableViewerContentProvider = module.getTableViewerContentProvider();
        EmfParsleyDslFormatter.this.format(_tableViewerContentProvider, document);
        PartsSpecifications _partsSpecifications = module.getPartsSpecifications();
        EmfParsleyDslFormatter.this.format(_partsSpecifications, document);
        ResourceManager _resourceManager = module.getResourceManager();
        EmfParsleyDslFormatter.this.format(_resourceManager, document);
      }
    };
    this.<Module>indentBlock(module, document, _function);
  }
  
  public void _format(final ExtendsClause extendsclause, @Extension final IFormattableDocument document) {
    JvmTypeReference _superType = extendsclause.getSuperType();
    this.format(_superType, document);
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(extendsclause);
    ISemanticRegion _keyword = _regionFor.keyword("extends");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword, _function);
  }
  
  public void _format(final BindingsSpecification bindingsspecification, @Extension final IFormattableDocument document) {
    final Procedure1<BindingsSpecification> _function = new Procedure1<BindingsSpecification>() {
      @Override
      public void apply(final BindingsSpecification it) {
        EList<Binding> _bindings = bindingsspecification.getBindings();
        EmfParsleyDslFormatter.this.<Binding>formatAndSeparateElementsWithNewlines(_bindings, document);
      }
    };
    this.<BindingsSpecification>indentBlock(bindingsspecification, document, _function);
  }
  
  public void _format(final TypeBinding typebinding, @Extension final IFormattableDocument document) {
    this.<TypeBinding>oneSpaceAfterKeyword(typebinding, "type", document);
    JvmTypeReference _typeToBind = typebinding.getTypeToBind();
    this.format(_typeToBind, document);
    this.formatBinding(typebinding, document);
  }
  
  public void _format(final ProviderBinding providerbinding, @Extension final IFormattableDocument document) {
    this.<ProviderBinding>oneSpaceAfterKeyword(providerbinding, "provide", document);
    JvmTypeReference _type = providerbinding.getType();
    this.format(_type, document);
    this.formatBinding(providerbinding, document);
  }
  
  public void _format(final ValueBinding valuebinding, @Extension final IFormattableDocument document) {
    this.<ValueBinding>oneSpaceAfterKeyword(valuebinding, "value", document);
    JvmTypeReference _typeDecl = valuebinding.getTypeDecl();
    this.format(_typeDecl, document);
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(valuebinding);
    ISemanticRegion _feature = _regionFor.feature(ModelPackage.Literals.VALUE_BINDING__ID);
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_feature, _function);
    this.formatBinding(valuebinding, document);
  }
  
  private void formatBinding(final Binding binding, @Extension final IFormattableDocument document) {
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(binding);
    ISemanticRegion _keyword = _regionFor.keyword("->");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword, _function);
    XExpression _to = binding.getTo();
    this.format(_to, document);
  }
  
  public void _format(final LabelProvider labelprovider, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        Texts _texts = labelprovider.getTexts();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_texts, document);
        Images _images = labelprovider.getImages();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_images, document);
        Fonts _fonts = labelprovider.getFonts();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_fonts, document);
        Foregrounds _foregrounds = labelprovider.getForegrounds();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_foregrounds, document);
        Backgrounds _backgrounds = labelprovider.getBackgrounds();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_backgrounds, document);
      }
    };
    this.formatWithFields(labelprovider, document, _function);
  }
  
  public void _format(final FieldSpecification expr, @Extension final IFormattableDocument document) {
    EList<XAnnotation> _annotations = expr.getAnnotations();
    for (final XAnnotation annotations : _annotations) {
      this.format(annotations, document);
    }
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(expr);
    ISemanticRegion _keyword = _regionFor.keyword("val");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.append(_keyword, _function);
    ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor(expr);
    ISemanticRegion _keyword_1 = _regionFor_1.keyword("var");
    final Procedure1<IHiddenRegionFormatter> _function_1 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.append(_keyword_1, _function_1);
    ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor(expr);
    ISemanticRegion _keyword_2 = _regionFor_2.keyword("extension");
    final Procedure1<IHiddenRegionFormatter> _function_2 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.append(_keyword_2, _function_2);
    JvmTypeReference _type = expr.getType();
    final Procedure1<IHiddenRegionFormatter> _function_3 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.<JvmTypeReference>append(_type, _function_3);
    ISemanticRegionsFinder _regionFor_3 = this.textRegionExtensions.regionFor(expr);
    ISemanticRegion _keyword_3 = _regionFor_3.keyword("=");
    final Procedure1<IHiddenRegionFormatter> _function_4 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword_3, _function_4);
    JvmTypeReference _type_1 = expr.getType();
    this.format(_type_1, document);
    XExpression _right = expr.getRight();
    this.format(_right, document);
    ISemanticRegionsFinder _regionFor_4 = this.textRegionExtensions.regionFor(expr);
    ISemanticRegion _keyword_4 = _regionFor_4.keyword(";");
    final Procedure1<IHiddenRegionFormatter> _function_5 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.noSpace();
      }
    };
    document.prepend(_keyword_4, _function_5);
  }
  
  public void _format(final TableLabelProvider tablelabelprovider, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        FeatureTexts _featureTexts = tablelabelprovider.getFeatureTexts();
        EmfParsleyDslFormatter.this.<EObject>formatFeatureSpecifications(_featureTexts, document);
        FeatureImages _featureImages = tablelabelprovider.getFeatureImages();
        EmfParsleyDslFormatter.this.<EObject>formatFeatureSpecifications(_featureImages, document);
        FeatureFonts _featureFonts = tablelabelprovider.getFeatureFonts();
        EmfParsleyDslFormatter.this.<EObject>formatFeatureSpecifications(_featureFonts, document);
        FeatureForegrounds _featureForegrounds = tablelabelprovider.getFeatureForegrounds();
        EmfParsleyDslFormatter.this.<EObject>formatFeatureSpecifications(_featureForegrounds, document);
        FeatureBackgrounds _featureBackgrounds = tablelabelprovider.getFeatureBackgrounds();
        EmfParsleyDslFormatter.this.<EObject>formatFeatureSpecifications(_featureBackgrounds, document);
        RowFonts _rowFonts = tablelabelprovider.getRowFonts();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_rowFonts, document);
        RowForegrounds _rowForegrounds = tablelabelprovider.getRowForegrounds();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_rowForegrounds, document);
        RowBackgrounds _rowBackgrounds = tablelabelprovider.getRowBackgrounds();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_rowBackgrounds, document);
      }
    };
    this.formatWithFields(tablelabelprovider, document, _function);
  }
  
  public void _format(final PolymorphicSpecification specification, @Extension final IFormattableDocument document) {
    JvmTypeReference _parameterType = specification.getParameterType();
    this.format(_parameterType, document);
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(specification);
    ISemanticRegion _keyword = _regionFor.keyword("->");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword, _function);
    XExpression _expression = specification.getExpression();
    this.format(_expression, document);
  }
  
  public void _format(final FeatureCaptionProvider featurecaptionprovider, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        FeatureTexts _featureTexts = featurecaptionprovider.getFeatureTexts();
        final Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>() {
          @Override
          public List<? extends EObject> get() {
            FeatureTexts _featureTexts = featurecaptionprovider.getFeatureTexts();
            return _featureTexts.getSpecifications();
          }
        };
        EmfParsleyDslFormatter.this.<EObject>indentBlockAndFormatAndSeparateElementsWithNewlines(_featureTexts, document, _function);
      }
    };
    this.formatWithFields(featurecaptionprovider, document, _function);
  }
  
  public void _format(final AbstractFeatureCaptionProviderWithLabel featurecaptionprovider, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        FeatureTexts _featureTexts = featurecaptionprovider.getFeatureTexts();
        EmfParsleyDslFormatter.this.<EObject>formatFeatureSpecifications(_featureTexts, document);
        FeatureLabels _featureLabels = featurecaptionprovider.getFeatureLabels();
        EmfParsleyDslFormatter.this.<EObject>formatFeatureSpecifications(_featureLabels, document);
      }
    };
    this.formatWithFields(featurecaptionprovider, document, _function);
  }
  
  public void _format(final FeatureAssociatedExpression featureassociatedexpression, @Extension final IFormattableDocument document) {
    JvmTypeReference _parameterType = featureassociatedexpression.getParameterType();
    this.format(_parameterType, document);
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(featureassociatedexpression);
    ISemanticRegion _keyword = _regionFor.keyword(":");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword, _function);
    ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor(featureassociatedexpression);
    ISemanticRegion _keyword_1 = _regionFor_1.keyword("->");
    final Procedure1<IHiddenRegionFormatter> _function_1 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword_1, _function_1);
    XExpression _expression = featureassociatedexpression.getExpression();
    this.format(_expression, document);
  }
  
  public void _format(final AbstractFeatureProvider featuresprovider, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        FeatureSpecifications _features = featuresprovider.getFeatures();
        final Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>() {
          @Override
          public List<? extends EObject> get() {
            FeatureSpecifications _features = featuresprovider.getFeatures();
            return _features.getFeatureSpecifications();
          }
        };
        EmfParsleyDslFormatter.this.<EObject>indentBlockAndFormatAndSeparateElementsWithNewlines(_features, document, _function);
      }
    };
    this.formatWithFields(featuresprovider, document, _function);
  }
  
  public void _format(final FeatureSpecification featurespecification, @Extension final IFormattableDocument document) {
    JvmTypeReference _parameterType = featurespecification.getParameterType();
    this.format(_parameterType, document);
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(featurespecification);
    ISemanticRegion _keyword = _regionFor.keyword("->");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword, _function);
    ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor(featurespecification);
    List<ISemanticRegion> _keywords = _regionFor_1.keywords(",");
    for (final ISemanticRegion comma : _keywords) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = new Procedure1<IHiddenRegionFormatter>() {
        @Override
        public void apply(final IHiddenRegionFormatter it) {
          it.noSpace();
        }
      };
      ISemanticRegion _prepend = document.prepend(comma, _function_1);
      final Procedure1<IHiddenRegionFormatter> _function_2 = new Procedure1<IHiddenRegionFormatter>() {
        @Override
        public void apply(final IHiddenRegionFormatter it) {
          it.oneSpace();
        }
      };
      document.append(_prepend, _function_2);
    }
  }
  
  public void _format(final AbstractControlFactory controlfactory, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        ControlFactorySpecifications _controls = controlfactory.getControls();
        final Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>() {
          @Override
          public List<? extends EObject> get() {
            ControlFactorySpecifications _controls = controlfactory.getControls();
            return _controls.getSpecifications();
          }
        };
        EmfParsleyDslFormatter.this.<EObject>indentBlockAndFormatAndSeparateElementsWithNewlines(_controls, document, _function);
      }
    };
    this.formatWithFields(controlfactory, document, _function);
  }
  
  public void _format(final ControlFactorySpecification controlfactoryspecification, @Extension final IFormattableDocument document) {
    JvmTypeReference _parameterType = controlfactoryspecification.getParameterType();
    this.format(_parameterType, document);
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(controlfactoryspecification);
    ISemanticRegion _keyword = _regionFor.keyword(":");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword, _function);
    ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor(controlfactoryspecification);
    ISemanticRegion _keyword_1 = _regionFor_1.keyword("->");
    final Procedure1<IHiddenRegionFormatter> _function_1 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword_1, _function_1);
    XExpression _expression = controlfactoryspecification.getExpression();
    this.format(_expression, document);
    ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor(controlfactoryspecification);
    ISemanticRegion _keyword_2 = _regionFor_2.keyword("target");
    final Procedure1<IHiddenRegionFormatter> _function_2 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    document.surround(_keyword_2, _function_2);
    XExpression _target = controlfactoryspecification.getTarget();
    this.format(_target, document);
  }
  
  public void _format(final ProposalCreator proposalcreator, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        EList<FeatureAssociatedExpression> _proposalsSpecifications = proposalcreator.getProposalsSpecifications();
        EmfParsleyDslFormatter.this.<FeatureAssociatedExpression>formatAndSeparateElementsWithNewlines(_proposalsSpecifications, document);
      }
    };
    this.formatWithFields(proposalcreator, document, _function);
  }
  
  public void _format(final MenuBuilder menubuilder, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        Menus _menus = menubuilder.getMenus();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_menus, document);
        EmfMenus _emfMenus = menubuilder.getEmfMenus();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_emfMenus, document);
      }
    };
    this.formatWithFields(menubuilder, document, _function);
  }
  
  public void _format(final Configurator configurator, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        ConfiguratorResourceURI _resourceURI = configurator.getResourceURI();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_resourceURI, document);
        ConfiguratorEClass _eClassSpec = configurator.getEClassSpec();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_eClassSpec, document);
      }
    };
    this.formatWithFields(configurator, document, _function);
  }
  
  public void _format(final ViewerContentProvider viewercontentprovider, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        ContentProviderElements _elements = viewercontentprovider.getElements();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_elements, document);
        ContentProviderChildren _children = viewercontentprovider.getChildren();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_children, document);
      }
    };
    this.formatWithFields(viewercontentprovider, document, _function);
  }
  
  public void _format(final TableViewerContentProvider tableviewercontentprovider, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        ContentProviderElements _elements = tableviewercontentprovider.getElements();
        EmfParsleyDslFormatter.this.<EObject>formatSpecifications(_elements, document);
      }
    };
    this.formatWithFields(tableviewercontentprovider, document, _function);
  }
  
  public void _format(final ResourceManager resourcemanager, @Extension final IFormattableDocument document) {
    final Procedure1<WithFields> _function = new Procedure1<WithFields>() {
      @Override
      public void apply(final WithFields it) {
        SimpleMethodSpecification _initializeBody = resourcemanager.getInitializeBody();
        EmfParsleyDslFormatter.this.format(_initializeBody, document);
        SimpleMethodSpecification _saveBody = resourcemanager.getSaveBody();
        EmfParsleyDslFormatter.this.format(_saveBody, document);
      }
    };
    this.formatWithFields(resourcemanager, document, _function);
  }
  
  public void _format(final SimpleMethodSpecification simplemethodspecification, @Extension final IFormattableDocument document) {
    XExpression _body = simplemethodspecification.getBody();
    this.<XExpression>formatAndSeparateWithNewlines(_body, document);
  }
  
  public void _format(final PartsSpecifications partsspecifications, @Extension final IFormattableDocument document) {
    final Procedure1<PartsSpecifications> _function = new Procedure1<PartsSpecifications>() {
      @Override
      public void apply(final PartsSpecifications it) {
        EList<PartSpecification> _parts = partsspecifications.getParts();
        EmfParsleyDslFormatter.this.<PartSpecification>formatAndSeparateElementsWithNewlines(_parts, document);
      }
    };
    this.<PartsSpecifications>indentBlock(partsspecifications, document, _function);
  }
  
  public void _format(final ViewSpecification viewspecification, @Extension final IFormattableDocument document) {
    final Procedure1<ViewSpecification> _function = new Procedure1<ViewSpecification>() {
      @Override
      public void apply(final ViewSpecification it) {
        ISemanticRegionsFinder _regionFor = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor(viewspecification);
        ISemanticRegion _keyword = _regionFor.keyword("viewpart");
        final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
          @Override
          public void apply(final IHiddenRegionFormatter it) {
            it.oneSpace();
          }
        };
        document.append(_keyword, _function);
        ISemanticRegionsFinder _regionFor_1 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor(viewspecification);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("viewname");
        final Procedure1<IHiddenRegionFormatter> _function_1 = new Procedure1<IHiddenRegionFormatter>() {
          @Override
          public void apply(final IHiddenRegionFormatter it) {
            it.oneSpace();
          }
        };
        document.append(_keyword_1, _function_1);
        ISemanticRegionsFinder _regionFor_2 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor(viewspecification);
        ISemanticRegion _feature = _regionFor_2.feature(ModelPackage.Literals.VIEW_SPECIFICATION__VIEW_NAME);
        final Procedure1<IHiddenRegionFormatter> _function_2 = new Procedure1<IHiddenRegionFormatter>() {
          @Override
          public void apply(final IHiddenRegionFormatter it) {
            it.setNewLines(1, 1, 2);
          }
        };
        document.append(_feature, _function_2);
        ISemanticRegionsFinder _regionFor_3 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor(viewspecification);
        ISemanticRegion _keyword_2 = _regionFor_3.keyword("viewclass");
        final Procedure1<IHiddenRegionFormatter> _function_3 = new Procedure1<IHiddenRegionFormatter>() {
          @Override
          public void apply(final IHiddenRegionFormatter it) {
            it.oneSpace();
          }
        };
        document.append(_keyword_2, _function_3);
        JvmTypeReference _type = viewspecification.getType();
        EmfParsleyDslFormatter.this.format(_type, document);
        JvmTypeReference _type_1 = viewspecification.getType();
        final Procedure1<IHiddenRegionFormatter> _function_4 = new Procedure1<IHiddenRegionFormatter>() {
          @Override
          public void apply(final IHiddenRegionFormatter it) {
            it.setNewLines(1, 1, 2);
          }
        };
        document.<JvmTypeReference>append(_type_1, _function_4);
        String _category = viewspecification.getCategory();
        boolean _notEquals = (!Objects.equal(_category, null));
        if (_notEquals) {
          ISemanticRegionsFinder _regionFor_4 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor(viewspecification);
          ISemanticRegion _keyword_3 = _regionFor_4.keyword("viewcategory");
          final Procedure1<IHiddenRegionFormatter> _function_5 = new Procedure1<IHiddenRegionFormatter>() {
            @Override
            public void apply(final IHiddenRegionFormatter it) {
              it.oneSpace();
            }
          };
          document.append(_keyword_3, _function_5);
          ISemanticRegionsFinder _regionFor_5 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor(viewspecification);
          ISemanticRegion _feature_1 = _regionFor_5.feature(ModelPackage.Literals.VIEW_SPECIFICATION__CATEGORY);
          final Procedure1<IHiddenRegionFormatter> _function_6 = new Procedure1<IHiddenRegionFormatter>() {
            @Override
            public void apply(final IHiddenRegionFormatter it) {
              it.setNewLines(1, 1, 2);
            }
          };
          document.append(_feature_1, _function_6);
        }
      }
    };
    this.<ViewSpecification>indentBlock(viewspecification, document, _function);
  }
  
  private WithExtendsClause formatWithFields(final WithFields e, @Extension final IFormattableDocument document, final Procedure1<? super WithFields> elementsFormatter) {
    final Procedure1<WithExtendsClause> _function = new Procedure1<WithExtendsClause>() {
      @Override
      public void apply(final WithExtendsClause it) {
        EmfParsleyDslFormatter.this.formatFields(e, document);
        elementsFormatter.apply(e);
      }
    };
    return this.formatWithExtendsClause(e, document, _function);
  }
  
  private WithExtendsClause formatWithExtendsClause(final WithExtendsClause e, @Extension final IFormattableDocument document, final Procedure1<? super WithExtendsClause> elementsFormatter) {
    WithExtendsClause _xblockexpression = null;
    {
      ExtendsClause _extendsClause = e.getExtendsClause();
      this.format(_extendsClause, document);
      final Procedure1<WithExtendsClause> _function = new Procedure1<WithExtendsClause>() {
        @Override
        public void apply(final WithExtendsClause it) {
          elementsFormatter.apply(e);
        }
      };
      this.<WithExtendsClause>indentBlock(e, document, _function);
      _xblockexpression = this.<WithExtendsClause>separateElementsWithNewlines(e, document);
    }
    return _xblockexpression;
  }
  
  private void formatFields(final WithFields withFields, @Extension final IFormattableDocument document) {
    EList<FieldSpecification> _fields = withFields.getFields();
    this.<FieldSpecification>formatAndSeparateElementsWithNewlines(_fields, document);
  }
  
  private <T extends EObject> EObject formatSpecifications(final WithExpressions e, @Extension final IFormattableDocument document) {
    final Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>() {
      @Override
      public List<? extends EObject> get() {
        return e.getSpecifications();
      }
    };
    return this.<EObject>indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
  }
  
  private <T extends EObject> EObject formatFeatureSpecifications(final WithFeatureAssociatedExpressions e, @Extension final IFormattableDocument document) {
    final Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>() {
      @Override
      public List<? extends EObject> get() {
        return e.getSpecifications();
      }
    };
    return this.<EObject>indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
  }
  
  /**
   * The elementsProvider is invoked only if the passed parent is not null
   */
  private <T extends EObject> EObject indentBlockAndFormatAndSeparateElementsWithNewlines(final EObject parent, @Extension final IFormattableDocument document, final Provider<List<? extends T>> elementsProvider) {
    EObject _xifexpression = null;
    boolean _notEquals = (!Objects.equal(parent, null));
    if (_notEquals) {
      EObject _xblockexpression = null;
      {
        final List<? extends T> list = elementsProvider.get();
        final Procedure1<EObject> _function = new Procedure1<EObject>() {
          @Override
          public void apply(final EObject it) {
            EmfParsleyDslFormatter.this.<T>formatAndSeparateElementsWithNewlines(list, document);
          }
        };
        this.<EObject>indentBlock(parent, document, _function);
        _xblockexpression = this.<EObject>separateElementsWithNewlines(parent, document);
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private <T extends EObject> void formatAndSeparateElementsWithNewlines(final List<? extends T> elements, @Extension final IFormattableDocument document) {
    for (final T e : elements) {
      this.<T>formatAndSeparateWithNewlines(e, document);
    }
  }
  
  private <T extends EObject> T formatAndSeparateWithNewlines(final T e, final IFormattableDocument document) {
    T _xblockexpression = null;
    {
      this.format(e, document);
      _xblockexpression = this.<T>separateElementsWithNewlines(e, document);
    }
    return _xblockexpression;
  }
  
  private <T extends EObject> ISemanticRegion oneSpaceAfterKeyword(final T element, final String k, @Extension final IFormattableDocument document) {
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(element);
    ISemanticRegion _keyword = _regionFor.keyword(k);
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.oneSpace();
      }
    };
    return document.append(_keyword, _function);
  }
  
  private <T extends EObject> T separateElementsWithNewlines(final T element, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.setNewLines(1, 1, 2);
      }
    };
    return document.<T>append(element, _function);
  }
  
  private <T extends EObject> void indentBlock(final T element, @Extension final IFormattableDocument document, final Procedure1<? super T> elementsFormatter) {
    ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(element);
    final ISemanticRegion open = _regionFor.keyword("{");
    ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor(element);
    final ISemanticRegion close = _regionFor_1.keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.newLine();
      }
    };
    document.append(open, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = new Procedure1<IHiddenRegionFormatter>() {
      @Override
      public void apply(final IHiddenRegionFormatter it) {
        it.indent();
      }
    };
    document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_1);
    elementsFormatter.apply(element);
  }
}
