/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.scoping;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.beans.Introspector;
import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.parsley.dsl.model.EmfFeatureAccess;
import org.eclipse.emf.parsley.dsl.util.EmfParsleyDslModelUtil;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xbase.annotations.typesystem.XbaseWithAnnotationsBatchScopeProvider;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class EmfParsleyDslXbaseBatchScopeProvider extends XbaseWithAnnotationsBatchScopeProvider {
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    IScope _xblockexpression = null;
    {
      final IScope scope = this.createCustomScope(context, reference);
      boolean _notEquals = (!Objects.equal(scope, null));
      if (_notEquals) {
        return scope;
      }
      _xblockexpression = super.getScope(context, reference);
    }
    return _xblockexpression;
  }
  
  public IScope createCustomScope(final EObject context, final EReference reference) {
    EClassifier _eType = reference.getEType();
    EClass _jvmMember = TypesPackage.eINSTANCE.getJvmMember();
    boolean _equals = Objects.equal(_eType, _jvmMember);
    if (_equals) {
      EmfFeatureAccess _containingEmfFeatureAccess = EmfParsleyDslModelUtil.containingEmfFeatureAccess(context);
      JvmTypeReference _parameterType = null;
      if (_containingEmfFeatureAccess!=null) {
        _parameterType=_containingEmfFeatureAccess.getParameterType();
      }
      JvmType _type = null;
      if (_parameterType!=null) {
        _type=_parameterType.getType();
      }
      IScope _customScope = null;
      if (_type!=null) {
        _customScope=this.customScope(_type);
      }
      return _customScope;
    }
    return null;
  }
  
  protected IScope _customScope(final JvmType t) {
    return null;
  }
  
  protected IScope _customScope(final JvmGenericType t) {
    Iterable<JvmFeature> _allFeatures = t.getAllFeatures();
    Iterable<JvmOperation> _filter = Iterables.<JvmOperation>filter(_allFeatures, JvmOperation.class);
    final Function1<JvmOperation, Boolean> _function = new Function1<JvmOperation, Boolean>() {
      @Override
      public Boolean apply(final JvmOperation it) {
        boolean _isStatic = it.isStatic();
        return Boolean.valueOf((!_isStatic));
      }
    };
    Iterable<JvmOperation> _filter_1 = IterableExtensions.<JvmOperation>filter(_filter, _function);
    final Function<JvmOperation, QualifiedName> _function_1 = new Function<JvmOperation, QualifiedName>() {
      @Override
      public QualifiedName apply(final JvmOperation it) {
        QualifiedName _xifexpression = null;
        String _simpleName = it.getSimpleName();
        boolean _isGetterMethod = EmfParsleyDslXbaseBatchScopeProvider.this.isGetterMethod(_simpleName);
        if (_isGetterMethod) {
          String _simpleName_1 = it.getSimpleName();
          String _propertyNameForGetterMethod = EmfParsleyDslXbaseBatchScopeProvider.this.getPropertyNameForGetterMethod(_simpleName_1);
          _xifexpression = QualifiedName.create(_propertyNameForGetterMethod);
        } else {
          _xifexpression = null;
        }
        return _xifexpression;
      }
    };
    Iterable<IEObjectDescription> _scopedElementsFor = Scopes.<JvmOperation>scopedElementsFor(_filter_1, _function_1);
    return new SimpleScope(_scopedElementsFor);
  }
  
  public boolean isGetterMethod(final String opName) {
    boolean _or = false;
    boolean _terMethodForNonBoolean = this.getterMethodForNonBoolean(opName);
    if (_terMethodForNonBoolean) {
      _or = true;
    } else {
      boolean _terMethodForBoolean = this.getterMethodForBoolean(opName);
      _or = _terMethodForBoolean;
    }
    return _or;
  }
  
  public String getPropertyNameForGetterMethod(final String opName) {
    boolean _terMethodForNonBoolean = this.getterMethodForNonBoolean(opName);
    if (_terMethodForNonBoolean) {
      String _substring = opName.substring(3);
      return Introspector.decapitalize(_substring);
    }
    boolean _terMethodForBoolean = this.getterMethodForBoolean(opName);
    if (_terMethodForBoolean) {
      String _substring_1 = opName.substring(2);
      return Introspector.decapitalize(_substring_1);
    }
    return null;
  }
  
  private boolean getterMethodForBoolean(final String opName) {
    return this.getterMethodInternal(opName, "is");
  }
  
  private boolean getterMethodForNonBoolean(final String opName) {
    return this.getterMethodInternal(opName, "get");
  }
  
  private boolean getterMethodInternal(final String opName, final String prefix) {
    boolean _and = false;
    boolean _and_1 = false;
    boolean _startsWith = opName.startsWith(prefix);
    if (!_startsWith) {
      _and_1 = false;
    } else {
      int _length = opName.length();
      int _length_1 = prefix.length();
      boolean _greaterThan = (_length > _length_1);
      _and_1 = _greaterThan;
    }
    if (!_and_1) {
      _and = false;
    } else {
      int _length_2 = prefix.length();
      char _charAt = opName.charAt(_length_2);
      boolean _isUpperCase = Character.isUpperCase(_charAt);
      _and = _isUpperCase;
    }
    return _and;
  }
  
  public IScope customScope(final JvmType t) {
    if (t instanceof JvmGenericType) {
      return _customScope((JvmGenericType)t);
    } else if (t != null) {
      return _customScope(t);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t).toString());
    }
  }
}
