/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.composite;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.EmfParsleyActivator;
import org.eclipse.emf.parsley.composite.ControlObservablePair;
import org.eclipse.emf.parsley.composite.EObjectTextObservable;
import org.eclipse.emf.parsley.composite.MultipleFeatureControl;
import org.eclipse.emf.parsley.composite.MultipleFeatureControlObservable;
import org.eclipse.emf.parsley.composite.ProposalCreator;
import org.eclipse.emf.parsley.edit.TextUndoRedo;
import org.eclipse.emf.parsley.runtime.util.PolymorphicDispatcherExtensions;
import org.eclipse.emf.parsley.ui.provider.FeatureLabelCaptionProvider;
import org.eclipse.emf.parsley.util.DatabindingUtil;
import org.eclipse.emf.parsley.util.FeatureHelper;
import org.eclipse.emf.parsley.widgets.IWidgetFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractControlFactory
implements IWidgetFactory {
    private static final String OBSERVE_PREFIX = "observe_";
    private static final String CONTROL_PREFIX = "control_";
    @Inject
    @Named(value="ContentAssistShortcut")
    private String contentAssistShortcut;
    @Inject
    private Provider<ILabelProvider> labelProviderProvider;
    @Inject
    private FeatureHelper featureHelper;
    @Inject
    private ProposalCreator proposalCreator;
    protected EObject owner;
    protected Resource resource;
    protected EditingDomain domain;
    protected EMFDataBindingContext edbc;
    protected IWidgetFactory widgetFactory;
    protected FeatureLabelCaptionProvider featureLabelCaptionProvider;
    protected boolean readonly = false;
    public static final String EOBJECT_KEY = EcorePackage.Literals.EOBJECT.getName();
    public static final String ESTRUCTURALFEATURE_KEY = EcorePackage.Literals.ESTRUCTURAL_FEATURE.getName();

    protected abstract IWidgetFactory createWidgetFactory();

    protected abstract FeatureLabelCaptionProvider createFeatureLabelCaptionProvider();

    public Provider<ILabelProvider> getLabelProviderProvider() {
        return this.labelProviderProvider;
    }

    protected ILabelProvider createLabelProvider() {
        return (ILabelProvider)this.getLabelProviderProvider().get();
    }

    public ProposalCreator getProposalCreator() {
        return this.proposalCreator;
    }

    public void setProposalCreator(ProposalCreator proposalCreator) {
        this.proposalCreator = proposalCreator;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void init(EditingDomain domain, EObject owner, Composite parent) {
        this.widgetFactory = this.createWidgetFactory();
        this.init(parent);
        this.featureLabelCaptionProvider = this.createFeatureLabelCaptionProvider();
        this.edbc = new EMFDataBindingContext();
        this.domain = domain;
        this.owner = owner;
    }

    protected Resource getResource() {
        if (this.resource == null) {
            this.resource = this.owner.eResource();
        }
        return this.resource;
    }

    public void createEditingField(EStructuralFeature feature) {
        this.featureLabelCaptionProvider.getLabel(this.getParent(), this.owner, feature);
        this.create(feature);
    }

    public Control create(EStructuralFeature feature) {
        Control control = null;
        control = this.polymorphicCreateControl(feature);
        if (control == null) {
            control = feature.isMany() ? this.createAndBindList(feature) : this.createAndBindValue(feature);
            this.setupControl(feature, control);
        }
        this.registerUndoRedo(control);
        return control;
    }

    protected KeyListener registerUndoRedo(Control control) {
        if (control instanceof Text) {
            return new TextUndoRedo((Text)control);
        }
        return null;
    }

    protected Control createAndBindList(EStructuralFeature feature) {
        IObservableValue source = this.createFeatureObserveable(feature);
        ControlObservablePair retValAndTargetPair = this.createControlForList(feature);
        Control retVal = retValAndTargetPair.getControl();
        IObservableValue target = retValAndTargetPair.getObservableValue();
        Binding binding = this.edbc.bindValue(target, source);
        binding.updateModelToTarget();
        return retVal;
    }

    protected IObservableValue createFeatureObserveable(EStructuralFeature feature) {
        IObservableValue source = this.polymorphicCreateObserveable(this.domain, feature);
        if (source == null) {
            source = this.domain != null ? EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)feature).observe((Object)this.owner) : EMFProperties.value((EStructuralFeature)feature).observe((Object)this.owner);
        }
        return source;
    }

    protected ControlObservablePair createControlForList(EStructuralFeature feature) {
        ControlObservablePair result = this.polymorphicGetObservableControl(feature);
        if (result != null) {
            return result;
        }
        MultipleFeatureControl mfc = new MultipleFeatureControl(this.getParent(), this, (ILabelProvider)this.labelProviderProvider.get(), this.owner, feature, this.getProposalCreator(), this.isReadonly());
        MultipleFeatureControlObservable target = new MultipleFeatureControlObservable(mfc);
        return new ControlObservablePair((Control)mfc, (IObservableValue)target);
    }

    Control createAndBindValue(EStructuralFeature feature) {
        IObservableValue featureObservable = this.createFeatureObserveable(feature);
        Control control = this.polymorphicCreateControl(feature, featureObservable);
        if (control != null) {
            return control;
        }
        ControlObservablePair retValAndTargetPair = this.createControlAndObservableValue(feature);
        Control retVal = retValAndTargetPair.getControl();
        IObservableValue controlObservable = retValAndTargetPair.getObservableValue();
        if (controlObservable != null) {
            this.edbc.bindValue(controlObservable, featureObservable, null, null);
        }
        return retVal;
    }

    protected ControlObservablePair createControlAndObservableValue(EStructuralFeature feature) {
        ControlObservablePair result = this.polymorphicGetObservableControl(feature);
        if (result != null) {
            return result;
        }
        if (this.featureHelper.isBooleanFeature(feature)) {
            return this.createControlAndObservableValueForBoolean();
        }
        return this.createControlAndObservableValueForNonBooleanFeature(feature);
    }

    protected ControlObservablePair createControlAndObservableValueForBoolean() {
        ControlObservablePair retValAndTargetPair = new ControlObservablePair();
        Button b = this.createButton("", 32);
        b.setEnabled(!this.isReadonly());
        retValAndTargetPair.setControl((Control)b);
        retValAndTargetPair.setObservableValue((IObservableValue)DatabindingUtil.observeSelection((Widget)b));
        return retValAndTargetPair;
    }

    protected ControlObservablePair createControlAndObservableValueForNonBooleanFeature(EStructuralFeature feature) {
        List<Object> proposals = null;
        if (!this.isReadonly()) {
            proposals = this.createProposals(feature);
        }
        if (this.featureHelper.hasPredefinedProposals(feature) && !this.isReadonly()) {
            return this.createControlAndObservableWithPredefinedProposals(proposals);
        }
        if (this.isReadonly() && feature instanceof EReference) {
            return this.createControlAndObservableForEObjectReadOnly();
        }
        return this.createControlAndObservableWithoutPredefinedProposals(proposals);
    }

    public List<Object> createProposals(EStructuralFeature feature) {
        this.getProposalCreator().setResource(this.getResource());
        return this.getProposalCreator().proposals(this.owner, feature);
    }

    protected ControlObservablePair createControlAndObservableWithPredefinedProposals(List<?> proposals) {
        ComboViewer combo = this.createComboViewer(8);
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        combo.setInput(proposals);
        ControlObservablePair retValAndTargetPair = new ControlObservablePair();
        retValAndTargetPair.setControl((Control)combo.getCombo());
        retValAndTargetPair.setObservableValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)combo));
        return retValAndTargetPair;
    }

    protected ControlObservablePair createControlAndObservableWithoutPredefinedProposals(List<?> proposals) {
        ControlObservablePair retValAndTargetPair = new ControlObservablePair();
        Text t = this.createText("");
        t.setEditable(!this.isReadonly());
        this.addContentProposalAdapter(t, proposals);
        retValAndTargetPair.setControl((Control)t);
        retValAndTargetPair.setObservableValue((IObservableValue)DatabindingUtil.observeText((Control)t, 24));
        return retValAndTargetPair;
    }

    protected ControlObservablePair createControlAndObservableForEObjectReadOnly() {
        ControlObservablePair retValAndTargetPair = new ControlObservablePair();
        Text t = this.createText("");
        t.setEditable(false);
        retValAndTargetPair.setControl((Control)t);
        retValAndTargetPair.setObservableValue((IObservableValue)new EObjectTextObservable(this.createLabelProvider(), t));
        return retValAndTargetPair;
    }

    protected ContentProposalAdapter addContentProposalAdapter(Text t, List<?> proposals) {
        if (proposals != null && !proposals.isEmpty()) {
            Iterable filteredNotNullToString = Iterables.transform((Iterable)Iterables.filter(proposals, (Predicate)Predicates.notNull()), (Function)new Function<Object, String>(){

                public String apply(Object input) {
                    return input.toString();
                }
            });
            ControlDecoration field = new ControlDecoration((Control)t, 2048);
            FieldDecoration requiredFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            field.setImage(requiredFieldIndicator.getImage());
            field.setDescriptionText(requiredFieldIndicator.getDescription());
            KeyStroke keyStroke = null;
            try {
                keyStroke = KeyStroke.getInstance((String)this.contentAssistShortcut);
            }
            catch (ParseException e) {
                EmfParsleyActivator.logError("Error while parsing keystroke: " + this.contentAssistShortcut, e);
            }
            return new ContentProposalAdapter((Control)t, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider((String[])Iterables.toArray((Iterable)filteredNotNullToString, String.class)), keyStroke, null);
        }
        return null;
    }

    private void setupControl(EStructuralFeature f, Control c) {
        if (c != null) {
            if (c.isEnabled()) {
                c.setEnabled(this.featureHelper.isEditable(f));
            }
            c.setData(ESTRUCTURALFEATURE_KEY, (Object)f);
            c.setData(EOBJECT_KEY, (Object)this.owner);
            if (c.getLayoutData() == null) {
                c.setLayoutData((Object)new GridData(768));
            }
        }
    }

    public void dispose() {
        this.edbc.dispose();
    }

    private ControlObservablePair polymorphicGetObservableControl(EStructuralFeature feature) {
        return (ControlObservablePair)PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeature((Object)this, (EClass)this.owner.eClass(), (EStructuralFeature)feature, (String)CONTROL_PREFIX, (Object[])new Object[]{feature});
    }

    private Control polymorphicCreateControl(EStructuralFeature feature, IObservableValue featureObservable) {
        return (Control)PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeature((Object)this, (EClass)this.owner.eClass(), (EStructuralFeature)feature, (String)CONTROL_PREFIX, (Object[])new Object[]{this.edbc, featureObservable});
    }

    private Control polymorphicCreateControl(EStructuralFeature feature) {
        return (Control)PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeature((Object)this, (EClass)this.owner.eClass(), (EStructuralFeature)feature, (String)CONTROL_PREFIX, (Object[])new Object[]{this.owner});
    }

    private IObservableValue polymorphicCreateObserveable(EditingDomain domain, EStructuralFeature feature) {
        return (IObservableValue)PolymorphicDispatcherExtensions.polymorphicInvokeBasedOnFeature((Object)this, (EClass)this.owner.eClass(), (EStructuralFeature)feature, (String)OBSERVE_PREFIX, (Object[])new Object[]{domain, this.owner});
    }

    @Override
    public Label createLabel(String text) {
        return this.widgetFactory.createLabel(text);
    }

    @Override
    public Label createLabel(Composite parent, String text) {
        return this.widgetFactory.createLabel(parent, text);
    }

    @Override
    public Button createButton(String text, int ... styles) {
        return this.widgetFactory.createButton(text, styles);
    }

    @Override
    public Button createButton(Composite parent, String text, int style) {
        return this.widgetFactory.createButton(parent, text, style);
    }

    @Override
    public Text createText(String text) {
        return this.widgetFactory.createText(text);
    }

    @Override
    public Text createText(String text, int ... styles) {
        return this.widgetFactory.createText(text, styles);
    }

    @Override
    public Text createText(Composite parent, String text) {
        return this.widgetFactory.createText(parent, text);
    }

    @Override
    public Text createText(Composite parent, int ... styles) {
        return this.widgetFactory.createText(parent, styles);
    }

    @Override
    public Text createText(Composite parent, String text, int style) {
        return this.widgetFactory.createText(parent, text, style);
    }

    @Override
    public ComboViewer createComboViewer(int ... styles) {
        return this.widgetFactory.createComboViewer(styles);
    }

    @Override
    public ComboViewer createComboViewer(Composite parent, int style) {
        return this.widgetFactory.createComboViewer(parent, style);
    }

    @Override
    public DateTime createDateTime() {
        return this.widgetFactory.createDateTime();
    }

    @Override
    public DateTime createDateTime(int ... styles) {
        return this.widgetFactory.createDateTime(styles);
    }

    @Override
    public DateTime createDateTime(Composite parent) {
        return this.widgetFactory.createDateTime(parent);
    }

    @Override
    public DateTime createDateTime(Composite parent, int style) {
        return this.widgetFactory.createDateTime(parent, style);
    }

    @Override
    public Composite getParent() {
        return this.widgetFactory.getParent();
    }
}

