/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.util;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EEnumImpl;

public class FeatureHelper {
    public boolean isEditable(EStructuralFeature f) {
        return !f.isDerived() && f.isChangeable() && !this.isNotSerializableDataType(f);
    }

    private boolean isNotSerializableDataType(EStructuralFeature f) {
        return f.getEType() instanceof EDataType && !((EDataType)f.getEType()).isSerializable();
    }

    public boolean isBooleanFeature(EStructuralFeature feature) {
        return this.isBooleanEType(feature) || this.isBooleanDataType(feature);
    }

    private boolean isBooleanEType(EStructuralFeature feature) {
        EClassifier eType = feature.getEType();
        return eType.equals(EcorePackage.Literals.EBOOLEAN) || eType.equals(EcorePackage.Literals.EBOOLEAN_OBJECT);
    }

    private boolean isBooleanDataType(EStructuralFeature feature) {
        Class instanceClass = feature.getEType().getInstanceClass();
        return feature.getEType() instanceof EDataType && (instanceClass == Boolean.class || instanceClass == Boolean.TYPE);
    }

    public boolean hasPredefinedProposals(EStructuralFeature feature) {
        return feature instanceof EReference || feature.getEType() instanceof EEnumImpl;
    }
}

