/**
 * Copyright (c) 2013 RCP Vision (http://www.rcp-vision.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Lorenzo Bettini - initial API and implementation
 */
package org.eclipse.emf.parsley.dsl.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.parsley.EmfParsleyGuiceModule;
import org.eclipse.emf.parsley.dsl.jvmmodel.EmfParsleyDslGeneratorUtils;
import org.eclipse.emf.parsley.dsl.model.AbstractControlFactory;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureCaptionProviderWithLabel;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureProvider;
import org.eclipse.emf.parsley.dsl.model.Backgrounds;
import org.eclipse.emf.parsley.dsl.model.Binding;
import org.eclipse.emf.parsley.dsl.model.BindingsSpecification;
import org.eclipse.emf.parsley.dsl.model.Configurator;
import org.eclipse.emf.parsley.dsl.model.ConfiguratorEClass;
import org.eclipse.emf.parsley.dsl.model.ConfiguratorResourceURI;
import org.eclipse.emf.parsley.dsl.model.ContentProviderChildren;
import org.eclipse.emf.parsley.dsl.model.ContentProviderElements;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecification;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecifications;
import org.eclipse.emf.parsley.dsl.model.DialogControlFactory;
import org.eclipse.emf.parsley.dsl.model.DialogFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.EmfMenus;
import org.eclipse.emf.parsley.dsl.model.ExtendsClause;
import org.eclipse.emf.parsley.dsl.model.FeatureAssociatedExpression;
import org.eclipse.emf.parsley.dsl.model.FeatureBackgrounds;
import org.eclipse.emf.parsley.dsl.model.FeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.FeatureFonts;
import org.eclipse.emf.parsley.dsl.model.FeatureForegrounds;
import org.eclipse.emf.parsley.dsl.model.FeatureImages;
import org.eclipse.emf.parsley.dsl.model.FeatureLabels;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecification;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecifications;
import org.eclipse.emf.parsley.dsl.model.FeatureTexts;
import org.eclipse.emf.parsley.dsl.model.FeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.Fonts;
import org.eclipse.emf.parsley.dsl.model.Foregrounds;
import org.eclipse.emf.parsley.dsl.model.FormControlFactory;
import org.eclipse.emf.parsley.dsl.model.FormFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.Images;
import org.eclipse.emf.parsley.dsl.model.LabelProvider;
import org.eclipse.emf.parsley.dsl.model.MenuBuilder;
import org.eclipse.emf.parsley.dsl.model.Menus;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PolymorphicSpecification;
import org.eclipse.emf.parsley.dsl.model.ProposalCreator;
import org.eclipse.emf.parsley.dsl.model.ProviderBinding;
import org.eclipse.emf.parsley.dsl.model.ResourceManager;
import org.eclipse.emf.parsley.dsl.model.RowBackgrounds;
import org.eclipse.emf.parsley.dsl.model.RowFonts;
import org.eclipse.emf.parsley.dsl.model.RowForegrounds;
import org.eclipse.emf.parsley.dsl.model.SimpleMethodSpecification;
import org.eclipse.emf.parsley.dsl.model.TableFeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.TableLabelProvider;
import org.eclipse.emf.parsley.dsl.model.TableViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.Texts;
import org.eclipse.emf.parsley.dsl.model.TypeBinding;
import org.eclipse.emf.parsley.dsl.model.ValueBinding;
import org.eclipse.emf.parsley.dsl.model.ViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.WithExpressions;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.model.WithFeatureAssociatedExpressions;
import org.eclipse.emf.parsley.dsl.model.WithFields;
import org.eclipse.emf.parsley.dsl.typing.EmfParsleyDslTypeSystem;
import org.eclipse.emf.parsley.edit.action.EditingMenuBuilder;
import org.eclipse.emf.parsley.edit.action.IMenuContributionSpecification;
import org.eclipse.emf.parsley.generator.common.EmfParsleyProjectFilesGeneratorUtil;
import org.eclipse.emf.parsley.runtime.ui.AbstractGuiceAwareExecutableExtensionFactory;
import org.eclipse.emf.parsley.runtime.ui.PluginUtil;
import org.eclipse.emf.parsley.ui.provider.EClassToEStructuralFeatureAsStringsMap;
import org.eclipse.emf.parsley.ui.provider.TableColumnLabelProvider;
import org.eclipse.emf.parsley.ui.provider.ViewerLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;

/**
 * <p>Infers a JVM model from the source model.</p>
 * 
 * <p>The JVM model should contain all elements that would appear in the Java code
 * which is generated from the source model. Other models link against the JVM model rather than the source model.</p>
 */
@SuppressWarnings("all")
public class EmfParsleyDslJvmModelInferrer extends AbstractModelInferrer {
  /**
   * convenience API to build and initialize JVM types and their members.
   */
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  @Extension
  private TypeReferences _typeReferences;
  
  @Inject
  @Extension
  private TypesFactory _typesFactory;
  
  @Inject
  @Extension
  private EmfParsleyDslGeneratorUtils _emfParsleyDslGeneratorUtils;
  
  @Inject
  @Extension
  private EmfParsleyDslTypeSystem _emfParsleyDslTypeSystem;
  
  /**
   * The dispatch method {@code infer} is called for each instance of the
   * given element's type that is contained in a resource.
   * 
   * @param element
   *            the model to create one or more
   *            {@link JvmDeclaredType declared
   *            types} from.
   * @param acceptor
   *            each created
   *            {@link JvmDeclaredType type}
   *            without a container should be passed to the acceptor in order
   *            get attached to the current resource. The acceptor's
   *            {@link IJvmDeclaredTypeAcceptor#accept(org.eclipse.xtext.common.types.JvmDeclaredType)
   *            accept(..)} method takes the constructed empty type for the
   *            pre-indexing phase. This one is further initialized in the
   *            indexing phase using the closure you pass as the last argument.
   * @param isPreIndexingPhase
   *            whether the method is called in a pre-indexing phase, i.e.
   *            when the global index is not yet fully updated. You must not
   *            rely on linking using the index if isPreIndexingPhase is
   *            <code>true</code>.
   */
  protected void _infer(final Module element, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPreIndexingPhase) {
    String _name = element.getName();
    boolean _isEmpty = _name.isEmpty();
    if (_isEmpty) {
      return;
    }
    String _moduleQN = this.moduleQN(element);
    final JvmGenericType moduleClass = this._jvmTypesBuilder.toClass(element, _moduleQN);
    final JvmGenericType labelProviderClass = this.inferLabelProvider(element, acceptor);
    final JvmGenericType tableLabelProviderClass = this.inferTableLabelProvider(element, acceptor);
    final JvmGenericType featureCaptionProviderClass = this.inferFeatureCaptionProvider(element, acceptor);
    final JvmGenericType formFeatureCaptionProviderClass = this.inferFormFeatureCaptionProvider(element, acceptor);
    final JvmGenericType dialogFeatureCaptionProviderClass = this.inferDialogFeatureCaptionProvider(element, acceptor);
    final JvmGenericType featureProviderClass = this.inferFeatureProvider(element, acceptor);
    final JvmGenericType tableFeatureProviderClass = this.inferTableFeatureProvider(element, acceptor);
    final JvmGenericType formControlFactoryClass = this.inferFormControlFactory(element, acceptor);
    final JvmGenericType dialogControlFactoryClass = this.inferDialogControlFactory(element, acceptor);
    final JvmGenericType viewerContentProviderClass = this.inferViewerContentProvider(element, acceptor);
    final JvmGenericType tableViewerContentProviderClass = this.inferTableViewerContentProvider(element, acceptor);
    final JvmGenericType proposalCreatorClass = this.inferProposalCreator(element, acceptor);
    final JvmGenericType menuBuilderClass = this.inferMenuBuilder(element, acceptor);
    final JvmGenericType configuratorClass = this.inferConfigurator(element, acceptor);
    final JvmGenericType resourceManagerClass = this.inferResourceManager(element, acceptor);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        String _documentation = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.getDocumentation(element);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setDocumentation(it, _documentation);
        EmfParsleyDslJvmModelInferrer.this.setSuperClassType(moduleClass, element, EmfParsleyGuiceModule.class);
        EList<JvmMember> _members = it.getMembers();
        final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
          @Override
          public void apply(final JvmConstructor it) {
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(AbstractUIPlugin.class);
            JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(element, "plugin", _typeRef);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            final ExtendsClause extendsClause = element.getExtendsClause();
            boolean _and = false;
            boolean _notEquals = (!Objects.equal(extendsClause, null));
            if (!_notEquals) {
              _and = false;
            } else {
              JvmTypeReference _superType = extendsClause.getSuperType();
              boolean _isConformant = EmfParsleyDslJvmModelInferrer.this._emfParsleyDslTypeSystem.isConformant(element, EmfParsleyGuiceModule.class, _superType);
              boolean _not = (!_isConformant);
              _and = _not;
            }
            if (_and) {
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("// not used");
                }
              };
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _client);
            } else {
              StringConcatenationClient _client_1 = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("super(plugin);");
                }
              };
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _client_1);
            }
          }
        };
        JvmConstructor _constructor = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toConstructor(element, _function);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
        final BindingsSpecification bindingsSpecification = element.getBindingsSpecification();
        BindingsSpecification _bindingsSpecification = element.getBindingsSpecification();
        boolean _notEquals = (!Objects.equal(_bindingsSpecification, null));
        if (_notEquals) {
          EmfParsleyDslJvmModelInferrer.this.handleBindingsSpecification(it, bindingsSpecification);
        }
        boolean _notEquals_1 = (!Objects.equal(labelProviderClass, null));
        if (_notEquals_1) {
          EList<JvmMember> _members_1 = it.getMembers();
          LabelProvider _labelProvider = element.getLabelProvider();
          JvmOperation _genBindMethod = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_labelProvider, labelProviderClass, ILabelProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _genBindMethod);
        }
        boolean _notEquals_2 = (!Objects.equal(tableLabelProviderClass, null));
        if (_notEquals_2) {
          EList<JvmMember> _members_2 = it.getMembers();
          TableLabelProvider _tableLabelProvider = element.getTableLabelProvider();
          JvmOperation _genBindMethod_1 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_tableLabelProvider, tableLabelProviderClass, TableColumnLabelProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _genBindMethod_1);
        }
        boolean _notEquals_3 = (!Objects.equal(featureCaptionProviderClass, null));
        if (_notEquals_3) {
          EList<JvmMember> _members_3 = it.getMembers();
          FeatureCaptionProvider _featureCaptionProvider = element.getFeatureCaptionProvider();
          JvmOperation _genBindMethod_2 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_featureCaptionProvider, featureCaptionProviderClass, org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _genBindMethod_2);
        }
        boolean _notEquals_4 = (!Objects.equal(formFeatureCaptionProviderClass, null));
        if (_notEquals_4) {
          EList<JvmMember> _members_4 = it.getMembers();
          FormFeatureCaptionProvider _formFeatureCaptionProvider = element.getFormFeatureCaptionProvider();
          JvmOperation _genBindMethod_3 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_formFeatureCaptionProvider, formFeatureCaptionProviderClass, org.eclipse.emf.parsley.ui.provider.FormFeatureCaptionProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_4, _genBindMethod_3);
        }
        boolean _notEquals_5 = (!Objects.equal(dialogFeatureCaptionProviderClass, null));
        if (_notEquals_5) {
          EList<JvmMember> _members_5 = it.getMembers();
          DialogFeatureCaptionProvider _dialogFeatureCaptionProvider = element.getDialogFeatureCaptionProvider();
          JvmOperation _genBindMethod_4 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_dialogFeatureCaptionProvider, dialogFeatureCaptionProviderClass, org.eclipse.emf.parsley.ui.provider.DialogFeatureCaptionProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_5, _genBindMethod_4);
        }
        boolean _notEquals_6 = (!Objects.equal(featureProviderClass, null));
        if (_notEquals_6) {
          EList<JvmMember> _members_6 = it.getMembers();
          FeaturesProvider _featuresProvider = element.getFeaturesProvider();
          JvmOperation _genBindMethod_5 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_featuresProvider, featureProviderClass, org.eclipse.emf.parsley.ui.provider.FeaturesProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_6, _genBindMethod_5);
        }
        boolean _notEquals_7 = (!Objects.equal(tableFeatureProviderClass, null));
        if (_notEquals_7) {
          EList<JvmMember> _members_7 = it.getMembers();
          TableFeaturesProvider _tableFeaturesProvider = element.getTableFeaturesProvider();
          JvmOperation _genBindMethod_6 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_tableFeaturesProvider, tableFeatureProviderClass, org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_7, _genBindMethod_6);
        }
        boolean _notEquals_8 = (!Objects.equal(formControlFactoryClass, null));
        if (_notEquals_8) {
          EList<JvmMember> _members_8 = it.getMembers();
          FormControlFactory _formControlFactory = element.getFormControlFactory();
          JvmOperation _genBindMethod_7 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_formControlFactory, formControlFactoryClass, org.eclipse.emf.parsley.composite.FormControlFactory.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_8, _genBindMethod_7);
        }
        boolean _notEquals_9 = (!Objects.equal(dialogControlFactoryClass, null));
        if (_notEquals_9) {
          EList<JvmMember> _members_9 = it.getMembers();
          DialogControlFactory _dialogControlFactory = element.getDialogControlFactory();
          JvmOperation _genBindMethod_8 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_dialogControlFactory, dialogControlFactoryClass, org.eclipse.emf.parsley.composite.DialogControlFactory.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_9, _genBindMethod_8);
        }
        boolean _notEquals_10 = (!Objects.equal(viewerContentProviderClass, null));
        if (_notEquals_10) {
          EList<JvmMember> _members_10 = it.getMembers();
          ViewerContentProvider _viewerContentProvider = element.getViewerContentProvider();
          JvmOperation _genBindMethod_9 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_viewerContentProvider, viewerContentProviderClass, IContentProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_10, _genBindMethod_9);
        }
        boolean _notEquals_11 = (!Objects.equal(tableViewerContentProviderClass, null));
        if (_notEquals_11) {
          EList<JvmMember> _members_11 = it.getMembers();
          TableViewerContentProvider _tableViewerContentProvider = element.getTableViewerContentProvider();
          JvmOperation _genBindMethod_10 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_tableViewerContentProvider, tableViewerContentProviderClass, org.eclipse.emf.parsley.edit.ui.provider.TableViewerContentProvider.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_11, _genBindMethod_10);
        }
        boolean _notEquals_12 = (!Objects.equal(proposalCreatorClass, null));
        if (_notEquals_12) {
          EList<JvmMember> _members_12 = it.getMembers();
          ProposalCreator _proposalCreator = element.getProposalCreator();
          JvmOperation _genBindMethod_11 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_proposalCreator, proposalCreatorClass, org.eclipse.emf.parsley.composite.ProposalCreator.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_12, _genBindMethod_11);
        }
        boolean _notEquals_13 = (!Objects.equal(menuBuilderClass, null));
        if (_notEquals_13) {
          EList<JvmMember> _members_13 = it.getMembers();
          MenuBuilder _menuBuilder = element.getMenuBuilder();
          JvmOperation _genBindMethod_12 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_menuBuilder, menuBuilderClass, EditingMenuBuilder.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_13, _genBindMethod_12);
        }
        boolean _notEquals_14 = (!Objects.equal(configuratorClass, null));
        if (_notEquals_14) {
          EList<JvmMember> _members_14 = it.getMembers();
          Configurator _configurator = element.getConfigurator();
          JvmOperation _genBindMethod_13 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_configurator, configuratorClass, org.eclipse.emf.parsley.config.Configurator.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_14, _genBindMethod_13);
        }
        boolean _notEquals_15 = (!Objects.equal(resourceManagerClass, null));
        if (_notEquals_15) {
          EList<JvmMember> _members_15 = it.getMembers();
          ResourceManager _resourceManager = element.getResourceManager();
          JvmOperation _genBindMethod_14 = EmfParsleyDslJvmModelInferrer.this.genBindMethod(_resourceManager, resourceManagerClass, org.eclipse.emf.parsley.resource.ResourceManager.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_15, _genBindMethod_14);
        }
      }
    };
    acceptor.<JvmGenericType>accept(moduleClass, _function);
    String _injectorProviderQN = this.injectorProviderQN(element);
    final JvmGenericType injectorProviderClass = this._jvmTypesBuilder.toClass(element, _injectorProviderQN);
    final Procedure1<JvmGenericType> _function_1 = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        EList<JvmMember> _members = it.getMembers();
        JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Injector.class);
        JvmField _field = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toField(element, "injector", _typeRef);
        final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setStatic(true);
            it.setVisibility(JvmVisibility.PRIVATE);
          }
        };
        JvmField _doubleArrow = ObjectExtensions.<JvmField>operator_doubleArrow(_field, _function);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmMember>operator_add(_members, _doubleArrow);
        EList<JvmMember> _members_1 = it.getMembers();
        JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Injector.class);
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setStatic(true);
            it.setSynchronized(true);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("if (injector == null) {");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("injector = ");
                _builder.append(Guice.class, "  ");
                _builder.append(".createInjector(");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("new ");
                _builder.append(moduleClass, "    ");
                _builder.append("(");
                _builder.append(PluginUtil.class, "    ");
                _builder.append(".getPlugin(");
                _builder.newLineIfNotEmpty();
                _builder.append("      ");
                _builder.append(PluginUtil.class, "      ");
                _builder.append(".getBundle(");
                _builder.append(injectorProviderClass, "      ");
                _builder.append(".class))));");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
                _builder.append("return injector;");
                _builder.newLine();
              }
            };
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toMethod(element, "getInjector", _typeRef_1, _function_1);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
      }
    };
    acceptor.<JvmGenericType>accept(injectorProviderClass, _function_1);
    boolean _shouldGenerateExtensions = this._emfParsleyDslGeneratorUtils.shouldGenerateExtensions(element);
    if (_shouldGenerateExtensions) {
      String _executableExtensionFactoryQN = this._emfParsleyDslGeneratorUtils.executableExtensionFactoryQN(element);
      JvmGenericType _class = this._jvmTypesBuilder.toClass(element, _executableExtensionFactoryQN);
      final Procedure1<JvmGenericType> _function_2 = new Procedure1<JvmGenericType>() {
        @Override
        public void apply(final JvmGenericType it) {
          EList<JvmTypeReference> _superTypes = it.getSuperTypes();
          JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(AbstractGuiceAwareExecutableExtensionFactory.class);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
          EList<JvmMember> _members = it.getMembers();
          JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Injector.class);
          final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              EmfParsleyDslJvmModelInferrer.this.addOverrideAnnotation(it);
              EList<JvmTypeReference> _exceptions = it.getExceptions();
              JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Exception.class);
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
              StringConcatenationClient _client = new StringConcatenationClient() {
                @Override
                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                  _builder.append("return ");
                  _builder.append(injectorProviderClass, "");
                  _builder.append(".getInjector();");
                  _builder.newLineIfNotEmpty();
                }
              };
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _client);
            }
          };
          JvmOperation _method = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toMethod(element, "getInjector", _typeRef_1, _function);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
        }
      };
      acceptor.<JvmGenericType>accept(_class, _function_2);
    }
  }
  
  private boolean setSuperClassType(final JvmGenericType e, final WithExtendsClause dslElement, final Class<?> defaultSuperClass) {
    boolean _xifexpression = false;
    ExtendsClause _extendsClause = dslElement.getExtendsClause();
    boolean _notEquals = (!Objects.equal(_extendsClause, null));
    if (_notEquals) {
      EList<JvmTypeReference> _superTypes = e.getSuperTypes();
      ExtendsClause _extendsClause_1 = dslElement.getExtendsClause();
      JvmTypeReference _superType = _extendsClause_1.getSuperType();
      JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(_superType);
      _xifexpression = this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _cloneWithProxies);
    } else {
      EList<JvmTypeReference> _superTypes_1 = e.getSuperTypes();
      JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(defaultSuperClass);
      _xifexpression = this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes_1, _typeRef);
    }
    return _xifexpression;
  }
  
  private void setSuperClassTypeAndFields(final JvmGenericType e, final WithFields dslElement, final Class<?> defaultSuperClass) {
    this.setSuperClassType(e, dslElement, defaultSuperClass);
    this.processFields(e, dslElement);
  }
  
  private void processFields(final JvmGenericType it, final WithFields dslElement) {
    EList<FieldSpecification> _fields = dslElement.getFields();
    for (final FieldSpecification f : _fields) {
      {
        JvmTypeReference _elvis = null;
        JvmTypeReference _type = f.getType();
        if (_type != null) {
          _elvis = _type;
        } else {
          XExpression _right = f.getRight();
          JvmTypeReference _inferredType = null;
          if (_right!=null) {
            _inferredType=this._jvmTypesBuilder.inferredType(_right);
          }
          _elvis = _inferredType;
        }
        final JvmTypeReference type = _elvis;
        final String name = f.getName();
        final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            XExpression _right = f.getRight();
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setInitializer(it, _right);
            boolean _isWriteable = f.isWriteable();
            boolean _not = (!_isWriteable);
            it.setFinal(_not);
            it.setVisibility(JvmVisibility.PRIVATE);
            EList<XAnnotation> _annotations = f.getAnnotations();
            EmfParsleyDslJvmModelInferrer.this.translateAnnotations(it, _annotations);
            boolean _isExtension = f.isExtension();
            if (_isExtension) {
              EList<JvmAnnotationReference> _annotations_1 = it.getAnnotations();
              JvmAnnotationReference _annotationRef = EmfParsleyDslJvmModelInferrer.this._annotationTypesBuilder.annotationRef(Extension.class);
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations_1, _annotationRef);
            }
          }
        };
        final JvmField field = this._jvmTypesBuilder.toField(f, name, type, _function);
        EList<JvmMember> _members = it.getMembers();
        this._jvmTypesBuilder.<JvmField>operator_add(_members, field);
        EList<JvmMember> _members_1 = it.getMembers();
        JvmOperation _getter = this._jvmTypesBuilder.toGetter(f, name, type);
        this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _getter);
        boolean _isWriteable = f.isWriteable();
        if (_isWriteable) {
          EList<JvmMember> _members_2 = it.getMembers();
          JvmOperation _setter = this._jvmTypesBuilder.toSetter(f, name, type);
          this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _setter);
        }
      }
    }
  }
  
  private void translateAnnotations(final JvmAnnotationTarget target, final List<XAnnotation> annotations) {
    Iterable<XAnnotation> _filterNull = IterableExtensions.<XAnnotation>filterNull(annotations);
    final Function1<XAnnotation, Boolean> _function = new Function1<XAnnotation, Boolean>() {
      @Override
      public Boolean apply(final XAnnotation it) {
        JvmType _annotationType = it.getAnnotationType();
        return Boolean.valueOf((!Objects.equal(_annotationType, null)));
      }
    };
    Iterable<XAnnotation> _filter = IterableExtensions.<XAnnotation>filter(_filterNull, _function);
    this._jvmTypesBuilder.addAnnotations(target, _filter);
  }
  
  private String moduleQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".EmfParsleyGuiceModule");
  }
  
  private String injectorProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".InjectorProvider");
  }
  
  private String labelProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".ui.provider.LabelProvider");
  }
  
  private String tableLabelProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".ui.provider.TableLabelProvider");
  }
  
  private String featureCaptionProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".ui.provider.FeatureCaptionProvider");
  }
  
  private String formFeatureCaptionProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".ui.provider.FormFeatureCaptionProvider");
  }
  
  private String dialogFeatureCaptionProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".ui.provider.DialogFeatureCaptionProvider");
  }
  
  private String featuresProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".ui.provider.FeaturesProvider");
  }
  
  private String tableFeaturesProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".ui.provider.TableFeaturesProvider");
  }
  
  private String formControlFactoryQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".binding.FormControlFactory");
  }
  
  private String dialogControlFactoryQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".binding.DialogControlFactory");
  }
  
  private String viewerContentProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".edit.ui.provider.ViewerContentProvider");
  }
  
  private String tableViewerContentProviderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".edit.ui.provider.TableViewerContentProvider");
  }
  
  private String proposalCreatorQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".binding.ProposalCreator");
  }
  
  private String menuBuilderQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".edit.action.MenuBuilder");
  }
  
  private String configuratorQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".config.Configurator");
  }
  
  private String resourceManagerQN(final Module element) {
    return this.fromModuleToJavaFullyQualifiedName(element, ".resource.ResourceManager");
  }
  
  private String fromModuleToJavaFullyQualifiedName(final Module element, final String templateString) {
    String _xblockexpression = null;
    {
      QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(element);
      final String fqn = _fullyQualifiedName.toString();
      final String prefix = EmfParsleyProjectFilesGeneratorUtil.buildClassNameFromProject(fqn);
      final int lastDot = templateString.lastIndexOf(".");
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(fqn, "");
      String _substring = templateString.substring(0, (lastDot + 1));
      _builder.append(_substring, "");
      _builder.append(prefix, "");
      String _substring_1 = templateString.substring((lastDot + 1));
      _builder.append(_substring_1, "");
      _xblockexpression = _builder.toString();
    }
    return _xblockexpression;
  }
  
  private JvmGenericType inferLabelProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    LabelProvider _labelProvider = element.getLabelProvider();
    boolean _equals = Objects.equal(_labelProvider, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final LabelProvider labelProvider = element.getLabelProvider();
        String _labelProviderQN = this.labelProviderQN(element);
        final JvmGenericType labelProviderClass = this._jvmTypesBuilder.toClass(labelProvider, _labelProviderQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, labelProvider, ViewerLabelProvider.class);
            EList<JvmMember> _members = it.getMembers();
            final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
              @Override
              public void apply(final JvmConstructor it) {
                EList<JvmFormalParameter> _parameters = it.getParameters();
                JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(AdapterFactoryLabelProvider.class);
                JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(labelProvider, "delegate", _typeRef);
                EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                  @Override
                  public void apply(final ITreeAppendable it) {
                    it.append("super(delegate);");
                  }
                };
                EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _function);
                EList<JvmAnnotationReference> _annotations = it.getAnnotations();
                JvmAnnotationReference _annotationRef = EmfParsleyDslJvmModelInferrer.this._annotationTypesBuilder.annotationRef(Inject.class);
                EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
              }
            };
            JvmConstructor _constructor = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toConstructor(labelProvider, _function);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
            Texts _texts = labelProvider.getTexts();
            JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(String.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _texts, "text", _typeRef);
            Images _images = labelProvider.getImages();
            JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _images, "image", _typeRef_1);
            Fonts _fonts = labelProvider.getFonts();
            JvmTypeReference _typeRef_2 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Font.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _fonts, "font", _typeRef_2);
            Foregrounds _foregrounds = labelProvider.getForegrounds();
            JvmTypeReference _typeRef_3 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Color.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _foregrounds, "foreground", _typeRef_3);
            Backgrounds _backgrounds = labelProvider.getBackgrounds();
            JvmTypeReference _typeRef_4 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Color.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _backgrounds, "background", _typeRef_4);
          }
        };
        acceptor.<JvmGenericType>accept(labelProviderClass, _function);
        _xblockexpression = labelProviderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferTableLabelProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    TableLabelProvider _tableLabelProvider = element.getTableLabelProvider();
    boolean _equals = Objects.equal(_tableLabelProvider, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final TableLabelProvider tableLabelProvider = element.getTableLabelProvider();
        String _tableLabelProviderQN = this.tableLabelProviderQN(element);
        final JvmGenericType tableLabelProviderClass = this._jvmTypesBuilder.toClass(tableLabelProvider, _tableLabelProviderQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, tableLabelProvider, TableColumnLabelProvider.class);
            FeatureTexts _featureTexts = tableLabelProvider.getFeatureTexts();
            JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(String.class);
            Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> _parameterCreatorForFeatureAssociatedExpression = EmfParsleyDslJvmModelInferrer.this.getParameterCreatorForFeatureAssociatedExpression();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForFeatureAssociatedExpression(it, _featureTexts, "text_", _typeRef, _parameterCreatorForFeatureAssociatedExpression);
            FeatureImages _featureImages = tableLabelProvider.getFeatureImages();
            JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Object.class);
            Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> _parameterCreatorForFeatureAssociatedExpression_1 = EmfParsleyDslJvmModelInferrer.this.getParameterCreatorForFeatureAssociatedExpression();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForFeatureAssociatedExpression(it, _featureImages, "image_", _typeRef_1, _parameterCreatorForFeatureAssociatedExpression_1);
            FeatureFonts _featureFonts = tableLabelProvider.getFeatureFonts();
            JvmTypeReference _typeRef_2 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Font.class);
            Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> _parameterCreatorForFeatureAssociatedExpression_2 = EmfParsleyDslJvmModelInferrer.this.getParameterCreatorForFeatureAssociatedExpression();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForFeatureAssociatedExpression(it, _featureFonts, "font_", _typeRef_2, _parameterCreatorForFeatureAssociatedExpression_2);
            FeatureForegrounds _featureForegrounds = tableLabelProvider.getFeatureForegrounds();
            JvmTypeReference _typeRef_3 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Color.class);
            Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> _parameterCreatorForFeatureAssociatedExpression_3 = EmfParsleyDslJvmModelInferrer.this.getParameterCreatorForFeatureAssociatedExpression();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForFeatureAssociatedExpression(it, _featureForegrounds, "foreground_", _typeRef_3, _parameterCreatorForFeatureAssociatedExpression_3);
            FeatureBackgrounds _featureBackgrounds = tableLabelProvider.getFeatureBackgrounds();
            JvmTypeReference _typeRef_4 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Color.class);
            Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> _parameterCreatorForFeatureAssociatedExpression_4 = EmfParsleyDslJvmModelInferrer.this.getParameterCreatorForFeatureAssociatedExpression();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForFeatureAssociatedExpression(it, _featureBackgrounds, "background_", _typeRef_4, _parameterCreatorForFeatureAssociatedExpression_4);
            RowFonts _rowFonts = tableLabelProvider.getRowFonts();
            JvmTypeReference _typeRef_5 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Font.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _rowFonts, "rowFont", _typeRef_5);
            RowForegrounds _rowForegrounds = tableLabelProvider.getRowForegrounds();
            JvmTypeReference _typeRef_6 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Color.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _rowForegrounds, "rowForeground", _typeRef_6);
            RowBackgrounds _rowBackgrounds = tableLabelProvider.getRowBackgrounds();
            JvmTypeReference _typeRef_7 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Color.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _rowBackgrounds, "rowBackground", _typeRef_7);
          }
        };
        acceptor.<JvmGenericType>accept(tableLabelProviderClass, _function);
        _xblockexpression = tableLabelProviderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferFeatureCaptionProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    FeatureCaptionProvider _featureCaptionProvider = element.getFeatureCaptionProvider();
    boolean _equals = Objects.equal(_featureCaptionProvider, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final FeatureCaptionProvider featureCaptionProvider = element.getFeatureCaptionProvider();
        String _featureCaptionProviderQN = this.featureCaptionProviderQN(element);
        final JvmGenericType propertyDescriptionProviderClass = this._jvmTypesBuilder.toClass(featureCaptionProvider, _featureCaptionProviderQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, featureCaptionProvider, org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider.class);
            FeatureTexts _featureTexts = featureCaptionProvider.getFeatureTexts();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForTextCaptionSpecifications(it, _featureTexts);
          }
        };
        acceptor.<JvmGenericType>accept(propertyDescriptionProviderClass, _function);
        _xblockexpression = propertyDescriptionProviderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferFormFeatureCaptionProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    FormFeatureCaptionProvider _formFeatureCaptionProvider = element.getFormFeatureCaptionProvider();
    String _formFeatureCaptionProviderQN = this.formFeatureCaptionProviderQN(element);
    return this.inferDialogFeatureCaptionProviderWithLabel(_formFeatureCaptionProvider, _formFeatureCaptionProviderQN, org.eclipse.emf.parsley.ui.provider.FormFeatureCaptionProvider.class, acceptor);
  }
  
  private JvmGenericType inferDialogFeatureCaptionProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    DialogFeatureCaptionProvider _dialogFeatureCaptionProvider = element.getDialogFeatureCaptionProvider();
    String _dialogFeatureCaptionProviderQN = this.dialogFeatureCaptionProviderQN(element);
    return this.inferDialogFeatureCaptionProviderWithLabel(_dialogFeatureCaptionProvider, _dialogFeatureCaptionProviderQN, org.eclipse.emf.parsley.ui.provider.DialogFeatureCaptionProvider.class, acceptor);
  }
  
  private JvmGenericType inferDialogFeatureCaptionProviderWithLabel(final AbstractFeatureCaptionProviderWithLabel element, final String name, final Class<?> superClass, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    boolean _equals = Objects.equal(element, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final JvmGenericType descriptionProviderClass = this._jvmTypesBuilder.toClass(element, name);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, element, superClass);
            FeatureTexts _featureTexts = element.getFeatureTexts();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForTextCaptionSpecifications(it, _featureTexts);
            FeatureLabels _featureLabels = element.getFeatureLabels();
            EmfParsleyDslJvmModelInferrer.this.inferMethodsForLabelCaptionSpecifications(it, _featureLabels);
          }
        };
        acceptor.<JvmGenericType>accept(descriptionProviderClass, _function);
        _xblockexpression = descriptionProviderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> getParameterCreatorForFeatureAssociatedExpression() {
    final Procedure2<JvmOperation, FeatureAssociatedExpression> _function = new Procedure2<JvmOperation, FeatureAssociatedExpression>() {
      @Override
      public void apply(final JvmOperation it, final FeatureAssociatedExpression spec) {
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _parameterType = spec.getParameterType();
        JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
          "it", _parameterType);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
      }
    };
    return _function;
  }
  
  private void inferMethodsForTextCaptionSpecifications(final JvmGenericType it, final FeatureTexts texts) {
    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(String.class);
    final Procedure2<JvmOperation, FeatureAssociatedExpression> _function = new Procedure2<JvmOperation, FeatureAssociatedExpression>() {
      @Override
      public void apply(final JvmOperation it, final FeatureAssociatedExpression spec) {
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(EStructuralFeature.class);
        JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
          "it", _typeRef);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
      }
    };
    this.inferMethodsForFeatureAssociatedExpression(it, texts, "text_", _typeRef, _function);
  }
  
  private void inferMethodsForLabelCaptionSpecifications(final JvmGenericType it, final FeatureLabels labels) {
    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Label.class);
    final Procedure2<JvmOperation, FeatureAssociatedExpression> _function = new Procedure2<JvmOperation, FeatureAssociatedExpression>() {
      @Override
      public void apply(final JvmOperation it, final FeatureAssociatedExpression spec) {
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Composite.class);
        JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
          "parent", _typeRef);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        EList<JvmFormalParameter> _parameters_1 = it.getParameters();
        JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(EStructuralFeature.class);
        JvmFormalParameter _parameter_1 = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
          "it", _typeRef_1);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
      }
    };
    this.inferMethodsForFeatureAssociatedExpression(it, labels, "label_", _typeRef, _function);
  }
  
  private void inferMethodsForFeatureAssociatedExpression(final JvmGenericType it, final WithFeatureAssociatedExpressions withFeatureAssociatedExpressions, final String prefix, final JvmTypeReference returnType, final Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> parameterCreator) {
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        EList<FeatureAssociatedExpression> _specifications = withFeatureAssociatedExpressions.getSpecifications();
        for (final FeatureAssociatedExpression spec : _specifications) {
          EmfParsleyDslJvmModelInferrer.this.featureAssociatedExpressionToMethod(it, spec, prefix, returnType, parameterCreator);
        }
      }
    };
    this.<WithFeatureAssociatedExpressions>nullSafeAccess(it, withFeatureAssociatedExpressions, _function);
  }
  
  private boolean featureAssociatedExpressionToMethod(final JvmGenericType it, final FeatureAssociatedExpression spec, final String prefix, final JvmTypeReference returnType, final Procedure2<? super JvmOperation, ? super FeatureAssociatedExpression> parameterCreator) {
    boolean _xifexpression = false;
    JvmMember _feature = spec.getFeature();
    String _simpleName = null;
    if (_feature!=null) {
      _simpleName=_feature.getSimpleName();
    }
    boolean _notEquals = (!Objects.equal(_simpleName, null));
    if (_notEquals) {
      EList<JvmMember> _members = it.getMembers();
      JvmTypeReference _parameterType = spec.getParameterType();
      String _simpleName_1 = _parameterType.getSimpleName();
      String _plus = (prefix + _simpleName_1);
      String _plus_1 = (_plus + "_");
      JvmMember _feature_1 = spec.getFeature();
      String _simpleName_2 = _feature_1.getSimpleName();
      String _propertyNameForGetterSetterMethod = this._emfParsleyDslGeneratorUtils.getPropertyNameForGetterSetterMethod(_simpleName_2);
      String _plus_2 = (_plus_1 + _propertyNameForGetterSetterMethod);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          parameterCreator.apply(it, spec);
          XExpression _expression = spec.getExpression();
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _expression);
        }
      };
      JvmOperation _method = this._jvmTypesBuilder.toMethod(spec, _plus_2, returnType, _function);
      _xifexpression = this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferFeatureProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    FeaturesProvider _featuresProvider = element.getFeaturesProvider();
    String _featuresProviderQN = this.featuresProviderQN(element);
    return this.inferFeatureProviderCommon(_featuresProvider, _featuresProviderQN, org.eclipse.emf.parsley.ui.provider.FeaturesProvider.class, acceptor);
  }
  
  private JvmGenericType inferTableFeatureProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    TableFeaturesProvider _tableFeaturesProvider = element.getTableFeaturesProvider();
    String _tableFeaturesProviderQN = this.tableFeaturesProviderQN(element);
    return this.inferFeatureProviderCommon(_tableFeaturesProvider, _tableFeaturesProviderQN, org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider.class, acceptor);
  }
  
  private JvmGenericType inferFeatureProviderCommon(final AbstractFeatureProvider element, final String name, final Class<?> superClass, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    boolean _equals = Objects.equal(element, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final JvmGenericType featureProviderClass = this._jvmTypesBuilder.toClass(element, name);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, element, superClass);
            String _documentation = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.getDocumentation(element);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setDocumentation(it, _documentation);
            EList<JvmMember> _members = it.getMembers();
            JvmTypeReference _typeForName = EmfParsleyDslJvmModelInferrer.this._typeReferences.getTypeForName(Void.TYPE, element);
            final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation m) {
                EmfParsleyDslJvmModelInferrer.this.addOverrideAnnotation(m);
                EList<JvmFormalParameter> _parameters = m.getParameters();
                JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(EClassToEStructuralFeatureAsStringsMap.class);
                JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(element, "stringMap", _typeRef);
                EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                  @Override
                  public void apply(final ITreeAppendable a) {
                    ITreeAppendable _append = a.append("super.buildStringMap(stringMap);");
                    _append.newLine();
                    FeatureSpecifications _features = element.getFeatures();
                    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
                      @Override
                      public void apply(final JvmGenericType it) {
                        FeatureSpecifications _features = element.getFeatures();
                        EList<FeatureSpecification> _featureSpecifications = _features.getFeatureSpecifications();
                        for (final FeatureSpecification featureSpecification : _featureSpecifications) {
                          {
                            ITreeAppendable _newLine = a.newLine();
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("stringMap.mapTo(\"");
                            JvmTypeReference _parameterType = featureSpecification.getParameterType();
                            String _identifier = _parameterType.getIdentifier();
                            _builder.append(_identifier, "");
                            _builder.append("\",");
                            ITreeAppendable _append = _newLine.append(_builder);
                            ITreeAppendable _increaseIndentation = _append.increaseIndentation();
                            _increaseIndentation.newLine();
                            EList<JvmMember> _features_1 = featureSpecification.getFeatures();
                            final Function1<JvmMember, String> _function = new Function1<JvmMember, String>() {
                              @Override
                              public String apply(final JvmMember feature) {
                                String _simpleName = feature.getSimpleName();
                                String _propertyNameForGetterSetterMethod = EmfParsleyDslJvmModelInferrer.this._emfParsleyDslGeneratorUtils.getPropertyNameForGetterSetterMethod(_simpleName);
                                String _plus = ("\"" + _propertyNameForGetterSetterMethod);
                                return (_plus + "\"");
                              }
                            };
                            final List<String> fs = ListExtensions.<JvmMember, String>map(_features_1, _function);
                            String _join = IterableExtensions.join(fs, ", ");
                            a.append(_join);
                            ITreeAppendable _append_1 = a.append(");");
                            _append_1.decreaseIndentation();
                          }
                        }
                      }
                    };
                    EmfParsleyDslJvmModelInferrer.this.<FeatureSpecifications>nullSafeAccess(it, _features, _function);
                  }
                };
                EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(m, _function);
              }
            };
            JvmOperation _method = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toMethod(element, "buildStringMap", _typeForName, _function);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
          }
        };
        acceptor.<JvmGenericType>accept(featureProviderClass, _function);
        _xblockexpression = featureProviderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferFormControlFactory(final Module e, final IJvmDeclaredTypeAcceptor acceptor) {
    FormControlFactory _formControlFactory = e.getFormControlFactory();
    String _formControlFactoryQN = this.formControlFactoryQN(e);
    return this.inferControlFactory(_formControlFactory, _formControlFactoryQN, org.eclipse.emf.parsley.composite.FormControlFactory.class, acceptor);
  }
  
  private JvmGenericType inferDialogControlFactory(final Module e, final IJvmDeclaredTypeAcceptor acceptor) {
    DialogControlFactory _dialogControlFactory = e.getDialogControlFactory();
    String _dialogControlFactoryQN = this.dialogControlFactoryQN(e);
    return this.inferControlFactory(_dialogControlFactory, _dialogControlFactoryQN, org.eclipse.emf.parsley.composite.DialogControlFactory.class, acceptor);
  }
  
  private JvmGenericType inferControlFactory(final AbstractControlFactory e, final String name, final Class<?> superClass, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    boolean _equals = Objects.equal(e, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final JvmGenericType controlFactoryClass = this._jvmTypesBuilder.toClass(e, name);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, e, superClass);
            String _documentation = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.getDocumentation(e);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setDocumentation(it, _documentation);
            ControlFactorySpecifications _controls = e.getControls();
            final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
              @Override
              public void apply(final JvmGenericType it) {
                ControlFactorySpecifications _controls = e.getControls();
                EList<ControlFactorySpecification> _specifications = _controls.getSpecifications();
                EmfParsleyDslJvmModelInferrer.this.inferMethodsForControlFactory(e, it, _specifications);
              }
            };
            EmfParsleyDslJvmModelInferrer.this.<ControlFactorySpecifications>nullSafeAccess(it, _controls, _function);
          }
        };
        acceptor.<JvmGenericType>accept(controlFactoryClass, _function);
        _xblockexpression = controlFactoryClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private void inferMethodsForControlFactory(final AbstractControlFactory e, final JvmGenericType it, final Iterable<ControlFactorySpecification> specifications) {
    for (final ControlFactorySpecification spec : specifications) {
      JvmMember _feature = spec.getFeature();
      String _simpleName = null;
      if (_feature!=null) {
        _simpleName=_feature.getSimpleName();
      }
      boolean _notEquals = (!Objects.equal(_simpleName, null));
      if (_notEquals) {
        XExpression _target = spec.getTarget();
        boolean _equals = Objects.equal(_target, null);
        if (_equals) {
          EList<JvmMember> _members = it.getMembers();
          final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              EList<JvmFormalParameter> _parameters = it.getParameters();
              JvmTypeReference _parameterType = spec.getParameterType();
              JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
                "it", _parameterType);
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
              XExpression _expression = spec.getExpression();
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _expression);
            }
          };
          JvmOperation _control_EClass_EStructuralFeature = this.control_EClass_EStructuralFeature(spec, _function);
          this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _control_EClass_EStructuralFeature);
        } else {
          final String createControlMethodName = this.methodNameForFormFeatureSpecification(spec, "createControl_");
          final String createTargetMethodName = this.methodNameForFormFeatureSpecification(spec, "createTarget_");
          EList<JvmMember> _members_1 = it.getMembers();
          final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              EList<JvmFormalParameter> _parameters = it.getParameters();
              JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(DataBindingContext.class);
              JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
                "dataBindingContext", _typeRef);
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
              EList<JvmFormalParameter> _parameters_1 = it.getParameters();
              JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(IObservableValue.class);
              JvmFormalParameter _parameter_1 = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
                "observableValue", _typeRef_1);
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
              final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                @Override
                public void apply(final ITreeAppendable it) {
                  JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Control.class);
                  JvmType _type = _typeRef.getType();
                  it.append(_type);
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append(" ");
                  _builder.append("control = ");
                  _builder.append(createControlMethodName, " ");
                  _builder.append("();");
                  ITreeAppendable _append = it.append(_builder);
                  _append.newLine();
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("dataBindingContext.bindValue(");
                  _builder_1.newLine();
                  _builder_1.append("\t");
                  _builder_1.append(createTargetMethodName, "\t");
                  _builder_1.append("(control),");
                  _builder_1.newLineIfNotEmpty();
                  _builder_1.append("\t");
                  _builder_1.append("observableValue);");
                  ITreeAppendable _append_1 = it.append(_builder_1);
                  _append_1.newLine();
                  StringConcatenation _builder_2 = new StringConcatenation();
                  _builder_2.append("return control;");
                  it.append(_builder_2);
                }
              };
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _function);
            }
          };
          JvmOperation _control_EClass_EStructuralFeature_1 = this.control_EClass_EStructuralFeature(spec, _function_1);
          this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _control_EClass_EStructuralFeature_1);
          EList<JvmMember> _members_2 = it.getMembers();
          JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Control.class);
          final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              it.setVisibility(JvmVisibility.PROTECTED);
              XExpression _expression = spec.getExpression();
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _expression);
            }
          };
          JvmOperation _method = this._jvmTypesBuilder.toMethod(spec, createControlMethodName, _typeRef, _function_2);
          this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method);
          EList<JvmMember> _members_3 = it.getMembers();
          JvmTypeReference _typeRef_1 = this._typeReferenceBuilder.typeRef(IObservableValue.class);
          final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
            @Override
            public void apply(final JvmOperation it) {
              it.setVisibility(JvmVisibility.PROTECTED);
              EList<JvmFormalParameter> _parameters = it.getParameters();
              JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Control.class);
              JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
                "it", _typeRef);
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
              XExpression _target = spec.getTarget();
              EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _target);
            }
          };
          JvmOperation _method_1 = this._jvmTypesBuilder.toMethod(spec, createTargetMethodName, _typeRef_1, _function_3);
          this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_1);
        }
      }
    }
  }
  
  private JvmGenericType inferViewerContentProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    ViewerContentProvider _viewerContentProvider = element.getViewerContentProvider();
    boolean _equals = Objects.equal(_viewerContentProvider, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final ViewerContentProvider viewerContentProvider = element.getViewerContentProvider();
        String _viewerContentProviderQN = this.viewerContentProviderQN(element);
        final JvmGenericType viewerContentProviderClass = this._jvmTypesBuilder.toClass(viewerContentProvider, _viewerContentProviderQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, viewerContentProvider, org.eclipse.emf.parsley.edit.ui.provider.ViewerContentProvider.class);
            EList<JvmMember> _members = it.getMembers();
            JvmConstructor _constructorWithInjectedAdapterFactory = EmfParsleyDslJvmModelInferrer.this.toConstructorWithInjectedAdapterFactory(viewerContentProvider);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructorWithInjectedAdapterFactory);
            ContentProviderElements _elements = viewerContentProvider.getElements();
            EmfParsleyDslJvmModelInferrer.this.inferContentProviderElements(it, _elements);
            ContentProviderChildren _children = viewerContentProvider.getChildren();
            EmfParsleyDslJvmModelInferrer.this.inferContentProviderChildren(it, _children);
          }
        };
        acceptor.<JvmGenericType>accept(viewerContentProviderClass, _function);
        _xblockexpression = viewerContentProviderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferTableViewerContentProvider(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    TableViewerContentProvider _tableViewerContentProvider = element.getTableViewerContentProvider();
    boolean _equals = Objects.equal(_tableViewerContentProvider, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final TableViewerContentProvider viewerContentProvider = element.getTableViewerContentProvider();
        String _tableViewerContentProviderQN = this.tableViewerContentProviderQN(element);
        final JvmGenericType viewerContentProviderClass = this._jvmTypesBuilder.toClass(viewerContentProvider, _tableViewerContentProviderQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, viewerContentProvider, org.eclipse.emf.parsley.edit.ui.provider.TableViewerContentProvider.class);
            EList<JvmMember> _members = it.getMembers();
            JvmConstructor _constructorWithInjectedAdapterFactory = EmfParsleyDslJvmModelInferrer.this.toConstructorWithInjectedAdapterFactory(viewerContentProvider);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructorWithInjectedAdapterFactory);
            ContentProviderElements _elements = viewerContentProvider.getElements();
            EmfParsleyDslJvmModelInferrer.this.inferContentProviderElements(it, _elements);
          }
        };
        acceptor.<JvmGenericType>accept(viewerContentProviderClass, _function);
        _xblockexpression = viewerContentProviderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private void inferContentProviderElements(final JvmGenericType it, final ContentProviderElements elements) {
    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Object.class);
    this.specificationsToMethods(it, elements, "elements", _typeRef);
  }
  
  private void inferContentProviderChildren(final JvmGenericType it, final ContentProviderChildren children) {
    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Object.class);
    this.specificationsToMethods(it, children, "children", _typeRef);
  }
  
  private <T extends Object> void nullSafeAccess(final JvmGenericType it, final T parent, final Procedure1<? super JvmGenericType> acceptor) {
    boolean _notEquals = (!Objects.equal(parent, null));
    if (_notEquals) {
      acceptor.apply(it);
    }
  }
  
  private JvmConstructor toConstructorWithInjectedAdapterFactory(final EObject e) {
    final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
      @Override
      public void apply(final JvmConstructor it) {
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(AdapterFactory.class);
        JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(e, "adapterFactory", _typeRef);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
          @Override
          public void apply(final ITreeAppendable it) {
            it.append("super(adapterFactory);");
          }
        };
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _function);
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = EmfParsleyDslJvmModelInferrer.this._annotationTypesBuilder.annotationRef(Inject.class);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
      }
    };
    return this._jvmTypesBuilder.toConstructor(e, _function);
  }
  
  private JvmGenericType inferProposalCreator(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    ProposalCreator _proposalCreator = element.getProposalCreator();
    boolean _equals = Objects.equal(_proposalCreator, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final ProposalCreator proposalCreator = element.getProposalCreator();
        String _proposalCreatorQN = this.proposalCreatorQN(element);
        final JvmGenericType proposalCreatorClass = this._jvmTypesBuilder.toClass(proposalCreator, _proposalCreatorQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, proposalCreator, org.eclipse.emf.parsley.composite.ProposalCreator.class);
            EList<FeatureAssociatedExpression> _proposalsSpecifications = proposalCreator.getProposalsSpecifications();
            for (final FeatureAssociatedExpression specification : _proposalsSpecifications) {
              JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(List.class);
              JvmType _type = _typeRef.getType();
              JvmWildcardTypeReference _wildCard = EmfParsleyDslJvmModelInferrer.this._typeReferences.wildCard();
              JvmParameterizedTypeReference _createTypeRef = EmfParsleyDslJvmModelInferrer.this._typeReferences.createTypeRef(_type, _wildCard);
              final Procedure2<JvmOperation, FeatureAssociatedExpression> _function = new Procedure2<JvmOperation, FeatureAssociatedExpression>() {
                @Override
                public void apply(final JvmOperation it, final FeatureAssociatedExpression spec) {
                  EList<JvmFormalParameter> _parameters = it.getParameters();
                  JvmTypeReference _parameterType = spec.getParameterType();
                  JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
                    "it", _parameterType);
                  EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
                  EList<JvmFormalParameter> _parameters_1 = it.getParameters();
                  JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(EStructuralFeature.class);
                  JvmFormalParameter _parameter_1 = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(spec, 
                    "feature", _typeRef);
                  EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
                }
              };
              EmfParsleyDslJvmModelInferrer.this.featureAssociatedExpressionToMethod(it, specification, "proposals_", _createTypeRef, _function);
            }
          }
        };
        acceptor.<JvmGenericType>accept(proposalCreatorClass, _function);
        _xblockexpression = proposalCreatorClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferMenuBuilder(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    MenuBuilder _menuBuilder = element.getMenuBuilder();
    boolean _equals = Objects.equal(_menuBuilder, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final MenuBuilder menuBuilder = element.getMenuBuilder();
        String _menuBuilderQN = this.menuBuilderQN(element);
        final JvmGenericType menuBuilderClass = this._jvmTypesBuilder.toClass(menuBuilder, _menuBuilderQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, menuBuilder, EditingMenuBuilder.class);
            JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(IMenuContributionSpecification.class);
            final JvmTypeReference returnType = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(List.class, _typeRef);
            Menus _menus = menuBuilder.getMenus();
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _menus, "menuContributions", returnType);
            EmfMenus _emfMenus = menuBuilder.getEmfMenus();
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _emfMenus, "emfMenuContributions", returnType);
          }
        };
        acceptor.<JvmGenericType>accept(menuBuilderClass, _function);
        _xblockexpression = menuBuilderClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferConfigurator(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    Configurator _configurator = element.getConfigurator();
    boolean _equals = Objects.equal(_configurator, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final Configurator configurator = element.getConfigurator();
        String _configuratorQN = this.configuratorQN(element);
        final JvmGenericType configuratorClass = this._jvmTypesBuilder.toClass(configurator, _configuratorQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, configurator, org.eclipse.emf.parsley.config.Configurator.class);
            ConfiguratorResourceURI _resourceURI = configurator.getResourceURI();
            JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(URI.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _resourceURI, "resourceURI", _typeRef);
            ConfiguratorEClass _eClassSpec = configurator.getEClassSpec();
            JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(EClass.class);
            EmfParsleyDslJvmModelInferrer.this.specificationsToMethods(it, _eClassSpec, "eClass", _typeRef_1);
          }
        };
        acceptor.<JvmGenericType>accept(configuratorClass, _function);
        _xblockexpression = configuratorClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private JvmGenericType inferResourceManager(final Module element, final IJvmDeclaredTypeAcceptor acceptor) {
    JvmGenericType _xifexpression = null;
    ResourceManager _resourceManager = element.getResourceManager();
    boolean _equals = Objects.equal(_resourceManager, null);
    if (_equals) {
      _xifexpression = null;
    } else {
      JvmGenericType _xblockexpression = null;
      {
        final ResourceManager resourceManager = element.getResourceManager();
        String _resourceManagerQN = this.resourceManagerQN(element);
        final JvmGenericType resourceManagerClass = this._jvmTypesBuilder.toClass(resourceManager, _resourceManagerQN);
        final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          @Override
          public void apply(final JvmGenericType it) {
            EmfParsleyDslJvmModelInferrer.this.setSuperClassTypeAndFields(it, resourceManager, org.eclipse.emf.parsley.resource.ResourceManager.class);
            SimpleMethodSpecification _initializeBody = resourceManager.getInitializeBody();
            JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE);
            EmfParsleyDslJvmModelInferrer.this.resourceManagerElementToMethod(it, _initializeBody, "initialize", _typeRef, null);
            SimpleMethodSpecification _saveBody = resourceManager.getSaveBody();
            JvmTypeReference _typeRef_1 = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Boolean.TYPE);
            final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation it) {
                EList<JvmTypeReference> _exceptions = it.getExceptions();
                JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(IOException.class);
                EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
              }
            };
            EmfParsleyDslJvmModelInferrer.this.resourceManagerElementToMethod(it, _saveBody, "save", _typeRef_1, _function);
          }
        };
        acceptor.<JvmGenericType>accept(resourceManagerClass, _function);
        _xblockexpression = resourceManagerClass;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private boolean resourceManagerElementToMethod(final JvmDeclaredType it, final SimpleMethodSpecification m, final String methodName, final JvmTypeReference returnType, final Procedure1<? super JvmOperation> additionalSetup) {
    boolean _xifexpression = false;
    boolean _notEquals = (!Objects.equal(m, null));
    if (_notEquals) {
      boolean _xblockexpression = false;
      {
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            EmfParsleyDslJvmModelInferrer.this.addOverrideAnnotation(it);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _typeRef = EmfParsleyDslJvmModelInferrer.this._typeReferenceBuilder.typeRef(Resource.class);
            JvmFormalParameter _parameter = EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.toParameter(m, "it", _typeRef);
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            XExpression _body = m.getBody();
            EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _body);
          }
        };
        final JvmOperation method = this._jvmTypesBuilder.toMethod(m, methodName, returnType, _function);
        if (additionalSetup!=null) {
          additionalSetup.apply(method);
        }
        EList<JvmMember> _members = it.getMembers();
        _xblockexpression = this._jvmTypesBuilder.<JvmOperation>operator_add(_members, method);
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private void specificationsToMethods(final JvmGenericType it, final WithExpressions e, final String methodName, final JvmTypeReference returnType) {
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        EList<PolymorphicSpecification> _specifications = e.getSpecifications();
        for (final PolymorphicSpecification specification : _specifications) {
          EList<JvmMember> _members = it.getMembers();
          JvmOperation _specificationToMethod = EmfParsleyDslJvmModelInferrer.this.specificationToMethod(specification, methodName, returnType);
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _specificationToMethod);
        }
      }
    };
    this.<WithExpressions>nullSafeAccess(it, e, _function);
  }
  
  private JvmOperation specificationToMethod(final PolymorphicSpecification specification, final String methodName, final JvmTypeReference returnType) {
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      @Override
      public void apply(final JvmOperation it) {
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmFormalParameter _specificationParameter = EmfParsleyDslJvmModelInferrer.this.specificationParameter(specification);
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _specificationParameter);
        XExpression _expression = specification.getExpression();
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _expression);
      }
    };
    return this._jvmTypesBuilder.toMethod(specification, methodName, returnType, _function);
  }
  
  private JvmFormalParameter specificationParameter(final PolymorphicSpecification specification) {
    String _xifexpression = null;
    String _name = specification.getName();
    boolean _notEquals = (!Objects.equal(_name, null));
    if (_notEquals) {
      _xifexpression = specification.getName();
    } else {
      _xifexpression = "it";
    }
    JvmTypeReference _parameterType = specification.getParameterType();
    return this._jvmTypesBuilder.toParameter(specification, _xifexpression, _parameterType);
  }
  
  private JvmOperation control_EClass_EStructuralFeature(final ControlFactorySpecification spec, final Procedure1<? super JvmOperation> init) {
    String _methodNameForFormFeatureSpecification = this.methodNameForFormFeatureSpecification(spec, "control_");
    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Control.class);
    return this._jvmTypesBuilder.toMethod(spec, _methodNameForFormFeatureSpecification, _typeRef, init);
  }
  
  private String methodNameForFormFeatureSpecification(final ControlFactorySpecification spec, final String prefix) {
    JvmTypeReference _parameterType = spec.getParameterType();
    String _simpleName = _parameterType.getSimpleName();
    String _plus = (prefix + _simpleName);
    String _plus_1 = (_plus + "_");
    JvmMember _feature = spec.getFeature();
    String _simpleName_1 = _feature.getSimpleName();
    String _propertyNameForGetterSetterMethod = this._emfParsleyDslGeneratorUtils.getPropertyNameForGetterSetterMethod(_simpleName_1);
    return (_plus_1 + _propertyNameForGetterSetterMethod);
  }
  
  private JvmOperation genBindMethod(final EObject element, final JvmGenericType type, final Class<?> clazz) {
    JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(clazz);
    final IAcceptor<JvmExecutable> _function = new IAcceptor<JvmExecutable>() {
      @Override
      public void accept(final JvmExecutable it) {
        final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
          @Override
          public void apply(final ITreeAppendable it) {
            it.append("return ");
            it.append(type);
            it.append(".class;");
          }
        };
        EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _function);
      }
    };
    return this.genBindMethod(element, _typeRef, true, _function);
  }
  
  private void handleBindingsSpecification(final JvmGenericType it, final BindingsSpecification bindingsSpecification) {
    EList<Binding> _bindings = bindingsSpecification.getBindings();
    for (final Binding binding : _bindings) {
      {
        JvmOperation method = null;
        if ((binding instanceof TypeBinding)) {
          JvmOperation _genBindMethod = this.genBindMethod(it, ((TypeBinding)binding));
          method = _genBindMethod;
        } else {
          if ((binding instanceof ProviderBinding)) {
            JvmOperation _genProvideMethod = this.genProvideMethod(it, ((ProviderBinding)binding));
            method = _genProvideMethod;
          } else {
            if ((binding instanceof ValueBinding)) {
              JvmOperation _genValueMethod = this.genValueMethod(it, ((ValueBinding)binding));
              method = _genValueMethod;
            }
          }
        }
        boolean _notEquals = (!Objects.equal(method, null));
        if (_notEquals) {
          EList<JvmMember> _members = it.getMembers();
          this._jvmTypesBuilder.<JvmOperation>operator_add(_members, method);
        }
      }
    }
  }
  
  private JvmOperation genBindMethod(final JvmGenericType it, final TypeBinding typeBinding) {
    JvmOperation _xblockexpression = null;
    {
      JvmTypeReference _typeToBind = typeBinding.getTypeToBind();
      boolean _equals = Objects.equal(_typeToBind, null);
      if (_equals) {
        return null;
      }
      JvmTypeReference _typeToBind_1 = typeBinding.getTypeToBind();
      JvmType _type = _typeToBind_1.getType();
      JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type);
      final IAcceptor<JvmExecutable> _function = new IAcceptor<JvmExecutable>() {
        @Override
        public void accept(final JvmExecutable it) {
          XExpression _to = typeBinding.getTo();
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _to);
        }
      };
      _xblockexpression = this.genBindMethod(it, typeBinding, _typeRef, _function);
    }
    return _xblockexpression;
  }
  
  private JvmOperation genProvideMethod(final JvmGenericType it, final ProviderBinding binding) {
    JvmOperation _xblockexpression = null;
    {
      JvmTypeReference _type = binding.getType();
      boolean _equals = Objects.equal(_type, null);
      if (_equals) {
        return null;
      }
      JvmTypeReference _type_1 = binding.getType();
      JvmType _type_2 = _type_1.getType();
      JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(_type_2);
      final IAcceptor<JvmExecutable> _function = new IAcceptor<JvmExecutable>() {
        @Override
        public void accept(final JvmExecutable it) {
          XExpression _to = binding.getTo();
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _to);
        }
      };
      _xblockexpression = this.genProvideMethod(it, binding, _typeRef, _function);
    }
    return _xblockexpression;
  }
  
  private JvmOperation genValueMethod(final JvmGenericType it, final ValueBinding binding) {
    JvmOperation _xblockexpression = null;
    {
      boolean _or = false;
      JvmTypeReference _typeDecl = binding.getTypeDecl();
      boolean _equals = Objects.equal(_typeDecl, null);
      if (_equals) {
        _or = true;
      } else {
        String _id = binding.getId();
        boolean _equals_1 = Objects.equal(_id, null);
        _or = _equals_1;
      }
      if (_or) {
        return null;
      }
      String _id_1 = binding.getId();
      JvmTypeReference _typeDecl_1 = binding.getTypeDecl();
      final IAcceptor<JvmExecutable> _function = new IAcceptor<JvmExecutable>() {
        @Override
        public void accept(final JvmExecutable it) {
          XExpression _to = binding.getTo();
          EmfParsleyDslJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _to);
        }
      };
      _xblockexpression = this.genValueMethod(it, binding, _id_1, _typeDecl_1, _function);
    }
    return _xblockexpression;
  }
  
  private JvmOperation genBindMethod(final EObject element, final JvmTypeReference typeRefToBind, final boolean shouldOverride, final IAcceptor<JvmExecutable> acceptor) {
    String _simpleName = typeRefToBind.getSimpleName();
    String _plus = ("bind" + _simpleName);
    JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(typeRefToBind);
    return this.genMethodForGuiceModuleWithWildcard(element, _plus, _cloneWithProxies, shouldOverride, acceptor);
  }
  
  private JvmOperation genBindMethod(final JvmGenericType it, final EObject element, final JvmTypeReference typeRefToBind, final IAcceptor<JvmExecutable> acceptor) {
    JvmOperation _xblockexpression = null;
    {
      String _simpleName = typeRefToBind.getSimpleName();
      final String methodName = ("bind" + _simpleName);
      JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(typeRefToBind);
      boolean _shouldOverride = this.shouldOverride(it, methodName);
      _xblockexpression = this.genMethodForGuiceModuleWithWildcard(element, methodName, _cloneWithProxies, _shouldOverride, acceptor);
    }
    return _xblockexpression;
  }
  
  private JvmOperation genProvideMethod(final JvmGenericType it, final EObject element, final JvmTypeReference typeRefToBind, final IAcceptor<JvmExecutable> acceptor) {
    JvmOperation _xblockexpression = null;
    {
      String _simpleName = typeRefToBind.getSimpleName();
      final String methodName = ("provide" + _simpleName);
      JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(typeRefToBind);
      JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Provider.class, _cloneWithProxies);
      boolean _shouldOverride = this.shouldOverride(it, methodName);
      _xblockexpression = this.genMethodForGuiceModuleWithWildcard(element, methodName, _typeRef, _shouldOverride, acceptor);
    }
    return _xblockexpression;
  }
  
  private JvmOperation genValueMethod(final JvmGenericType it, final EObject element, final String name, final JvmTypeReference typeRefToBind, final IAcceptor<JvmExecutable> acceptor) {
    JvmOperation _xblockexpression = null;
    {
      final String methodName = ("value" + name);
      JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(typeRefToBind);
      boolean _shouldOverride = this.shouldOverride(it, methodName);
      _xblockexpression = this.genMethodForGuiceModule(element, methodName, _cloneWithProxies, _shouldOverride, acceptor);
    }
    return _xblockexpression;
  }
  
  private JvmOperation genMethodForGuiceModuleWithWildcard(final EObject element, final String methodName, final JvmTypeReference typeRefToBind, final boolean shouldOverride, final IAcceptor<JvmExecutable> acceptor) {
    JvmOperation _xblockexpression = null;
    {
      final JvmWildcardTypeReference wildCard = this._typesFactory.createJvmWildcardTypeReference();
      final JvmUpperBound upperBound = this._typesFactory.createJvmUpperBound();
      JvmTypeReference _cloneWithProxies = this._jvmTypesBuilder.cloneWithProxies(typeRefToBind);
      upperBound.setTypeReference(_cloneWithProxies);
      EList<JvmTypeConstraint> _constraints = wildCard.getConstraints();
      this._jvmTypesBuilder.<JvmUpperBound>operator_add(_constraints, upperBound);
      JvmTypeReference _typeRef = this._typeReferenceBuilder.typeRef(Class.class, wildCard);
      _xblockexpression = this.genMethodForGuiceModule(element, methodName, _typeRef, shouldOverride, acceptor);
    }
    return _xblockexpression;
  }
  
  private JvmOperation genMethodForGuiceModule(final EObject element, final String methodName, final JvmTypeReference typeRefToBind, final boolean shouldOverride, final IAcceptor<JvmExecutable> acceptor) {
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      @Override
      public void apply(final JvmOperation it) {
        if (shouldOverride) {
          EmfParsleyDslJvmModelInferrer.this.addOverrideAnnotation(it);
        }
        acceptor.accept(it);
      }
    };
    return this._jvmTypesBuilder.toMethod(element, methodName, typeRefToBind, _function);
  }
  
  private boolean shouldOverride(final JvmGenericType it, final String methodName) {
    Iterable<JvmFeature> _allFeatures = it.getAllFeatures();
    Iterable<JvmOperation> _filter = Iterables.<JvmOperation>filter(_allFeatures, JvmOperation.class);
    final Function1<JvmOperation, Boolean> _function = new Function1<JvmOperation, Boolean>() {
      @Override
      public Boolean apply(final JvmOperation it) {
        String _simpleName = it.getSimpleName();
        return Boolean.valueOf(Objects.equal(_simpleName, methodName));
      }
    };
    return IterableExtensions.<JvmOperation>exists(_filter, _function);
  }
  
  private boolean addOverrideAnnotation(final JvmOperation it) {
    EList<JvmAnnotationReference> _annotations = it.getAnnotations();
    JvmAnnotationReference _annotationRef = this._annotationTypesBuilder.annotationRef(Override.class);
    return this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
  }
  
  public void infer(final EObject element, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPreIndexingPhase) {
    if (element instanceof Module) {
      _infer((Module)element, acceptor, isPreIndexingPhase);
      return;
    } else if (element != null) {
      _infer(element, acceptor, isPreIndexingPhase);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(element, acceptor, isPreIndexingPhase).toString());
    }
  }
}
