/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.viewers;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider;
import org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider;
import org.eclipse.emf.parsley.viewers.ColumnLabelProviderFactory;
import org.eclipse.emf.parsley.viewers.LayoutHelper;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableViewerColumnBuilder {
    @Inject
    @Named(value="DefaultTableColumnWeight")
    private int defaultWeight;
    @Inject
    @Named(value="TableColumnWeights")
    private List<Integer> weights;
    @Inject
    private ColumnLabelProviderFactory columnLabelProviderFactory;
    @Inject
    private FeatureCaptionProvider featureCaptionProvider;
    @Inject
    private TableFeaturesProvider featuresProvider;
    @Inject
    private LayoutHelper layoutHelper;

    public void buildTableViewer(TableViewer tableViewer, EClass eClass) {
        Layout layout = this.layoutHelper.adjustForTableLayout(tableViewer);
        List<EStructuralFeature> typeFeatures = this.featuresProvider.getFeatures(eClass);
        int i = 0;
        for (EStructuralFeature eStructuralFeature : typeFeatures) {
            int weight = this.defaultWeight;
            if (this.weights.size() > i) {
                weight = this.weights.get(i++);
            }
            this.buildTableViewerColumn(tableViewer, layout, eClass, eStructuralFeature, weight);
        }
    }

    protected TableViewerColumn buildTableViewerColumn(TableViewer tableViewer, Layout layout, EClass eClass, EStructuralFeature eStructuralFeature, int weight) {
        TableViewerColumn viewerColumn = this.createTableViewerColumn(tableViewer, eStructuralFeature);
        TableColumn objectColumn = viewerColumn.getColumn();
        this.layoutHelper.adjustLayoutColumnData(layout, (Widget)objectColumn, weight);
        objectColumn.setText(this.featureCaptionProvider.getText(eClass, eStructuralFeature));
        objectColumn.setResizable(true);
        return viewerColumn;
    }

    protected TableViewerColumn createTableViewerColumn(TableViewer tableViewer, EStructuralFeature eStructuralFeature) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)this.columnLabelProviderFactory.createColumnLabelProvider(eStructuralFeature));
        return tableViewerColumn;
    }
}

